/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.network;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.pubnative.api.core.utils.PNAPISystemUtils;
import net.pubnative.sdk.core.utils.PNDeviceUtils;

public class PNAPIHttpRequest {
    private static final String TAG = PNAPIHttpRequest.class.getSimpleName();
    public static final int HTTP_OK = 200;
    public static final int HTTP_INVALID_REQUEST = 422;
    protected static int sConnectionTimeout = 4000;
    protected Listener mListener;
    protected Handler mHandler;

    public static void setConnectionTimeout(int n) {
        sConnectionTimeout = n;
    }

    public void start(Context context, final String string, Listener listener) {
        this.mListener = listener;
        this.mHandler = new Handler(Looper.getMainLooper());
        if (this.mListener == null) {
            Log.w((String)TAG, (String)"Warning: null listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.invokeFail(new IllegalArgumentException("PNAPIHttpRequest - Error: null or empty url, dropping call"));
        } else if (PNDeviceUtils.isNetworkAvailable(context)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    String string2 = PNAPISystemUtils.getWebViewUserAgent();
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        PNAPIHttpRequest.this.invokeFail(new Exception("PNAPIHttpRequest - Error: User agent cannot be retrieved"));
                    } else {
                        PNAPIHttpRequest.this.initiateRequest(string, string2);
                    }
                }
            });
        } else {
            this.invokeFail(new Exception("PNAPIHttpRequest - Error: internet connection not detected, dropping call"));
        }
    }

    private void initiateRequest(final String string, final String string2) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PNAPIHttpRequest.this.doRequest(string, string2);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(String string, String string2) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", string2);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(sConnectionTimeout);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            InputStream inputStream = httpURLConnection.getInputStream();
            String string3 = this.getString(inputStream);
            inputStream.close();
            this.invokeFinish(string3, n);
        }
        catch (Exception exception) {
            this.invokeFail(exception);
        }
        catch (Error error) {
            this.invokeFail(new Exception("Request finished with the error!", error));
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(InputStream inputStream) {
        String string = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (IOException iOException) {
            stringBuilder = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    protected void invokeFinish(final String string, final int n) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNAPIHttpRequest.this.mListener != null) {
                    PNAPIHttpRequest.this.mListener.onPNAPIHttpRequestFinish(PNAPIHttpRequest.this, string, n);
                }
            }
        });
    }

    protected void invokeFail(final Exception exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PNAPIHttpRequest.this.mListener != null) {
                    PNAPIHttpRequest.this.mListener.onPNAPIHttpRequestFail(PNAPIHttpRequest.this, exception);
                }
            }
        });
    }

    public static interface Listener {
        public void onPNAPIHttpRequestFinish(PNAPIHttpRequest var1, String var2, int var3);

        public void onPNAPIHttpRequestFail(PNAPIHttpRequest var1, Exception var2);
    }
}

