/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.request;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import net.pubnative.sdk.core.config.model.PNConfigModel;
import net.pubnative.sdk.core.config.model.PNPlacementModel;
import net.pubnative.sdk.core.request.PNAdModel;
import net.pubnative.sdk.core.request.PNAdModelCache;
import net.pubnative.sdk.core.request.PNRequest;
import net.pubnative.sdk.core.request.PNRequestCache;

public class PNCacheManager {
    private static final String TAG = PNCacheManager.class.getSimpleName();
    protected static Map<String, PNAdModelCache[]> sCacheArray = new HashMap<String, PNAdModelCache[]>();

    public static synchronized void cachePlacement(Context context, String string, String string2, PNConfigModel pNConfigModel) {
        if (context == null) {
            Log.w((String)TAG, (String)"context is null and required, dropping call");
        } else if (pNConfigModel == null) {
            Log.w((String)TAG, (String)"config is null or empty and required, dropping call");
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"app token is null and required, dropping call");
        } else if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.w((String)TAG, (String)"placement is null and required, dropping call");
        } else {
            PNPlacementModel pNPlacementModel = pNConfigModel.getPlacement(string2);
            if (pNPlacementModel != null && pNPlacementModel.ad_cache && pNPlacementModel.priority_rules.size() > 0 && !pNPlacementModel.delivery_rule.isDisabled()) {
                sCacheArray.put(string2, new PNAdModelCache[pNPlacementModel.priority_rules.size()]);
                PNRequestCache pNRequestCache = new PNRequestCache();
                pNRequestCache.start(context, string, string2, new PNRequest.Listener(){

                    @Override
                    public void onPNRequestLoadFinish(PNRequest pNRequest, PNAdModel pNAdModel) {
                        PNCacheManager.cacheAd(pNRequest.mPlacement.getName(), pNRequest.mPlacement.getCurrentNetworkIndex(), pNRequest.mPlacement.getCurrentNetwork().getCacheExpirationTime(), pNAdModel);
                    }

                    @Override
                    public void onPNRequestLoadFail(PNRequest pNRequest, Exception exception) {
                    }
                });
            }
        }
    }

    public static PNAdModelCache getCachedAd(String string, int n) {
        PNAdModelCache pNAdModelCache = PNCacheManager.getNetworkCache(string, n);
        PNCacheManager.setNetworkCache(string, n, null);
        PNCacheManager.cleanPlacement(string);
        return pNAdModelCache;
    }

    public static boolean isPlacementCached(String string) {
        return PNCacheManager.getPlacementCache(string) != null;
    }

    public static void cleanCache() {
        sCacheArray = new HashMap<String, PNAdModelCache[]>();
    }

    protected static void cleanPlacement(String string) {
        PNAdModelCache[] pNAdModelCacheArray = PNCacheManager.getPlacementCache(string);
        if (pNAdModelCacheArray != null) {
            for (int i = 0; i < pNAdModelCacheArray.length; ++i) {
                PNAdModelCache pNAdModelCache = pNAdModelCacheArray[i];
                if (pNAdModelCache == null || pNAdModelCache.isValid()) continue;
                pNAdModelCacheArray[i] = null;
            }
            PNCacheManager.setPlacementCache(string, pNAdModelCacheArray);
        }
    }

    protected static void cacheAd(String string, int n, Integer n2, PNAdModel pNAdModel) {
        PNAdModelCache[] pNAdModelCacheArray = PNCacheManager.getPlacementCache(string);
        if (string == null) {
            Log.w((String)TAG, (String)"placement fetchAssets not found, cannot set network fetchAssets");
        } else if (pNAdModel == null) {
            Log.w((String)TAG, (String)"caching null ad, ignoring it");
        } else if (n < pNAdModelCacheArray.length) {
            PNAdModelCache pNAdModelCache = null;
            if (pNAdModel != null) {
                pNAdModelCache = new PNAdModelCache();
                pNAdModelCache.ad = pNAdModel;
                pNAdModelCache.ad_expiration = n2 == null ? 0 : n2;
            }
            PNCacheManager.setNetworkCache(string, n, pNAdModelCache);
        } else {
            Log.e((String)TAG, (String)"invalid given network index, cannot set network fetchAssets");
        }
    }

    protected static PNAdModelCache[] getPlacementCache(String string) {
        PNAdModelCache[] pNAdModelCacheArray = null;
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"placement name is null or empty and required, cannot retrieve placement fetchAssets");
        } else {
            pNAdModelCacheArray = sCacheArray.get(string);
        }
        return pNAdModelCacheArray;
    }

    protected static PNAdModelCache getNetworkCache(String string, int n) {
        PNAdModelCache pNAdModelCache = null;
        PNAdModelCache[] pNAdModelCacheArray = PNCacheManager.getPlacementCache(string);
        if (pNAdModelCacheArray == null) {
            Log.w((String)TAG, (String)"network fetchAssets cannot be retrieved because placement fetchAssets cannot be found");
        } else if (n < pNAdModelCacheArray.length) {
            pNAdModelCache = pNAdModelCacheArray[n];
        } else {
            Log.w((String)TAG, (String)"invalid networkIndex provided");
        }
        return pNAdModelCache;
    }

    protected static void setPlacementCache(String string, PNAdModelCache[] pNAdModelCacheArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"placement name is null or empty and required, cannot set placement fetchAssets");
        } else {
            sCacheArray.put(string, pNAdModelCacheArray);
        }
    }

    protected static void setNetworkCache(String string, int n, PNAdModelCache pNAdModelCache) {
        PNAdModelCache[] pNAdModelCacheArray = PNCacheManager.getPlacementCache(string);
        if (pNAdModelCacheArray == null) {
            Log.w((String)TAG, (String)"placement fetchAssets cannot be found, cannot set network fetchAssets");
        } else if (n < pNAdModelCacheArray.length) {
            pNAdModelCacheArray[n] = pNAdModelCache;
            PNCacheManager.setPlacementCache(string, pNAdModelCacheArray);
        } else {
            Log.w((String)TAG, (String)"invalid given network index, cannot set network fetchAssets");
        }
    }
}

