/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.exceptions;

import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PNException
extends Exception {
    public static final String TAG = PNException.class.getSimpleName();
    public static final PNException REQUEST_NO_INTERNET = new PNException(1000, "Internet connection is not available");
    public static final PNException REQUEST_PARAMETERS_INVALID = new PNException(1001, "Invalid execute parameters");
    public static final PNException REQUEST_NO_FILL = new PNException(1002, "No fill");
    public static final PNException REQUEST_CONFIG_INVALID = new PNException(1005, "Null or invalid config");
    public static final PNException REQUEST_CONFIG_EMPTY = new PNException(1006, "Retrieved config contains null element");
    public static final PNException REQUEST_LOADING = new PNException(1007, "Currently loading");
    public static final PNException REQUEST_SHOWN = new PNException(1008, "Already shown");
    public static final PNException ADAPTER_MISSING_DATA = new PNException(2000, "Null context or adapter data provided");
    public static final PNException ADAPTER_ILLEGAL_ARGUMENTS = new PNException(2001, "Invalid data provided");
    public static final PNException ADAPTER_TIMEOUT = new PNException(2002, "adapter timeout");
    public static final PNException ADAPTER_NOT_FOUND = new PNException(2003, "adapter not found");
    public static final PNException ADAPTER_TYPE_NOT_IMPLEMENTED = new PNException(2004, "adapter doesn't implements this type");
    public static final PNException ADAPTER_NO_FILL = new PNException(2005, "adapter did not fill the request");
    public static final PNException PLACEMENT_FREQUENCY_CAP = new PNException(3001, "Too many ads: frequency");
    public static final PNException PLACEMENT_PACING_CAP = new PNException(3002, "Too many ads: pacing");
    public static final PNException PLACEMENT_DISABLED = new PNException(3003, "Placement is disabled");
    public static final PNException PLACEMENT_NOT_FOUND = new PNException(3004, "Placement not found");
    protected int mErrorCode;
    protected Map mExtraMap;

    public PNException(int n, String string) {
        super(string);
        this.mErrorCode = n;
    }

    public PNException(int n, Exception exception) {
        super(exception);
        this.mErrorCode = n;
    }

    public static PNException extraException(Map map) {
        PNException pNException = new PNException(0, "extra exception");
        pNException.mExtraMap = map;
        return pNException;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object.getClass().isAssignableFrom(PNException.class)) {
            PNException pNException = (PNException)object;
            bl = pNException.getErrorCode() == this.mErrorCode;
        }
        return bl;
    }

    @Override
    public String getMessage() {
        return String.valueOf("PNException (" + this.getErrorCode() + "): " + super.getMessage());
    }

    @Override
    public String toString() {
        String string;
        try {
            StringBuilder stringBuilder;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", this.getErrorCode());
            jSONObject.put("message", (Object)super.getMessage());
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                stringBuilder = new StringBuilder();
                for (StackTraceElement stackTraceElement : this.getStackTrace()) {
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append('\n');
                }
                jSONObject.put("stackTrace", (Object)stringBuilder.toString());
            }
            if (this.mExtraMap != null) {
                stringBuilder = new JSONObject();
                for (Object e : this.mExtraMap.keySet()) {
                    stringBuilder.put(e.toString(), this.mExtraMap.get(e));
                }
                jSONObject.put("extraData", (Object)stringBuilder);
            }
            string = jSONObject.toString();
        }
        catch (JSONException jSONException) {
            string = this.getMessage();
        }
        return string;
    }
}

