/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.utils;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class PNStringUtils {
    private static String TAG = PNStringUtils.class.getSimpleName();
    private static Gson mGson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)("readStringFromInputStream - Error:" + iOException));
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)("readStringFromInputStream - Error:" + iOException));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static <T> List<T> convertStringToObjects(String string, Class<T> clazz) {
        if (mGson == null) {
            mGson = new Gson();
        }
        JsonArray jsonArray = new JsonParser().parse(string).getAsJsonArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(jsonArray.size());
        for (JsonElement jsonElement : jsonArray) {
            arrayList.add(mGson.fromJson(jsonElement, clazz));
        }
        return arrayList;
    }

    public static <T> T convertStringToObject(String string, Class<T> clazz) {
        if (mGson == null) {
            mGson = new Gson();
        }
        JsonObject jsonObject = new JsonParser().parse(string).getAsJsonObject();
        Object object = mGson.fromJson((JsonElement)jsonObject, clazz);
        return (T)object;
    }

    public static <T> String convertObjectsToJson(List<T> list) {
        String string = null;
        StringWriter stringWriter = new StringWriter();
        if (mGson == null) {
            mGson = new Gson();
        }
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.beginArray();
            for (T t : list) {
                mGson.toJson(t, t.getClass(), jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.close();
            ((Writer)stringWriter).flush();
            string = ((Object)stringWriter).toString();
            ((Writer)stringWriter).close();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"convertObjectsToJson: ", (Throwable)iOException);
        }
        return string;
    }
}

