/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;

public class PNDeviceUtils {
    private static String TAG = PNDeviceUtils.class.getSimpleName();

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("getPackageInfo - Error:" + exception));
        }
        return packageInfo;
    }

    protected static NetworkInfo getActiveNetworkInfo(Context context) {
        NetworkInfo networkInfo = null;
        Context context2 = context.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context2.getSystemService("connectivity");
        if (connectivityManager == null) {
            Log.w((String)TAG, (String)"ERROR: Couldn't retrieve valid ConnectivityManager, please ensure that you added `ACCESS_NETWORK_STATE` permission to your Manifest file");
        } else {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        return networkInfo;
    }

    public static boolean isNetworkAvailable(Context context) {
        boolean bl = false;
        NetworkInfo networkInfo = PNDeviceUtils.getActiveNetworkInfo(context);
        if (networkInfo == null) {
            Log.w((String)TAG, (String)"ERROR: Couldn't retrieve valid NetworkInfo, please ensure that you added `ACCESS_NETWORK_STATE` permission to your Manifest file");
        } else {
            bl = networkInfo.isConnectedOrConnecting();
        }
        return bl;
    }

    public static ConnectionType getConnectionType(Context context) {
        ConnectionType connectionType = ConnectionType.UNKNOWN;
        NetworkInfo networkInfo = PNDeviceUtils.getActiveNetworkInfo(context);
        if (networkInfo != null && networkInfo.isConnected()) {
            connectionType = ConnectionType.CELLULAR;
            if (networkInfo.getType() == 1) {
                connectionType = ConnectionType.WIFI;
            }
        }
        return connectionType;
    }

    public static boolean isTablet(Context context) {
        boolean bl = (context.getResources().getConfiguration().screenLayout & 0xF) == 4;
        boolean bl2 = (context.getResources().getConfiguration().screenLayout & 0xF) == 3;
        return bl || bl2;
    }

    public static int convertDpToPixel(float f, Context context) {
        int n = (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return n;
    }

    public static int convertPxToDp(float f, Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static enum ConnectionType {
        UNKNOWN,
        CELLULAR,
        WIFI;

    }
}

