/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.config.model;

import android.content.Context;
import java.util.Calendar;
import java.util.List;
import net.pubnative.sdk.core.config.PNDeliveryManager;

public class PNDeliveryRuleModel {
    private static final String TAG = PNDeliveryRuleModel.class.getSimpleName();
    public int imp_cap_day;
    public int imp_cap_hour;
    public int pacing_cap_hour;
    public int pacing_cap_minute;
    public boolean no_ads;
    public List<Integer> segment_ids;

    public boolean isDisabled() {
        return this.no_ads;
    }

    public boolean isDayImpressionCapActive() {
        return this.imp_cap_day > 0;
    }

    public boolean isHourImpressionCapActive() {
        return this.imp_cap_hour > 0;
    }

    public boolean isPacingCapActive() {
        return this.pacing_cap_hour > 0 || this.pacing_cap_minute > 0;
    }

    public Calendar getPacingOverdueCalendar() {
        Calendar calendar = null;
        if (this.isPacingCapActive()) {
            calendar = Calendar.getInstance();
            if (this.pacing_cap_minute > 0) {
                calendar.add(12, -this.pacing_cap_minute);
            } else {
                calendar.add(11, -this.pacing_cap_hour);
            }
        }
        return calendar;
    }

    public boolean isFrequencyCapReached(Context context, String string) {
        boolean bl = false;
        if (this.isDayImpressionCapActive()) {
            boolean bl2 = bl = this.imp_cap_day <= PNDeliveryManager.getCurrentDailyCount(context, string);
        }
        if (!bl && this.isHourImpressionCapActive()) {
            bl = this.imp_cap_hour <= PNDeliveryManager.getCurrentHourlyCount(context, string);
        }
        return bl;
    }
}

