/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.layouts.asset_group;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.core.utils.PNAPIImageDownloader;
import net.pubnative.api.layouts.PNAPILayoutView;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroup;
import net.pubnative.player.VASTParser;
import net.pubnative.player.VASTPlayer;
import net.pubnative.player.model.VASTModel;
import net.pubnative.sdk.R;

public class PNAPIAssetGroup3
extends PNAPIAssetGroup
implements PNAPIAdModel.Listener,
VASTPlayer.Listener {
    protected RelativeLayout mRoot;
    protected RelativeLayout mHeader;
    protected RelativeLayout mBody;
    protected RelativeLayout mFooter;
    protected TextView mTitle;
    protected TextView mDescription;
    protected TextView mCallToAction;
    protected ImageView mIcon;
    protected RatingBar mRating;
    protected VASTPlayer mPlayer;
    protected RelativeLayout mContentInfo;
    protected PNAPILayoutView.IDMap mIdMap;

    public PNAPIAssetGroup3(Context context) {
        super(context);
    }

    @Override
    public void load() {
        this.loadView();
        this.mTitle.setText((CharSequence)this.mAdModel.getTitle());
        this.mRating.setRating((float)this.mAdModel.getRating());
        this.mDescription.setText((CharSequence)this.mAdModel.getDescription());
        this.mCallToAction.setText((CharSequence)this.mAdModel.getCtaText());
        this.mPlayer.setListener((VASTPlayer.Listener)this);
        this.mPlayer.onMuteClick();
        PNAPIImageDownloader pNAPIImageDownloader = new PNAPIImageDownloader();
        pNAPIImageDownloader.load(this.mAdModel.getIconUrl(), new PNAPIImageDownloader.Listener(){

            @Override
            public void onImageLoad(String string, Bitmap bitmap) {
                PNAPIAssetGroup3.this.mIcon.setImageBitmap(bitmap);
                new VASTParser(PNAPIAssetGroup3.this.getContext()).setListener(new VASTParser.Listener(){

                    public void onVASTParserError(int n) {
                        PNAPIAssetGroup3.this.invokeOnLoadFail(new Exception("Cannot load VAST, parsing error " + n));
                    }

                    public void onVASTParserFinished(VASTModel vASTModel) {
                        PNAPIAssetGroup3.this.mPlayer.load(vASTModel);
                    }
                }).execute((Object[])new String[]{PNAPIAssetGroup3.this.mAdModel.getVast()});
            }

            @Override
            public void onImageFailed(String string, Exception exception) {
                PNAPIAssetGroup3.this.invokeOnLoadFail(exception);
            }
        });
        View view = this.mAdModel.getContentInfo(this.mContext);
        if (view != null) {
            this.mContentInfo.addView(view);
        }
    }

    protected void loadView() {
        this.mRoot = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pubnative_asset_group_3, (ViewGroup)this, true);
        this.mHeader = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_header);
        this.mBody = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_body);
        this.mFooter = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_footer);
        this.mTitle = (TextView)this.mHeader.findViewById(R.id.pubnative_title);
        this.mIcon = (ImageView)this.mHeader.findViewById(R.id.pubnative_icon);
        this.mRating = (RatingBar)this.mHeader.findViewById(R.id.pubnative_rating);
        this.mPlayer = (VASTPlayer)this.mBody.findViewById(R.id.pubnative_player);
        this.mDescription = (TextView)this.mFooter.findViewById(R.id.pubnative_description);
        this.mCallToAction = (TextView)this.mFooter.findViewById(R.id.pubnative_callToAction);
        this.mContentInfo = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_content_info_container);
    }

    @Override
    public void startTracking() {
        this.mAdModel.startTracking((View)this.mRoot, this);
        this.mPlayer.play();
    }

    @Override
    public void stopTracking() {
        this.mPlayer.stop();
        this.mAdModel.stopTracking();
    }

    @Override
    public PNAPILayoutView.IDMap getIDMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new PNAPILayoutView.IDMap(this);
            this.mIdMap.title = this.mTitle.getId();
            this.mIdMap.description = this.mDescription.getId();
            this.mIdMap.icon = this.mIcon.getId();
            this.mIdMap.starRating = this.mRating.getId();
            this.mIdMap.callToAction = this.mCallToAction.getId();
        }
        return this.mIdMap;
    }

    @Override
    public void onPNAPIAdModelImpression(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnImpressionConfirmed();
    }

    @Override
    public void onPNAPIAdModelClick(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnClick();
    }

    @Override
    public void onPNAPIAdModelOpenOffer(PNAPIAdModel pNAPIAdModel) {
    }

    public void onVASTPlayerLoadFinish() {
        this.invokeOnLoadFinish();
    }

    public void onVASTPlayerFail(Exception exception) {
        this.invokeOnLoadFail(exception);
    }

    public void onVASTPlayerPlaybackStart() {
    }

    public void onVASTPlayerPlaybackFinish() {
    }

    public void onVASTPlayerOpenOffer() {
        this.invokeOnClick();
    }
}

