/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.tracking;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pubnative.api.core.tracking.PNAPIImpressionManager;
import net.pubnative.api.core.tracking.PNAPIVisibilityTracker;

public class PNAPIImpressionTracker {
    private static final String TAG = PNAPIImpressionTracker.class.getSimpleName();
    private static final int VISIBILITY_CHECK_MILLIS = 250;
    private static final int VISIBILITY_TIME_MILLIS = 1000;
    private static final double DEFAULT_MIN_VISIBLE_PERCENT = 0.5;
    protected WeakReference<Listener> mImpressionListener = null;
    protected List<View> mTrackingViews = new ArrayList<View>();
    protected HashMap<View, Long> mVisibleViews = new HashMap();
    protected Handler mHandler = new Handler(Looper.getMainLooper());
    protected Runnable mImpressionRunnable = new ImpressionRunnable();
    protected PNAPIVisibilityTracker mVisibilityTracker = null;
    protected PNAPIVisibilityTracker.Listener mVisibilityListener = new PNAPIVisibilityTracker.Listener(){

        @Override
        public void onVisibilityCheck(List<View> list, List<View> list2) {
            if (PNAPIImpressionTracker.this.mImpressionListener == null && PNAPIImpressionTracker.this.mImpressionListener.get() == null) {
                PNAPIImpressionTracker.this.clear();
            } else {
                for (View view : list) {
                    if (PNAPIImpressionTracker.this.mVisibleViews.containsKey(view)) continue;
                    PNAPIImpressionTracker.this.mVisibleViews.put(view, SystemClock.uptimeMillis());
                }
                for (View view : list2) {
                    PNAPIImpressionTracker.this.mVisibleViews.remove(view);
                }
                if (!PNAPIImpressionTracker.this.mVisibleViews.isEmpty()) {
                    PNAPIImpressionTracker.this.scheduleNextRun();
                }
            }
        }
    };

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof View) {
            return this.mTrackingViews.contains(object);
        }
        if (object instanceof Listener) {
            return this.mImpressionListener.equals(object);
        }
        return super.equals(object);
    }

    public void setListener(Listener listener) {
        this.mImpressionListener = new WeakReference<Listener>(listener);
    }

    public void addView(View view) {
        if (this.mTrackingViews.contains(view)) {
            return;
        }
        this.mTrackingViews.add(view);
        this.getVisibilityTracker().addView(view, 0.5);
    }

    public void removeView(View view) {
        this.mTrackingViews.remove(view);
        this.mVisibleViews.remove(view);
        this.getVisibilityTracker().removeView(view);
    }

    public boolean isEmpty() {
        return this.mTrackingViews.isEmpty();
    }

    public void clear() {
        for (View view : this.mTrackingViews) {
            PNAPIImpressionManager.stopTrackingView(view);
        }
        this.mHandler.removeMessages(0);
        this.mTrackingViews.clear();
        this.mVisibleViews.clear();
        if (this.mVisibilityTracker != null) {
            this.mVisibilityTracker.clear();
            this.mVisibilityTracker = null;
        }
    }

    protected PNAPIVisibilityTracker getVisibilityTracker() {
        if (this.mVisibilityTracker == null) {
            this.mVisibilityTracker = new PNAPIVisibilityTracker();
            this.mVisibilityTracker.setListener(this.mVisibilityListener);
        }
        return this.mVisibilityTracker;
    }

    protected void scheduleNextRun() {
        if (this.mHandler.hasMessages(0)) {
            return;
        }
        this.mHandler.postDelayed(this.mImpressionRunnable, 250L);
    }

    protected class ImpressionRunnable
    implements Runnable {
        private List<View> mRemovedViews = new ArrayList<View>();

        ImpressionRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry<View, Long> view : PNAPIImpressionTracker.this.mVisibleViews.entrySet()) {
                View view2 = view.getKey();
                Long l = view.getValue();
                if (SystemClock.uptimeMillis() - l < 1000L) continue;
                if (PNAPIImpressionTracker.this.mImpressionListener != null && PNAPIImpressionTracker.this.mImpressionListener.get() != null) {
                    ((Listener)PNAPIImpressionTracker.this.mImpressionListener.get()).onImpression(view2);
                }
                this.mRemovedViews.add(view2);
            }
            for (View view : this.mRemovedViews) {
                PNAPIImpressionManager.stopTrackingView(view);
            }
            this.mRemovedViews.clear();
            if (!PNAPIImpressionTracker.this.mVisibleViews.isEmpty()) {
                PNAPIImpressionTracker.this.scheduleNextRun();
            }
        }
    }

    public static interface Listener {
        public void onImpression(View var1);
    }
}

