/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.tracking;

import android.util.Log;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import net.pubnative.api.core.tracking.PNAPIImpressionTracker;

public class PNAPIImpressionManager {
    private static final String TAG = PNAPIImpressionManager.class.getSimpleName();
    protected List<PNAPIImpressionTracker> mTrackers;
    private static PNAPIImpressionManager instance;

    private PNAPIImpressionManager() {
    }

    public static PNAPIImpressionManager getInstance() {
        if (instance == null) {
            instance = new PNAPIImpressionManager();
            PNAPIImpressionManager.instance.mTrackers = new ArrayList<PNAPIImpressionTracker>();
        }
        return instance;
    }

    public static void startTrackingView(View view, PNAPIImpressionTracker.Listener listener) {
        PNAPIImpressionManager.getInstance().addView(view, listener);
    }

    public static void stopTrackingAll(PNAPIImpressionTracker.Listener listener) {
        PNAPIImpressionManager.getInstance().stopTracking(listener);
    }

    public static void stopTrackingView(View view) {
        PNAPIImpressionManager.getInstance().removeView(view);
    }

    protected void addView(View view, PNAPIImpressionTracker.Listener listener) {
        if (view == null) {
            Log.w((String)TAG, (String)"trying to start tracking null view, dropping this calll");
        } else if (listener == null) {
            Log.w((String)TAG, (String)"trying to start tracking with null listener");
        } else {
            PNAPIImpressionTracker pNAPIImpressionTracker;
            int n;
            PNAPIImpressionTracker pNAPIImpressionTracker2;
            if (this.containsTracker(view) && !(pNAPIImpressionTracker2 = this.mTrackers.get(n = this.indexOfTracker(view))).equals(listener)) {
                this.removeView(view);
            }
            if (this.containsTracker(listener)) {
                int n2 = this.indexOfTracker(view);
                pNAPIImpressionTracker = this.mTrackers.get(n2);
            } else {
                pNAPIImpressionTracker = new PNAPIImpressionTracker();
                pNAPIImpressionTracker.setListener(listener);
                this.mTrackers.add(pNAPIImpressionTracker);
            }
            pNAPIImpressionTracker.addView(view);
        }
    }

    protected void stopTracking(PNAPIImpressionTracker.Listener listener) {
        if (listener == null) {
            Log.w((String)TAG, (String)"trying to remove all views from null listener, dropping this call");
        } else if (this.containsTracker(listener)) {
            int n = this.indexOfTracker(listener);
            PNAPIImpressionTracker pNAPIImpressionTracker = this.mTrackers.get(n);
            pNAPIImpressionTracker.clear();
            this.mTrackers.remove(listener);
        }
    }

    protected void removeView(View view) {
        if (view == null) {
            Log.w((String)TAG, (String)"trying to remove null view, dropping this call");
        } else if (this.containsTracker(view)) {
            int n = this.indexOfTracker(view);
            PNAPIImpressionTracker pNAPIImpressionTracker = this.mTrackers.get(n);
            pNAPIImpressionTracker.removeView(view);
            if (pNAPIImpressionTracker.isEmpty()) {
                pNAPIImpressionTracker.clear();
                this.mTrackers.remove(pNAPIImpressionTracker);
            }
        }
    }

    protected boolean containsTracker(View view) {
        return this.indexOfTracker(view) >= 0;
    }

    protected int indexOfTracker(View view) {
        int n = -1;
        for (int i = 0; i < this.mTrackers.size(); ++i) {
            PNAPIImpressionTracker pNAPIImpressionTracker = this.mTrackers.get(i);
            if (!pNAPIImpressionTracker.equals(view)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected boolean containsTracker(PNAPIImpressionTracker.Listener listener) {
        return this.indexOfTracker(listener) >= 0;
    }

    protected int indexOfTracker(PNAPIImpressionTracker.Listener listener) {
        int n = -1;
        for (int i = 0; i < this.mTrackers.size(); ++i) {
            PNAPIImpressionTracker pNAPIImpressionTracker = this.mTrackers.get(i);
            if (!pNAPIImpressionTracker.equals(listener)) continue;
            n = i;
            break;
        }
        return n;
    }
}

