/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgis.binary.BinaryParser;
import org.postgresql.util.PGobject;

public class PGgeometry
extends PGobject {
    private static final long serialVersionUID = 256L;
    Geometry geom;
    BinaryParser bp = new BinaryParser();
    public static final String SRIDPREFIX = "SRID=";

    public PGgeometry() {
        this.setType("geometry");
    }

    public PGgeometry(Geometry geom) {
        this();
        this.geom = geom;
    }

    public PGgeometry(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public void setValue(String value) throws SQLException {
        this.geom = PGgeometry.geomFromString(value, this.bp);
    }

    public static Geometry geomFromString(String value) throws SQLException {
        return PGgeometry.geomFromString(value, false);
    }

    public static Geometry geomFromString(String value, boolean haveM) throws SQLException {
        BinaryParser bp = new BinaryParser();
        return PGgeometry.geomFromString(value, bp, haveM);
    }

    public static Geometry geomFromString(String value, BinaryParser bp) throws SQLException {
        return PGgeometry.geomFromString(value, bp, false);
    }

    public static Geometry geomFromString(String value, BinaryParser bp, boolean haveM) throws SQLException {
        Geometry result;
        value = value.trim();
        int srid = 0;
        if (value.startsWith(SRIDPREFIX)) {
            String[] parts = PGgeometry.splitSRID(value);
            value = parts[1].trim();
            srid = Geometry.parseSRID(Integer.parseInt(parts[0].substring(5)));
        }
        if (value.startsWith("00") || value.startsWith("01")) {
            result = bp.parse(value);
        } else if (value.endsWith("EMPTY")) {
            result = new GeometryCollection();
        } else if (value.startsWith("MULTIPOLYGON")) {
            result = new MultiPolygon(value, haveM);
        } else if (value.startsWith("MULTILINESTRING")) {
            result = new MultiLineString(value, haveM);
        } else if (value.startsWith("MULTIPOINT")) {
            result = new MultiPoint(value, haveM);
        } else if (value.startsWith("POLYGON")) {
            result = new Polygon(value, haveM);
        } else if (value.startsWith("LINESTRING")) {
            result = new LineString(value, haveM);
        } else if (value.startsWith("POINT")) {
            result = new Point(value, haveM);
        } else if (value.startsWith("GEOMETRYCOLLECTION")) {
            result = new GeometryCollection(value, haveM);
        } else {
            throw new SQLException("Unknown type: " + value);
        }
        if (srid != 0) {
            result.srid = srid;
        }
        return result;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void setGeometry(Geometry newgeom) {
        this.geom = newgeom;
    }

    public int getGeoType() {
        return this.geom.type;
    }

    public String toString() {
        return this.geom.toString();
    }

    public String getValue() {
        return this.geom.toString();
    }

    public Object clone() {
        return new PGgeometry(this.geom);
    }

    public static String[] splitSRID(String whole) throws SQLException {
        int index = whole.indexOf(59, 5);
        if (index == -1) {
            throw new SQLException("Error parsing Geometry - SRID not delimited with ';' ");
        }
        return new String[]{whole.substring(0, index), whole.substring(index + 1)};
    }
}

