package com.easefun.polyv.livescenes.chatroom;

import com.easefun.polyv.livescenes.chatroom.send.custom.PolyvBaseCustomEvent;
import com.easefun.polyv.livescenes.chatroom.send.custom.PolyvSendCustomMsgListener;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendChatImageListener;
import com.easefun.polyv.livescenes.chatroom.send.img.PolyvSendLocalImgEvent;
import com.easefun.polyv.livescenes.model.PolyvChatFunctionSwitchVO;

import io.reactivex.functions.Consumer;
import io.socket.client.Ack;

/**
 * 聊天室接口
 */
public interface IPolyvChatroomManager {

    /**
     * 初始化
     */
    void init();

    /**
     * 销毁
     */
    void destroy();

    /**
     * 发送聊天信息至聊天室
     *
     * @param localMessage 聊天信息实体
     * @param sessionId    直播或回放的场次id，没有时可以传null
     * @return {@link PolyvLocalMessage.SendValue}
     */
    int sendChatMessage(PolyvLocalMessage localMessage, String sessionId);

    /**
     * 发送聊天信息至聊天室
     *
     * @param localMessage   聊天信息实体
     * @param sessionId      直播或回放的场次id，没有时可以传null
     * @param needIdCallback 是否需要回调信息id
     * @param ack            ack回调
     * @return
     */
    int sendChatMessage(PolyvLocalMessage localMessage, String sessionId, boolean needIdCallback, Ack ack);

    /**
     * 发送提问信息
     *
     * @param questionMessage
     * @return {@link PolyvLocalMessage.SendValue}
     */
    int sendQuestionMessage(PolyvQuestionMessage questionMessage);

    /**
     * 发送自定义信息
     *
     * @param baseCustomEvent 自定义信息模型类
     * @param <DataBean>
     */
    <DataBean> void sendCustomMsg(PolyvBaseCustomEvent<DataBean> baseCustomEvent);

    /**
     * 设置发送自定义信息的监听器
     *
     * @param sendCustomMsgListener
     */
    void setSendCustomMsgListener(PolyvSendCustomMsgListener sendCustomMsgListener);

    /**
     * 发送点赞
     *
     * @param sessionId 直播或回放的场次id，没有时可以传null
     */
    void sendLikes(String sessionId);

    /**
     * 发送点赞
     *
     * @param sessionId 直播或回放的场次id，没有时可以传null
     */
    void sendLikes(int count, String sessionId);

    /**
     * 获取聊天室的在线人数
     *
     * @return
     */
    int getOnlineCount();

    void setOnlineCount(int onlineCount);

    /**
     * 发送看我信息
     */
    int sendLookAtMeMessage();

    /**
     * 发送聊天图片
     */
    void sendChatImage(PolyvSendLocalImgEvent localImgEvent, String sessionId);

    /**
     * 添加发送图片的监听器
     */
    void addSendChatImageListener(PolyvSendChatImageListener sendChatImageListener);

    /**
     * 移除发送图片的监听器
     */
    void removeSendChatImageListener(PolyvSendChatImageListener sendChatImageListener);

    /**
     * socket发送消息回调
     */
    void setSocketCallbackListener(PolyvSocketCallbackListener listener);

    /**
     * 设置发送违禁词时的监听
     *
     * @param prohibitedWordListener 发送违禁词时的监听器
     */
    void setProhibitedWordListener(IPolyvProhibitedWordListener prohibitedWordListener);

    /**
     * 发送互动应用消息，带超时重传
     */
    void sendInteractiveSocketMessage(final String event, Object value, int retryCount, final String what);

    /**
     * 获取聊天室功能的开关实例，为null时用requestFunctionSwitch方法请求
     */
    PolyvChatFunctionSwitchVO getChatFunctionSwitchVO();

    /**
     * 请求功能开关接口
     */
    void requestFunctionSwitch(Consumer<PolyvChatFunctionSwitchVO> consumer);

    /**
     * 发送点赞到Api服务器的推迟时间
     * @param delayTime 单位秒，默认为30秒
     */
    void setWillSendApiLikesDelaySeconds(int delayTime);

    /**
     * 发送点赞到Socket服务器的推迟时间
     * @param delayTime 单位秒，默认为5秒
     */
    void setWillSendSocketLikesDelaySeconds(int delayTime);

}
