/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.security.SecureRandom;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationManagementResponse;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.EndSessionResponse;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

class AuthorizationManagementUtil {
    private static final int STATE_LENGTH = 16;
    public static final String REQUEST_TYPE_AUTHORIZATION = "authorization";
    public static final String REQUEST_TYPE_END_SESSION = "end_session";

    AuthorizationManagementUtil() {
    }

    static String generateRandomState() {
        SecureRandom sr = new SecureRandom();
        byte[] random = new byte[16];
        sr.nextBytes(random);
        return Base64.encodeToString((byte[])random, (int)11);
    }

    @Nullable
    static String requestTypeFor(AuthorizationManagementRequest request) {
        if (request instanceof AuthorizationRequest) {
            return REQUEST_TYPE_AUTHORIZATION;
        }
        if (request instanceof EndSessionRequest) {
            return REQUEST_TYPE_END_SESSION;
        }
        return null;
    }

    static AuthorizationManagementRequest requestFrom(String jsonStr, String type) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "jsonStr can not be null");
        JSONObject json = new JSONObject(jsonStr);
        if (REQUEST_TYPE_AUTHORIZATION.equals(type)) {
            return AuthorizationRequest.jsonDeserialize(json);
        }
        if (REQUEST_TYPE_END_SESSION.equals(type)) {
            return EndSessionRequest.jsonDeserialize(json);
        }
        throw new IllegalArgumentException("No AuthorizationManagementRequest found matching to this json schema");
    }

    @SuppressLint(value={"VisibleForTests"})
    static AuthorizationManagementResponse responseWith(AuthorizationManagementRequest request, Uri uri) {
        if (request instanceof AuthorizationRequest) {
            return new AuthorizationResponse.Builder((AuthorizationRequest)request).fromUri(uri).build();
        }
        if (request instanceof EndSessionRequest) {
            return new EndSessionResponse.Builder((EndSessionRequest)request).fromUri(uri).build();
        }
        throw new IllegalArgumentException("Malformed request or uri");
    }

    @Nullable
    static AuthorizationManagementResponse responseFrom(@NonNull Intent dataIntent) {
        if (EndSessionResponse.containsEndSessionResponse(dataIntent)) {
            return EndSessionResponse.fromIntent(dataIntent);
        }
        if (AuthorizationResponse.containsAuthorizationResponse(dataIntent)) {
            return AuthorizationResponse.fromIntent(dataIntent);
        }
        throw new IllegalArgumentException("Malformed intent");
    }
}

