/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.CodeVerifierUtil;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenRequest {
    @VisibleForTesting
    static final String KEY_CONFIGURATION = "configuration";
    @VisibleForTesting
    static final String KEY_CLIENT_ID = "clientId";
    @VisibleForTesting
    static final String KEY_GRANT_TYPE = "grantType";
    @VisibleForTesting
    static final String KEY_REDIRECT_URI = "redirectUri";
    @VisibleForTesting
    static final String KEY_SCOPE = "scope";
    @VisibleForTesting
    static final String KEY_AUTHORIZATION_CODE = "authorizationCode";
    @VisibleForTesting
    static final String KEY_REFRESH_TOKEN = "refreshToken";
    @VisibleForTesting
    static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    public static final String PARAM_CLIENT_ID = "client_id";
    @VisibleForTesting
    static final String PARAM_CODE = "code";
    @VisibleForTesting
    static final String PARAM_CODE_VERIFIER = "code_verifier";
    @VisibleForTesting
    static final String PARAM_GRANT_TYPE = "grant_type";
    @VisibleForTesting
    static final String PARAM_REDIRECT_URI = "redirect_uri";
    @VisibleForTesting
    static final String PARAM_REFRESH_TOKEN = "refresh_token";
    @VisibleForTesting
    static final String PARAM_SCOPE = "scope";
    private static final Set<String> BUILT_IN_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_id", "code", "code_verifier", "grant_type", "redirect_uri", "refresh_token", "scope")));
    public static final String GRANT_TYPE_PASSWORD = "password";
    public static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    @NonNull
    public final AuthorizationServiceConfiguration configuration;
    @NonNull
    public final String clientId;
    @NonNull
    public final String grantType;
    @Nullable
    public final Uri redirectUri;
    @Nullable
    public final String authorizationCode;
    @Nullable
    public final String scope;
    @Nullable
    public final String refreshToken;
    @Nullable
    public final String codeVerifier;
    @NonNull
    public final Map<String, String> additionalParameters;

    private TokenRequest(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String clientId, @NonNull String grantType, @Nullable Uri redirectUri, @Nullable String scope, @Nullable String authorizationCode, @Nullable String refreshToken, @Nullable String codeVerifier, @NonNull Map<String, String> additionalParameters) {
        this.configuration = configuration;
        this.clientId = clientId;
        this.grantType = grantType;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.authorizationCode = authorizationCode;
        this.refreshToken = refreshToken;
        this.codeVerifier = codeVerifier;
        this.additionalParameters = additionalParameters;
    }

    @Nullable
    public Set<String> getScopeSet() {
        return AsciiStringListUtil.stringToSet(this.scope);
    }

    @NonNull
    public Map<String, String> getRequestParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_GRANT_TYPE, this.grantType);
        this.putIfNotNull(params, PARAM_REDIRECT_URI, this.redirectUri);
        this.putIfNotNull(params, PARAM_CODE, this.authorizationCode);
        this.putIfNotNull(params, PARAM_REFRESH_TOKEN, this.refreshToken);
        this.putIfNotNull(params, PARAM_CODE_VERIFIER, this.codeVerifier);
        this.putIfNotNull(params, "scope", this.scope);
        for (Map.Entry<String, String> param : this.additionalParameters.entrySet()) {
            params.put(param.getKey(), param.getValue());
        }
        return params;
    }

    private void putIfNotNull(Map<String, String> map, String key, Object value) {
        if (value != null) {
            map.put(key, value.toString());
        }
    }

    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_CONFIGURATION, this.configuration.toJson());
        JsonUtil.put(json, KEY_CLIENT_ID, this.clientId);
        JsonUtil.put(json, KEY_GRANT_TYPE, this.grantType);
        JsonUtil.putIfNotNull(json, KEY_REDIRECT_URI, this.redirectUri);
        JsonUtil.putIfNotNull(json, "scope", this.scope);
        JsonUtil.putIfNotNull(json, KEY_AUTHORIZATION_CODE, this.authorizationCode);
        JsonUtil.putIfNotNull(json, KEY_REFRESH_TOKEN, this.refreshToken);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @NonNull
    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    @NonNull
    public static TokenRequest jsonDeserialize(JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json object cannot be null");
        Builder builder = new Builder(AuthorizationServiceConfiguration.fromJson(json.getJSONObject(KEY_CONFIGURATION)), JsonUtil.getString(json, KEY_CLIENT_ID)).setRedirectUri(JsonUtil.getUriIfDefined(json, KEY_REDIRECT_URI)).setGrantType(JsonUtil.getString(json, KEY_GRANT_TYPE)).setRefreshToken(JsonUtil.getStringIfDefined(json, KEY_REFRESH_TOKEN)).setAuthorizationCode(JsonUtil.getStringIfDefined(json, KEY_AUTHORIZATION_CODE)).setAdditionalParameters(JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS));
        if (json.has("scope")) {
            builder.setScopes(AsciiStringListUtil.stringToSet(JsonUtil.getString(json, "scope")));
        }
        return builder.build();
    }

    @NonNull
    public static TokenRequest jsonDeserialize(@NonNull String json) throws JSONException {
        Preconditions.checkNotNull(json, "json string cannot be null");
        return TokenRequest.jsonDeserialize(new JSONObject(json));
    }

    public static final class Builder {
        @NonNull
        private AuthorizationServiceConfiguration mConfiguration;
        @NonNull
        private String mClientId;
        @Nullable
        private String mGrantType;
        @Nullable
        private Uri mRedirectUri;
        @Nullable
        private String mScope;
        @Nullable
        private String mAuthorizationCode;
        @Nullable
        private String mRefreshToken;
        @Nullable
        private String mCodeVerifier;
        @NonNull
        private Map<String, String> mAdditionalParameters;

        public Builder(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String clientId) {
            this.setConfiguration(configuration);
            this.setClientId(clientId);
            this.mAdditionalParameters = new LinkedHashMap<String, String>();
        }

        @NonNull
        public Builder setConfiguration(@NonNull AuthorizationServiceConfiguration configuration) {
            this.mConfiguration = Preconditions.checkNotNull(configuration);
            return this;
        }

        @NonNull
        public Builder setClientId(@NonNull String clientId) {
            this.mClientId = Preconditions.checkNotEmpty(clientId, "clientId cannot be null or empty");
            return this;
        }

        @NonNull
        public Builder setGrantType(@NonNull String grantType) {
            this.mGrantType = Preconditions.checkNotEmpty(grantType, "grantType cannot be null or empty");
            return this;
        }

        @NonNull
        public Builder setRedirectUri(@Nullable Uri redirectUri) {
            if (redirectUri != null) {
                Preconditions.checkNotNull(redirectUri.getScheme(), "redirectUri must have a scheme");
            }
            this.mRedirectUri = redirectUri;
            return this;
        }

        @NonNull
        public Builder setScope(@Nullable String scope) {
            if (TextUtils.isEmpty((CharSequence)scope)) {
                this.mScope = null;
            } else {
                this.setScopes(scope.split(" +"));
            }
            return this;
        }

        @NonNull
        public Builder setScopes(String ... scopes) {
            if (scopes == null) {
                scopes = new String[]{};
            }
            this.setScopes(Arrays.asList(scopes));
            return this;
        }

        @NonNull
        public Builder setScopes(@Nullable Iterable<String> scopes) {
            this.mScope = AsciiStringListUtil.iterableToString(scopes);
            return this;
        }

        @NonNull
        public Builder setAuthorizationCode(@Nullable String authorizationCode) {
            Preconditions.checkNullOrNotEmpty(authorizationCode, "authorization code must not be empty");
            this.mAuthorizationCode = authorizationCode;
            return this;
        }

        @NonNull
        public Builder setRefreshToken(@Nullable String refreshToken) {
            if (refreshToken != null) {
                Preconditions.checkNotEmpty(refreshToken, "refresh token cannot be empty if defined");
            }
            this.mRefreshToken = refreshToken;
            return this;
        }

        public Builder setCodeVerifier(@Nullable String codeVerifier) {
            if (codeVerifier != null) {
                CodeVerifierUtil.checkCodeVerifier(codeVerifier);
            }
            this.mCodeVerifier = codeVerifier;
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        @NonNull
        public TokenRequest build() {
            String grantType = this.inferGrantType();
            if ("authorization_code".equals(grantType)) {
                Preconditions.checkNotNull(this.mAuthorizationCode, "authorization code must be specified for grant_type = authorization_code");
            }
            if (TokenRequest.PARAM_REFRESH_TOKEN.equals(grantType)) {
                Preconditions.checkNotNull(this.mRefreshToken, "refresh token must be specified for grant_type = refresh_token");
            }
            if (grantType.equals("authorization_code") && this.mRedirectUri == null) {
                throw new IllegalStateException("no redirect URI specified on token request for code exchange");
            }
            return new TokenRequest(this.mConfiguration, this.mClientId, grantType, this.mRedirectUri, this.mScope, this.mAuthorizationCode, this.mRefreshToken, this.mCodeVerifier, Collections.unmodifiableMap(this.mAdditionalParameters));
        }

        private String inferGrantType() {
            if (this.mGrantType != null) {
                return this.mGrantType;
            }
            if (this.mAuthorizationCode != null) {
                return "authorization_code";
            }
            if (this.mRefreshToken != null) {
                return TokenRequest.PARAM_REFRESH_TOKEN;
            }
            throw new IllegalStateException("grant type not specified and cannot be inferred");
        }
    }
}

