/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationServiceDiscovery {
    @VisibleForTesting
    static final JsonUtil.StringField ISSUER = AuthorizationServiceDiscovery.str("issuer");
    @VisibleForTesting
    static final JsonUtil.UriField AUTHORIZATION_ENDPOINT = AuthorizationServiceDiscovery.uri("authorization_endpoint");
    @VisibleForTesting
    static final JsonUtil.UriField TOKEN_ENDPOINT = AuthorizationServiceDiscovery.uri("token_endpoint");
    @VisibleForTesting
    static final JsonUtil.UriField USERINFO_ENDPOINT = AuthorizationServiceDiscovery.uri("userinfo_endpoint");
    @VisibleForTesting
    static final JsonUtil.UriField JWKS_URI = AuthorizationServiceDiscovery.uri("jwks_uri");
    @VisibleForTesting
    static final JsonUtil.UriField REGISTRATION_ENDPOINT = AuthorizationServiceDiscovery.uri("registration_endpoint");
    @VisibleForTesting
    static final JsonUtil.StringListField SCOPES_SUPPORTED = AuthorizationServiceDiscovery.strList("scopes_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField RESPONSE_TYPES_SUPPORTED = AuthorizationServiceDiscovery.strList("response_types_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField RESPONSE_MODES_SUPPORTED = AuthorizationServiceDiscovery.strList("response_modes_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField GRANT_TYPES_SUPPORTED = AuthorizationServiceDiscovery.strList("grant_types_supported", Arrays.asList("authorization_code", "implicit"));
    @VisibleForTesting
    static final JsonUtil.StringListField ACR_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("acr_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField SUBJECT_TYPES_SUPPORTED = AuthorizationServiceDiscovery.strList("subject_types_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("id_token_signing_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField ID_TOKEN_ENCRYPTION_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("id_token_encryption_enc_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField ID_TOKEN_ENCRYPTION_ENC_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("id_token_encryption_enc_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField USERINFO_SIGNING_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("userinfo_signing_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField USERINFO_ENCRYPTION_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("userinfo_encryption_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField USERINFO_ENCRYPTION_ENC_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("userinfo_encryption_enc_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("request_object_signing_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField REQUEST_OBJECT_ENCRYPTION_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("request_object_encryption_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField REQUEST_OBJECT_ENCRYPTION_ENC_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("request_object_encryption_enc_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = AuthorizationServiceDiscovery.strList("token_endpoint_auth_methods_supported", Collections.singletonList("client_secret_basic"));
    @VisibleForTesting
    static final JsonUtil.StringListField TOKEN_ENDPOINT_AUTH_SIGNING_ALG_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("token_endpoint_auth_signing_alg_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField DISPLAY_VALUES_SUPPORTED = AuthorizationServiceDiscovery.strList("display_values_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField CLAIM_TYPES_SUPPORTED = AuthorizationServiceDiscovery.strList("claim_types_supported", Collections.singletonList("normal"));
    @VisibleForTesting
    static final JsonUtil.StringListField CLAIMS_SUPPORTED = AuthorizationServiceDiscovery.strList("claims_supported");
    @VisibleForTesting
    static final JsonUtil.UriField SERVICE_DOCUMENTATION = AuthorizationServiceDiscovery.uri("service_documentation");
    @VisibleForTesting
    static final JsonUtil.StringListField CLAIMS_LOCALES_SUPPORTED = AuthorizationServiceDiscovery.strList("claims_locales_supported");
    @VisibleForTesting
    static final JsonUtil.StringListField UI_LOCALES_SUPPORTED = AuthorizationServiceDiscovery.strList("ui_locales_supported");
    @VisibleForTesting
    static final JsonUtil.BooleanField CLAIMS_PARAMETER_SUPPORTED = AuthorizationServiceDiscovery.bool("claims_parameter_supported", false);
    @VisibleForTesting
    static final JsonUtil.BooleanField REQUEST_PARAMETER_SUPPORTED = AuthorizationServiceDiscovery.bool("request_parameter_supported", false);
    @VisibleForTesting
    static final JsonUtil.BooleanField REQUEST_URI_PARAMETER_SUPPORTED = AuthorizationServiceDiscovery.bool("request_uri_parameter_supported", true);
    @VisibleForTesting
    static final JsonUtil.BooleanField REQUIRE_REQUEST_URI_REGISTRATION = AuthorizationServiceDiscovery.bool("require_request_uri_registration", false);
    @VisibleForTesting
    static final JsonUtil.UriField OP_POLICY_URI = AuthorizationServiceDiscovery.uri("op_policy_uri");
    @VisibleForTesting
    static final JsonUtil.UriField OP_TOS_URI = AuthorizationServiceDiscovery.uri("op_tos_uri");
    private static final List<String> MANDATORY_METADATA = Arrays.asList(AuthorizationServiceDiscovery.ISSUER.key, AuthorizationServiceDiscovery.AUTHORIZATION_ENDPOINT.key, AuthorizationServiceDiscovery.JWKS_URI.key, AuthorizationServiceDiscovery.RESPONSE_TYPES_SUPPORTED.key, AuthorizationServiceDiscovery.SUBJECT_TYPES_SUPPORTED.key, AuthorizationServiceDiscovery.ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED.key);
    @NonNull
    public final JSONObject docJson;

    public AuthorizationServiceDiscovery(@NonNull JSONObject discoveryDoc) throws JSONException, MissingArgumentException {
        this.docJson = Preconditions.checkNotNull(discoveryDoc);
        for (String mandatory : MANDATORY_METADATA) {
            if (this.docJson.has(mandatory) && this.docJson.get(mandatory) != null) continue;
            throw new MissingArgumentException(mandatory);
        }
    }

    private <T> T get(JsonUtil.Field<T> field) {
        return JsonUtil.get(this.docJson, field);
    }

    private <T> List<T> get(JsonUtil.ListField<T> field) {
        return JsonUtil.get(this.docJson, field);
    }

    @NonNull
    public String getIssuer() {
        return this.get(ISSUER);
    }

    @NonNull
    public Uri getAuthorizationEndpoint() {
        return this.get(AUTHORIZATION_ENDPOINT);
    }

    @Nullable
    public Uri getTokenEndpoint() {
        return this.get(TOKEN_ENDPOINT);
    }

    @Nullable
    public Uri getUserinfoEndpoint() {
        return this.get(USERINFO_ENDPOINT);
    }

    @NonNull
    public Uri getJwksUri() {
        return this.get(JWKS_URI);
    }

    @Nullable
    public Uri getRegistrationEndpoint() {
        return this.get(REGISTRATION_ENDPOINT);
    }

    public List<String> getScopesSupported() {
        return this.get(SCOPES_SUPPORTED);
    }

    @NonNull
    public List<String> getResponseTypesSupported() {
        return this.get(RESPONSE_TYPES_SUPPORTED);
    }

    @Nullable
    public List<String> getResponseModesSupported() {
        return this.get(RESPONSE_MODES_SUPPORTED);
    }

    @NonNull
    public List<String> getGrantTypesSupported() {
        return this.get(GRANT_TYPES_SUPPORTED);
    }

    public List<String> getAcrValuesSupported() {
        return this.get(ACR_VALUES_SUPPORTED);
    }

    @NonNull
    public List<String> getSubjectTypesSupported() {
        return this.get(SUBJECT_TYPES_SUPPORTED);
    }

    @NonNull
    public List<String> getIdTokenSigningAlgorithmValuesSupported() {
        return this.get(ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getIdTokenEncryptionAlgorithmValuesSupported() {
        return this.get(ID_TOKEN_ENCRYPTION_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getIdTokenEncryptionEncodingValuesSupported() {
        return this.get(ID_TOKEN_ENCRYPTION_ENC_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getUserinfoSigningAlgorithmValuesSupported() {
        return this.get(USERINFO_SIGNING_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getUserinfoEncryptionAlgorithmValuesSupported() {
        return this.get(USERINFO_ENCRYPTION_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getUserinfoEncryptionEncodingValuesSupported() {
        return this.get(USERINFO_ENCRYPTION_ENC_VALUES_SUPPORTED);
    }

    public List<String> getRequestObjectSigningAlgorithmValuesSupported() {
        return this.get(REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getRequestObjectEncryptionAlgorithmValuesSupported() {
        return this.get(REQUEST_OBJECT_ENCRYPTION_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getRequestObjectEncryptionEncodingValuesSupported() {
        return this.get(REQUEST_OBJECT_ENCRYPTION_ENC_VALUES_SUPPORTED);
    }

    @NonNull
    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.get(TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED);
    }

    @Nullable
    public List<String> getTokenEndpointAuthSigningAlgorithmValuesSupported() {
        return this.get(TOKEN_ENDPOINT_AUTH_SIGNING_ALG_VALUES_SUPPORTED);
    }

    @Nullable
    public List<String> getDisplayValuesSupported() {
        return this.get(DISPLAY_VALUES_SUPPORTED);
    }

    public List<String> getClaimTypesSupported() {
        return this.get(CLAIM_TYPES_SUPPORTED);
    }

    @Nullable
    public List<String> getClaimsSupported() {
        return this.get(CLAIMS_SUPPORTED);
    }

    @Nullable
    public Uri getServiceDocumentation() {
        return this.get(SERVICE_DOCUMENTATION);
    }

    @Nullable
    public List<String> getClaimsLocalesSupported() {
        return this.get(CLAIMS_LOCALES_SUPPORTED);
    }

    @Nullable
    public List<String> getUiLocalesSupported() {
        return this.get(UI_LOCALES_SUPPORTED);
    }

    public boolean isClaimsParameterSupported() {
        return this.get(CLAIMS_PARAMETER_SUPPORTED);
    }

    public boolean isRequestParameterSupported() {
        return this.get(REQUEST_PARAMETER_SUPPORTED);
    }

    public boolean isRequestUriParameterSupported() {
        return this.get(REQUEST_URI_PARAMETER_SUPPORTED);
    }

    public boolean requireRequestUriRegistration() {
        return this.get(REQUIRE_REQUEST_URI_REGISTRATION);
    }

    @Nullable
    public Uri getOpPolicyUri() {
        return this.get(OP_POLICY_URI);
    }

    @Nullable
    public Uri getOpTosUri() {
        return this.get(OP_TOS_URI);
    }

    private static JsonUtil.StringField str(String key) {
        return new JsonUtil.StringField(key);
    }

    private static JsonUtil.UriField uri(String key) {
        return new JsonUtil.UriField(key);
    }

    private static JsonUtil.StringListField strList(String key) {
        return new JsonUtil.StringListField(key);
    }

    private static JsonUtil.StringListField strList(String key, List<String> defaults) {
        return new JsonUtil.StringListField(key, defaults);
    }

    private static JsonUtil.BooleanField bool(String key, boolean defaultValue) {
        return new JsonUtil.BooleanField(key, defaultValue);
    }

    public static class MissingArgumentException
    extends Exception {
        private String mMissingField;

        public MissingArgumentException(String field) {
            super("Missing mandatory configuration field: " + field);
            this.mMissingField = field;
        }

        public String getMissingField() {
            return this.mMissingField;
        }
    }
}

