/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.ArrayMap;
import java.util.Collections;
import java.util.Map;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public final class AuthorizationException
extends Exception {
    public static final String EXTRA_EXCEPTION = "net.openid.appauth.AuthorizationException";
    public static final String PARAM_ERROR = "error";
    public static final String PARAM_ERROR_DESCRIPTION = "error_description";
    public static final String PARAM_ERROR_URI = "error_uri";
    public static final int TYPE_GENERAL_ERROR = 0;
    public static final int TYPE_OAUTH_AUTHORIZATION_ERROR = 1;
    public static final int TYPE_OAUTH_TOKEN_ERROR = 2;
    public static final int TYPE_RESOURCE_SERVER_AUTHORIZATION_ERROR = 3;
    public static final int TYPE_OAUTH_REGISTRATION_ERROR = 4;
    @VisibleForTesting
    static final String KEY_TYPE = "type";
    @VisibleForTesting
    static final String KEY_CODE = "code";
    @VisibleForTesting
    static final String KEY_ERROR = "error";
    @VisibleForTesting
    static final String KEY_ERROR_DESCRIPTION = "errorDescription";
    @VisibleForTesting
    static final String KEY_ERROR_URI = "errorUri";
    private static final int HASH_MULTIPLIER = 31;
    public final int type;
    public final int code;
    @Nullable
    public final String error;
    @Nullable
    public final String errorDescription;
    @Nullable
    public final Uri errorUri;

    private static AuthorizationException generalEx(int code, @Nullable String errorDescription) {
        return new AuthorizationException(0, code, null, errorDescription, null, null);
    }

    private static AuthorizationException authEx(int code, @Nullable String error) {
        return new AuthorizationException(1, code, error, null, null, null);
    }

    private static AuthorizationException tokenEx(int code, @Nullable String error) {
        return new AuthorizationException(2, code, error, null, null, null);
    }

    private static AuthorizationException registrationEx(int code, @Nullable String error) {
        return new AuthorizationException(4, code, error, null, null, null);
    }

    public static AuthorizationException fromTemplate(@NonNull AuthorizationException ex, @Nullable Throwable rootCause) {
        return new AuthorizationException(ex.type, ex.code, ex.error, ex.errorDescription, ex.errorUri, rootCause);
    }

    public static AuthorizationException fromOAuthTemplate(@NonNull AuthorizationException ex, @Nullable String errorOverride, @Nullable String errorDescriptionOverride, @Nullable Uri errorUriOverride) {
        return new AuthorizationException(ex.type, ex.code, errorOverride != null ? errorOverride : ex.error, errorDescriptionOverride != null ? errorDescriptionOverride : ex.errorDescription, errorUriOverride != null ? errorUriOverride : ex.errorUri, null);
    }

    public static AuthorizationException fromOAuthRedirect(@NonNull Uri redirectUri) {
        String error = redirectUri.getQueryParameter("error");
        String errorDescription = redirectUri.getQueryParameter(PARAM_ERROR_DESCRIPTION);
        String errorUri = redirectUri.getQueryParameter(PARAM_ERROR_URI);
        AuthorizationException base = AuthorizationRequestErrors.byString(error);
        return new AuthorizationException(base.type, base.code, error, errorDescription != null ? errorDescription : base.errorDescription, errorUri != null ? Uri.parse((String)errorUri) : base.errorUri, null);
    }

    public static AuthorizationException fromJson(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr cannot be null or empty");
        return AuthorizationException.fromJson(new JSONObject(jsonStr));
    }

    public static AuthorizationException fromJson(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json cannot be null");
        return new AuthorizationException(json.getInt(KEY_TYPE), json.getInt(KEY_CODE), JsonUtil.getStringIfDefined(json, "error"), JsonUtil.getStringIfDefined(json, KEY_ERROR_DESCRIPTION), JsonUtil.getUriIfDefined(json, KEY_ERROR_URI), null);
    }

    @Nullable
    public static AuthorizationException fromIntent(Intent data) {
        Preconditions.checkNotNull(data);
        if (!data.hasExtra(EXTRA_EXCEPTION)) {
            return null;
        }
        try {
            return AuthorizationException.fromJson(data.getStringExtra(EXTRA_EXCEPTION));
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("Intent contains malformed exception data", ex);
        }
    }

    private static Map<String, AuthorizationException> exceptionMapByString(AuthorizationException ... exceptions) {
        ArrayMap map = new ArrayMap(exceptions != null ? exceptions.length : 0);
        if (exceptions != null) {
            for (AuthorizationException ex : exceptions) {
                if (ex.error == null) continue;
                map.put((Object)ex.error, (Object)ex);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public AuthorizationException(int type, int code, @Nullable String error, @Nullable String errorDescription, @Nullable Uri errorUri, @Nullable Throwable rootCause) {
        super(errorDescription, rootCause);
        this.type = type;
        this.code = code;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_TYPE, this.type);
        JsonUtil.put(json, KEY_CODE, this.code);
        JsonUtil.putIfNotNull(json, "error", this.error);
        JsonUtil.putIfNotNull(json, KEY_ERROR_DESCRIPTION, this.errorDescription);
        JsonUtil.putIfNotNull(json, KEY_ERROR_URI, this.errorUri);
        return json;
    }

    @NonNull
    public String toJsonString() {
        return this.toJson().toString();
    }

    @NonNull
    public Intent toIntent() {
        Intent data = new Intent();
        data.putExtra(EXTRA_EXCEPTION, this.toJsonString());
        return data;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AuthorizationException)) {
            return false;
        }
        AuthorizationException other = (AuthorizationException)obj;
        return this.type == other.type && this.code == other.code;
    }

    public int hashCode() {
        return 31 * (31 + this.type) + this.code;
    }

    @Override
    public String toString() {
        return "AuthorizationException: " + this.toJsonString();
    }

    static /* synthetic */ AuthorizationException access$000(int x0, String x1) {
        return AuthorizationException.generalEx(x0, x1);
    }

    static /* synthetic */ AuthorizationException access$100(int x0, String x1) {
        return AuthorizationException.authEx(x0, x1);
    }

    static /* synthetic */ Map access$200(AuthorizationException[] x0) {
        return AuthorizationException.exceptionMapByString(x0);
    }

    static /* synthetic */ AuthorizationException access$300(int x0, String x1) {
        return AuthorizationException.tokenEx(x0, x1);
    }

    static /* synthetic */ AuthorizationException access$400(int x0, String x1) {
        return AuthorizationException.registrationEx(x0, x1);
    }

    public static final class RegistrationRequestErrors {
        public static final AuthorizationException INVALID_REQUEST = AuthorizationException.access$400(4000, "invalid_request");
        public static final AuthorizationException INVALID_REDIRECT_URI = AuthorizationException.access$400(4001, "invalid_redirect_uri");
        public static final AuthorizationException INVALID_CLIENT_METADATA = AuthorizationException.access$400(4002, "invalid_client_metadata");
        public static final AuthorizationException CLIENT_ERROR = AuthorizationException.access$400(4003, null);
        public static final AuthorizationException OTHER = AuthorizationException.access$400(4004, null);
        private static final Map<String, AuthorizationException> STRING_TO_EXCEPTION = AuthorizationException.access$200(new AuthorizationException[]{INVALID_REQUEST, INVALID_REDIRECT_URI, INVALID_CLIENT_METADATA, CLIENT_ERROR, OTHER});

        public static AuthorizationException byString(String error) {
            AuthorizationException ex = STRING_TO_EXCEPTION.get(error);
            if (ex != null) {
                return ex;
            }
            return OTHER;
        }
    }

    public static final class TokenRequestErrors {
        public static final AuthorizationException INVALID_REQUEST = AuthorizationException.access$300(2000, "invalid_request");
        public static final AuthorizationException INVALID_CLIENT = AuthorizationException.access$300(2001, "invalid_client");
        public static final AuthorizationException INVALID_GRANT = AuthorizationException.access$300(2002, "invalid_grant");
        public static final AuthorizationException UNAUTHORIZED_CLIENT = AuthorizationException.access$300(2003, "unauthorized_client");
        public static final AuthorizationException UNSUPPORTED_GRANT_TYPE = AuthorizationException.access$300(2004, "unsupported_grant_type");
        public static final AuthorizationException INVALID_SCOPE = AuthorizationException.access$300(2005, "invalid_scope");
        public static final AuthorizationException CLIENT_ERROR = AuthorizationException.access$300(2006, null);
        public static final AuthorizationException OTHER = AuthorizationException.access$300(2007, null);
        private static final Map<String, AuthorizationException> STRING_TO_EXCEPTION = AuthorizationException.access$200(new AuthorizationException[]{INVALID_REQUEST, INVALID_CLIENT, INVALID_GRANT, UNAUTHORIZED_CLIENT, UNSUPPORTED_GRANT_TYPE, INVALID_SCOPE, CLIENT_ERROR, OTHER});

        public static AuthorizationException byString(String error) {
            AuthorizationException ex = STRING_TO_EXCEPTION.get(error);
            if (ex != null) {
                return ex;
            }
            return OTHER;
        }
    }

    public static final class AuthorizationRequestErrors {
        public static final AuthorizationException INVALID_REQUEST = AuthorizationException.access$100(1000, "invalid_request");
        public static final AuthorizationException UNAUTHORIZED_CLIENT = AuthorizationException.access$100(1001, "unauthorized_client");
        public static final AuthorizationException ACCESS_DENIED = AuthorizationException.access$100(1002, "access_denied");
        public static final AuthorizationException UNSUPPORTED_RESPONSE_TYPE = AuthorizationException.access$100(1003, "unsupported_response_type");
        public static final AuthorizationException INVALID_SCOPE = AuthorizationException.access$100(1004, "invalid_scope");
        public static final AuthorizationException SERVER_ERROR = AuthorizationException.access$100(1005, "server_error");
        public static final AuthorizationException TEMPORARILY_UNAVAILABLE = AuthorizationException.access$100(1006, "temporarily_unavailable");
        public static final AuthorizationException CLIENT_ERROR = AuthorizationException.access$100(1007, null);
        public static final AuthorizationException OTHER = AuthorizationException.access$100(1008, null);
        public static final AuthorizationException STATE_MISMATCH = AuthorizationException.access$000(9, "Response state param did not match request state");
        private static final Map<String, AuthorizationException> STRING_TO_EXCEPTION = AuthorizationException.access$200(new AuthorizationException[]{INVALID_REQUEST, UNAUTHORIZED_CLIENT, ACCESS_DENIED, UNSUPPORTED_RESPONSE_TYPE, INVALID_SCOPE, SERVER_ERROR, TEMPORARILY_UNAVAILABLE, CLIENT_ERROR, OTHER});

        @NonNull
        public static AuthorizationException byString(String error) {
            AuthorizationException ex = STRING_TO_EXCEPTION.get(error);
            if (ex != null) {
                return ex;
            }
            return OTHER;
        }
    }

    public static final class GeneralErrors {
        public static final AuthorizationException INVALID_DISCOVERY_DOCUMENT = AuthorizationException.access$000(0, "Invalid discovery document");
        public static final AuthorizationException USER_CANCELED_AUTH_FLOW = AuthorizationException.access$000(1, "User cancelled flow");
        public static final AuthorizationException PROGRAM_CANCELED_AUTH_FLOW = AuthorizationException.access$000(2, "Flow cancelled programmatically");
        public static final AuthorizationException NETWORK_ERROR = AuthorizationException.access$000(3, "Network error");
        public static final AuthorizationException SERVER_ERROR = AuthorizationException.access$000(4, "Server error");
        public static final AuthorizationException JSON_DESERIALIZATION_ERROR = AuthorizationException.access$000(5, "JSON deserialization error");
        public static final AuthorizationException TOKEN_RESPONSE_CONSTRUCTION_ERROR = AuthorizationException.access$000(6, "Token response construction error");
        public static final AuthorizationException INVALID_REGISTRATION_RESPONSE = AuthorizationException.access$000(7, "Invalid registration response");
    }
}

