/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import net.openid.appauth.Preconditions;

public final class Logger {
    @VisibleForTesting
    static final String LOG_TAG = "AppAuth";
    @Nullable
    private static Logger sInstance;
    @NonNull
    private final LogWrapper mLog;
    private final int mLogLevel;

    public static synchronized Logger getInstance() {
        if (sInstance == null) {
            sInstance = new Logger(AndroidLogWrapper.INSTANCE);
        }
        return sInstance;
    }

    @VisibleForTesting
    public static synchronized void setInstance(Logger logger) {
        sInstance = logger;
    }

    @VisibleForTesting
    Logger(LogWrapper log) {
        int level;
        this.mLog = Preconditions.checkNotNull(log);
        for (level = 7; level >= 2 && this.mLog.isLoggable(LOG_TAG, level); --level) {
        }
        this.mLogLevel = level + 1;
    }

    public static void verbose(String message, Object ... messageParams) {
        Logger.getInstance().log(2, null, message, messageParams);
    }

    public static void verboseWithStack(Throwable tr, String message, Object ... messageParams) {
        Logger.getInstance().log(2, tr, message, messageParams);
    }

    public static void debug(String message, Object ... messageParams) {
        Logger.getInstance().log(3, null, message, messageParams);
    }

    public static void debugWithStack(Throwable tr, String message, Object ... messageParams) {
        Logger.getInstance().log(3, tr, message, messageParams);
    }

    public static void info(String message, Object ... messageParams) {
        Logger.getInstance().log(4, null, message, messageParams);
    }

    public static void infoWithStack(Throwable tr, String message, Object ... messageParams) {
        Logger.getInstance().log(4, tr, message, messageParams);
    }

    public static void warn(String message, Object ... messageParams) {
        Logger.getInstance().log(5, null, message, messageParams);
    }

    public static void warnWithStack(Throwable tr, String message, Object ... messageParams) {
        Logger.getInstance().log(5, tr, message, messageParams);
    }

    public static void error(String message, Object ... messageParams) {
        Logger.getInstance().log(6, null, message, messageParams);
    }

    public static void errorWithStack(Throwable tr, String message, Object ... messageParams) {
        Logger.getInstance().log(6, tr, message, messageParams);
    }

    public void log(int level, Throwable tr, String message, Object ... messageParams) {
        if (this.mLogLevel > level) {
            return;
        }
        String formattedMessage = messageParams == null || messageParams.length < 1 ? message : String.format(message, messageParams);
        if (tr != null) {
            formattedMessage = formattedMessage + "\n" + this.mLog.getStackTraceString(tr);
        }
        this.mLog.println(level, LOG_TAG, formattedMessage);
    }

    private static final class AndroidLogWrapper
    implements LogWrapper {
        private static final AndroidLogWrapper INSTANCE = new AndroidLogWrapper();

        private AndroidLogWrapper() {
        }

        @Override
        public void println(int level, String tag, String message) {
            Log.println((int)level, (String)tag, (String)message);
        }

        @Override
        public boolean isLoggable(String tag, int level) {
            return Log.isLoggable((String)tag, (int)level);
        }

        @Override
        public String getStackTraceString(Throwable tr) {
            return Log.getStackTraceString((Throwable)tr);
        }
    }

    @VisibleForTesting
    public static interface LogWrapper {
        public void println(int var1, String var2, String var3);

        public boolean isLoggable(String var1, int var2);

        public String getStackTraceString(Throwable var1);
    }
}

