/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import androidx.annotation.NonNull;

public class DelimitedVersion
implements Comparable<DelimitedVersion> {
    private static final int PRIME_HASH_FACTOR = 92821;
    private static final long BIT_MASK_32 = -1L;
    private final long[] mNumericParts;

    public DelimitedVersion(long[] numericParts) {
        this.mNumericParts = numericParts;
    }

    public String toString() {
        if (this.mNumericParts.length == 0) {
            return "0";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.mNumericParts[0]);
        for (int index = 1; index < this.mNumericParts.length; ++index) {
            builder.append('.');
            builder.append(this.mNumericParts[index]);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DelimitedVersion)) {
            return false;
        }
        return this.compareTo((DelimitedVersion)obj) == 0;
    }

    public int hashCode() {
        int result = 0;
        for (long numericPart : this.mNumericParts) {
            result = result * 92821 + (int)(numericPart & 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    @Override
    public int compareTo(@NonNull DelimitedVersion other) {
        for (int index = 0; index < this.mNumericParts.length && index < other.mNumericParts.length; ++index) {
            int currentPartOrder = this.compareLongs(this.mNumericParts[index], other.mNumericParts[index]);
            if (currentPartOrder == 0) continue;
            return currentPartOrder;
        }
        return this.compareLongs(this.mNumericParts.length, other.mNumericParts.length);
    }

    private int compareLongs(long l1, long l2) {
        if (l1 < l2) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }

    public static DelimitedVersion parse(String versionString) {
        if (versionString == null) {
            return new DelimitedVersion(new long[0]);
        }
        String[] stringParts = versionString.split("[^0-9]+");
        long[] parsedParts = new long[stringParts.length];
        int index = 0;
        for (String numericPart : stringParts) {
            if (numericPart.isEmpty()) continue;
            parsedParts[index] = Long.parseLong(numericPart);
            ++index;
        }
        --index;
        while (index >= 0 && parsedParts[index] <= 0L) {
            --index;
        }
        int length = index + 1;
        long[] onlyParsedParts = new long[length];
        System.arraycopy(parsedParts, 0, onlyParsedParts, 0, length);
        return new DelimitedVersion(onlyParsedParts);
    }
}

