/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationRequest {
    public static final String APPLICATION_TYPE_NATIVE = "native";
    static final String PARAM_REDIRECT_URIS = "redirect_uris";
    static final String PARAM_RESPONSE_TYPES = "response_types";
    static final String PARAM_GRANT_TYPES = "grant_types";
    static final String PARAM_APPLICATION_TYPE = "application_type";
    static final String PARAM_SUBJECT_TYPE = "subject_type";
    static final String PARAM_JWKS_URI = "jwks_uri";
    static final String PARAM_JWKS = "jwks";
    static final String PARAM_TOKEN_ENDPOINT_AUTHENTICATION_METHOD = "token_endpoint_auth_method";
    private static final Set<String> BUILT_IN_PARAMS = AdditionalParamsProcessor.builtInParams("redirect_uris", "response_types", "grant_types", "application_type", "subject_type", "jwks_uri", "jwks", "token_endpoint_auth_method");
    static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    static final String KEY_CONFIGURATION = "configuration";
    public static final String SUBJECT_TYPE_PAIRWISE = "pairwise";
    public static final String SUBJECT_TYPE_PUBLIC = "public";
    @NonNull
    public final AuthorizationServiceConfiguration configuration;
    @NonNull
    public final List<Uri> redirectUris;
    @NonNull
    public final String applicationType;
    @Nullable
    public final List<String> responseTypes;
    @Nullable
    public final List<String> grantTypes;
    @Nullable
    public final String subjectType;
    @Nullable
    public final Uri jwksUri;
    @Nullable
    public final JSONObject jwks;
    @Nullable
    public final String tokenEndpointAuthenticationMethod;
    @NonNull
    public final Map<String, String> additionalParameters;

    private RegistrationRequest(@NonNull AuthorizationServiceConfiguration configuration, @NonNull List<Uri> redirectUris, @Nullable List<String> responseTypes, @Nullable List<String> grantTypes, @Nullable String subjectType, @Nullable Uri jwksUri, @Nullable JSONObject jwks, @Nullable String tokenEndpointAuthenticationMethod, @NonNull Map<String, String> additionalParameters) {
        this.configuration = configuration;
        this.redirectUris = redirectUris;
        this.responseTypes = responseTypes;
        this.grantTypes = grantTypes;
        this.subjectType = subjectType;
        this.jwksUri = jwksUri;
        this.jwks = jwks;
        this.tokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
        this.additionalParameters = additionalParameters;
        this.applicationType = APPLICATION_TYPE_NATIVE;
    }

    @NonNull
    public String toJsonString() {
        JSONObject json = this.jsonSerializeParams();
        for (Map.Entry<String, String> param : this.additionalParameters.entrySet()) {
            JsonUtil.put(json, param.getKey(), param.getValue());
        }
        return json.toString();
    }

    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = this.jsonSerializeParams();
        JsonUtil.put(json, KEY_CONFIGURATION, this.configuration.toJson());
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @NonNull
    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    private JSONObject jsonSerializeParams() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, PARAM_REDIRECT_URIS, JsonUtil.toJsonArray(this.redirectUris));
        JsonUtil.put(json, PARAM_APPLICATION_TYPE, this.applicationType);
        if (this.responseTypes != null) {
            JsonUtil.put(json, PARAM_RESPONSE_TYPES, JsonUtil.toJsonArray(this.responseTypes));
        }
        if (this.grantTypes != null) {
            JsonUtil.put(json, PARAM_GRANT_TYPES, JsonUtil.toJsonArray(this.grantTypes));
        }
        JsonUtil.putIfNotNull(json, PARAM_SUBJECT_TYPE, this.subjectType);
        JsonUtil.putIfNotNull(json, PARAM_JWKS_URI, this.jwksUri);
        JsonUtil.putIfNotNull(json, PARAM_JWKS, this.jwks);
        JsonUtil.putIfNotNull(json, PARAM_TOKEN_ENDPOINT_AUTHENTICATION_METHOD, this.tokenEndpointAuthenticationMethod);
        return json;
    }

    public static RegistrationRequest jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json must not be null");
        return new RegistrationRequest(AuthorizationServiceConfiguration.fromJson(json.getJSONObject(KEY_CONFIGURATION)), JsonUtil.getUriList(json, PARAM_REDIRECT_URIS), JsonUtil.getStringListIfDefined(json, PARAM_RESPONSE_TYPES), JsonUtil.getStringListIfDefined(json, PARAM_GRANT_TYPES), JsonUtil.getStringIfDefined(json, PARAM_SUBJECT_TYPE), JsonUtil.getUriIfDefined(json, PARAM_JWKS_URI), JsonUtil.getJsonObjectIfDefined(json, PARAM_JWKS), JsonUtil.getStringIfDefined(json, PARAM_TOKEN_ENDPOINT_AUTHENTICATION_METHOD), JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS));
    }

    public static RegistrationRequest jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr must not be empty or null");
        return RegistrationRequest.jsonDeserialize(new JSONObject(jsonStr));
    }

    public static final class Builder {
        @NonNull
        private AuthorizationServiceConfiguration mConfiguration;
        @NonNull
        private List<Uri> mRedirectUris = new ArrayList<Uri>();
        @Nullable
        private List<String> mResponseTypes;
        @Nullable
        private List<String> mGrantTypes;
        @Nullable
        private String mSubjectType;
        @Nullable
        private Uri mJwksUri;
        @Nullable
        private JSONObject mJwks;
        @Nullable
        private String mTokenEndpointAuthenticationMethod;
        @NonNull
        private Map<String, String> mAdditionalParameters = Collections.emptyMap();

        public Builder(@NonNull AuthorizationServiceConfiguration configuration, @NonNull List<Uri> redirectUri) {
            this.setConfiguration(configuration);
            this.setRedirectUriValues(redirectUri);
        }

        @NonNull
        public Builder setConfiguration(@NonNull AuthorizationServiceConfiguration configuration) {
            this.mConfiguration = Preconditions.checkNotNull(configuration);
            return this;
        }

        @NonNull
        public Builder setRedirectUriValues(Uri ... redirectUriValues) {
            return this.setRedirectUriValues(Arrays.asList(redirectUriValues));
        }

        @NonNull
        public Builder setRedirectUriValues(@NonNull List<Uri> redirectUriValues) {
            Preconditions.checkCollectionNotEmpty(redirectUriValues, "redirectUriValues cannot be null");
            this.mRedirectUris = redirectUriValues;
            return this;
        }

        @NonNull
        public Builder setResponseTypeValues(String ... responseTypeValues) {
            return this.setResponseTypeValues(Arrays.asList(responseTypeValues));
        }

        @NonNull
        public Builder setResponseTypeValues(@Nullable List<String> responseTypeValues) {
            this.mResponseTypes = responseTypeValues;
            return this;
        }

        @NonNull
        public Builder setGrantTypeValues(String ... grantTypeValues) {
            return this.setGrantTypeValues(Arrays.asList(grantTypeValues));
        }

        @NonNull
        public Builder setGrantTypeValues(@Nullable List<String> grantTypeValues) {
            this.mGrantTypes = grantTypeValues;
            return this;
        }

        @NonNull
        public Builder setSubjectType(@Nullable String subjectType) {
            this.mSubjectType = subjectType;
            return this;
        }

        @NonNull
        public Builder setJwksUri(@Nullable Uri jwksUri) {
            this.mJwksUri = jwksUri;
            return this;
        }

        @NonNull
        public Builder setJwks(@Nullable JSONObject jwks) {
            this.mJwks = jwks;
            return this;
        }

        @NonNull
        public Builder setTokenEndpointAuthenticationMethod(@Nullable String tokenEndpointAuthenticationMethod) {
            this.mTokenEndpointAuthenticationMethod = tokenEndpointAuthenticationMethod;
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        @NonNull
        public RegistrationRequest build() {
            return new RegistrationRequest(this.mConfiguration, Collections.unmodifiableList(this.mRedirectUris), this.mResponseTypes == null ? this.mResponseTypes : Collections.unmodifiableList(this.mResponseTypes), this.mGrantTypes == null ? this.mGrantTypes : Collections.unmodifiableList(this.mGrantTypes), this.mSubjectType, this.mJwksUri, this.mJwks, this.mTokenEndpointAuthenticationMethod, Collections.unmodifiableMap(this.mAdditionalParameters));
        }
    }
}

