/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.BooleanFieldModel;
import net.openhft.chronicle.values.CharSequenceFieldModel;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.DateFieldModel;
import net.openhft.chronicle.values.EnumFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.FloatingFieldModel;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Pointer;
import net.openhft.chronicle.values.PointerFieldModel;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.ValueFieldModel;
import net.openhft.chronicle.values.ValueModel;

enum CodeTemplate {

    public static final Function<Method, Parameter> NO_ANNOTATED_PARAM = m -> null;
    static final List<Class<?>> NON_MODEL_TYPES = Arrays.asList(Object.class, Serializable.class, Externalizable.class, BytesMarshallable.class, Copyable.class, Byteable.class);
    private static final SortedSet<MethodTemplate> METHOD_TEMPLATES = new TreeSet<MethodTemplate>(Comparator.comparing(t -> t.parameters).thenComparing(k -> -k.regex.length()).thenComparing(k -> k.regex));
    private static final String FIELD_NAME = "([a-zA-Z_$][a-zA-Z\\d_$]*)";

    private static void addReadPatterns(String regex, int arguments, BiConsumer<FieldModel, Method> addMethodToModel) {
        regex = regex + FIELD_NAME;
        CodeTemplate.add(regex, arguments, MethodTemplate.Type.SCALAR, Method::getReturnType, NO_ANNOTATED_PARAM, addMethodToModel);
        CodeTemplate.add(regex + "At", arguments + 1, MethodTemplate.Type.ARRAY, Method::getReturnType, NO_ANNOTATED_PARAM, addMethodToModel);
    }

    public static void addWritePattern(String regex, int arguments, BiConsumer<FieldModel, Method> addMethodToModel) {
        regex = regex + FIELD_NAME;
        CodeTemplate.add(regex, arguments, MethodTemplate.Type.SCALAR, m -> m.getParameterTypes()[arguments - 1], m -> m.getParameters()[arguments - 1], addMethodToModel);
        CodeTemplate.add(regex + "At", arguments + 1, MethodTemplate.Type.ARRAY, m -> m.getParameterTypes()[arguments], m -> m.getParameters()[arguments], addMethodToModel);
    }

    private static void add(String regex, int parameters, MethodTemplate.Type type, Function<Method, Class> fieldType, Function<Method, Parameter> annotatedParameter, BiConsumer<FieldModel, Method> addMethodToModel) {
        METHOD_TEMPLATES.add(new MethodTemplate(regex, parameters, type, fieldType, annotatedParameter, addMethodToModel));
    }

    static ValueModel createValueModel(Class<?> valueType) {
        List<FieldModel> fields = CodeTemplate.methodsAndTemplatesByField(valueType).entrySet().stream().map(e -> CodeTemplate.createAndConfigureModel((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
        if (fields.isEmpty()) {
            throw new IllegalArgumentException(valueType + " is not a value interface");
        }
        fields.forEach(FieldModel::checkAnyWriteMethodPresent);
        fields.forEach(FieldModel::postProcess);
        fields.forEach(FieldModel::checkState);
        return new ValueModel(valueType, fields.stream());
    }

    private static FieldModel createAndConfigureModel(String fieldName, List<MethodAndTemplate> methodsAndTemplates) {
        if (methodsAndTemplates.stream().map(mt -> mt.template.type).distinct().count() > 1L) {
            throw new IllegalArgumentException("All or none accessors of the " + fieldName + " field should end with -At (what means this is an array field)");
        }
        ScalarFieldModel scalarModel = CodeTemplate.createAndConfigureScalarModel(fieldName, methodsAndTemplates);
        if (methodsAndTemplates.get((int)0).template.type == MethodTemplate.Type.SCALAR) {
            return scalarModel;
        }
        scalarModel.resetAlignment();
        ArrayFieldModel arrayModel = new ArrayFieldModel(scalarModel);
        CodeTemplate.configureModel(arrayModel, methodsAndTemplates);
        return arrayModel;
    }

    private static ScalarFieldModel createAndConfigureScalarModel(String fieldName, List<MethodAndTemplate> methodsAndTemplates) {
        ScalarFieldModel nonPointerModel = CodeTemplate.createNonPointerScalarModel(fieldName, methodsAndTemplates);
        CodeTemplate.configureModel(nonPointerModel, methodsAndTemplates);
        boolean hasPointerAnnotation = methodsAndTemplates.stream().map(mt -> mt.method).flatMap(m -> Arrays.stream(m.getParameterAnnotations()).flatMap(Arrays::stream)).anyMatch(a -> a.annotationType() == Pointer.class);
        if (hasPointerAnnotation) {
            if (!(nonPointerModel instanceof ValueFieldModel)) {
                throw new IllegalStateException(fieldName + " annotated with @Pointer but has " + nonPointerModel.type.getName() + " type which is not a value interface");
            }
            PointerFieldModel pointerModel = new PointerFieldModel((ValueFieldModel)nonPointerModel);
            CodeTemplate.configureModel(pointerModel, methodsAndTemplates);
            return pointerModel;
        }
        return nonPointerModel;
    }

    private static void configureModel(FieldModel model, List<MethodAndTemplate> methodsAndTemplates) {
        methodsAndTemplates.forEach(mt -> {
            model.name = mt.fieldName;
            model.addInfo(mt.method, mt.template);
            mt.template.addMethodToModel.accept(model, mt.method);
        });
    }

    private static ScalarFieldModel createNonPointerScalarModel(String fieldName, List<MethodAndTemplate> methodsAndTemplates) {
        MethodAndTemplate nonGetUsingMethodAndTemplate = methodsAndTemplates.stream().filter(mt -> !mt.template.regex.startsWith("getUsing")).findAny().orElseThrow(() -> new IllegalStateException(fieldName + " field should have some accessor methods except " + ((MethodAndTemplate)methodsAndTemplates.get((int)0)).method.getName()));
        MethodTemplate nonGetUsingMethodTemplate = nonGetUsingMethodAndTemplate.template;
        Method nonGetUsingMethod = nonGetUsingMethodAndTemplate.method;
        Class fieldType = nonGetUsingMethodTemplate.fieldType.apply(nonGetUsingMethod);
        if (Primitives.isPrimitiveIntegerType(fieldType)) {
            return new IntegerFieldModel();
        }
        if (fieldType == Float.TYPE || fieldType == Double.TYPE) {
            return new FloatingFieldModel();
        }
        if (fieldType == Boolean.TYPE) {
            return new BooleanFieldModel();
        }
        if (Enum.class.isAssignableFrom(fieldType)) {
            return new EnumFieldModel();
        }
        if (fieldType == Date.class) {
            return new DateFieldModel();
        }
        if (CharSequence.class.isAssignableFrom(fieldType)) {
            return new CharSequenceFieldModel();
        }
        if (fieldType.isInterface()) {
            return new ValueFieldModel();
        }
        throw new IllegalStateException(fieldName + " field type " + fieldType + " is not supported: not a primitive, enum, CharSequence or another value interface");
    }

    private static Map<String, List<MethodAndTemplate>> methodsAndTemplatesByField(Class<?> valueType) {
        return Stream.of(valueType.getMethods()).filter(m -> (m.getModifiers() & 0x400) != 0).filter(m -> NON_MODEL_TYPES.stream().noneMatch(t -> CodeTemplate.hasMethod(t, m))).map(m -> {
            MethodTemplate methodTemplate = METHOD_TEMPLATES.stream().filter(t -> t.parameters == m.getParameterCount()).filter(t -> m.getName().matches(t.regex)).findFirst().orElseThrow(IllegalStateException::new);
            Matcher matcher = Pattern.compile(methodTemplate.regex).matcher(m.getName());
            if (!matcher.find()) {
                throw new AssertionError();
            }
            String fieldName = CodeTemplate.convertFieldName(matcher.group(1));
            return new MethodAndTemplate((Method)m, methodTemplate, fieldName);
        }).collect(Collectors.groupingBy(mt -> mt.fieldName));
    }

    private static boolean hasMethod(Class<?> type, Method m) {
        return Stream.of(type.getMethods()).anyMatch(m2 -> m2.getName().equals(m.getName()) && Arrays.equals(m2.getParameterTypes(), m.getParameterTypes()));
    }

    static String convertFieldName(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        CodeTemplate.addReadPatterns("get", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("is", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("getVolatile", 0, FieldModel::setGetVolatile);
        CodeTemplate.addReadPatterns("getUsing", 1, FieldModel::setGetUsing);
        CodeTemplate.addWritePattern("set", 1, FieldModel::setSet);
        CodeTemplate.addWritePattern("", 1, FieldModel::setSet);
        CodeTemplate.addWritePattern("setVolatile", 1, FieldModel::setSetVolatile);
        CodeTemplate.addWritePattern("setOrdered", 1, FieldModel::setSetOrdered);
        CodeTemplate.addWritePattern("add", 1, FieldModel::setAdd);
        CodeTemplate.addWritePattern("addAtomic", 1, FieldModel::setAddAtomic);
        CodeTemplate.addWritePattern("compareAndSwap", 2, FieldModel::setCompareAndSwap);
    }

    static class MethodAndTemplate {
        final Method method;
        final MethodTemplate template;
        final String fieldName;

        MethodAndTemplate(Method method, MethodTemplate template, String fieldName) {
            this.method = method;
            this.template = template;
            this.fieldName = fieldName;
        }
    }
}

