/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class BlockingEventLoop
extends SimpleCloseable
implements EventLoop {
    @NotNull
    private final EventLoop parent;
    @NotNull
    private final transient ExecutorService service;
    @NotNull
    private final String name;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final NamedThreadFactory threadFactory;
    private final Pauser pauser = Pauser.balanced();

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name) {
        this.name = name;
        this.parent = parent;
        this.threadFactory = new NamedThreadFactory(name, null, null, true);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    public BlockingEventLoop(@NotNull String name) {
        this.name = name;
        this.parent = this;
        this.threadFactory = new NamedThreadFactory(name, null, null, true);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String name() {
        return this.name;
    }

    public synchronized void addHandler(@NotNull EventHandler handler) {
        if (DEBUG_ADDING_HANDLERS) {
            Jvm.startup().on(((Object)((Object)this)).getClass(), "Adding " + handler.priority() + " " + handler + " to " + this.name);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        this.handlers.add(handler);
        if (this.started.get()) {
            this.startHandler(handler);
        }
    }

    private String asString(Object handler) {
        return Integer.toHexString(System.identityHashCode(handler));
    }

    public synchronized void start() {
        if (this.started.getAndSet(true)) {
            return;
        }
        this.running.set(true);
        this.handlers.forEach(this::startHandler);
    }

    private void startHandler(EventHandler handler) {
        block2: {
            try {
                this.service.submit(new Runner(handler));
            }
            catch (RejectedExecutionException e) {
                if (this.service.isShutdown()) break block2;
                Jvm.warn().on(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
    }

    public void unpause() {
        this.pauser.unpause();
        Threads.unpark(this.service);
    }

    public void stop() {
        this.running.set(false);
        this.unpause();
    }

    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    protected void performClose() {
        super.performClose();
        this.stop();
        Threads.shutdown(this.service);
        if (!this.started.get()) {
            this.handlers.forEach(Threads::loopFinishedQuietly);
        }
        Closeable.closeQuietly(this.handlers);
    }

    public String toString() {
        return "BlockingEventLoop{name=" + this.name + '}';
    }

    private final class Runner
    implements Runnable {
        private final EventHandler handler;

        public Runner(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                BlockingEventLoop.this.throwExceptionIfClosed();
                this.handler.eventLoop(BlockingEventLoop.this.parent);
                this.handler.loopStarted();
                while (BlockingEventLoop.this.running.get()) {
                    if (this.handler.action()) {
                        BlockingEventLoop.this.pauser.reset();
                        continue;
                    }
                    BlockingEventLoop.this.pauser.pause();
                }
            }
            catch (InvalidEventHandlerException invalidEventHandlerException) {
            }
            catch (Throwable t) {
                if (!BlockingEventLoop.this.isClosed()) {
                    Jvm.warn().on(this.handler.getClass(), BlockingEventLoop.this.asString(this.handler) + " threw ", t);
                }
            }
            finally {
                if (Jvm.isDebugEnabled(this.handler.getClass())) {
                    Jvm.debug().on(this.handler.getClass(), "handler " + BlockingEventLoop.this.asString(this.handler) + " done.");
                }
                Threads.loopFinishedQuietly(this.handler);
                BlockingEventLoop.this.handlers.remove(this.handler);
                Closeable.closeQuietly((Object)this.handler);
            }
        }
    }
}

