/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.model.Issue;

public final class ReleaseNotes {
    private final String tag;
    private final String title;
    private final List<Issue> issues;

    public ReleaseNotes(String tag, String title, List<Issue> issues) {
        this.tag = Objects.requireNonNull(tag);
        this.title = Objects.requireNonNull(title);
        this.issues = Collections.unmodifiableList(Objects.requireNonNull(issues));
    }

    public String getTag() {
        return this.tag;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseNotes releaseNotes = (ReleaseNotes)o;
        return this.tag.equals(releaseNotes.tag) && this.title.equals(releaseNotes.title) && this.issues.equals(releaseNotes.issues);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.title, this.issues);
    }

    public String toString() {
        return "Release{tag='" + this.tag + '\'' + ", title='" + this.title + '\'' + ", issues=" + this.issues + '}';
    }
}

