/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public interface Issue {
    public int getNumber();

    public String getTitle();

    public List<String> getLabels();

    public Optional<String> getComment();

    public URL getUrl();

    public static Comparator<Issue> compareByLabel(String missingLabel) {
        return (o1, o2) -> {
            String l1 = o1.getLabels().stream().findFirst().orElse(missingLabel);
            String l2 = o2.getLabels().stream().findFirst().orElse(missingLabel);
            return l1.compareTo(l2);
        };
    }
}

