/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector.github;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.releasenotes.connector.ConnectorProviderKey;
import net.openhft.chronicle.releasenotes.connector.ReleaseConnector;
import net.openhft.chronicle.releasenotes.connector.github.GitHubConnectorProviderKey;
import net.openhft.chronicle.releasenotes.creator.ReleaseNoteCreator;
import net.openhft.chronicle.releasenotes.model.Issue;
import net.openhft.chronicle.releasenotes.model.Label;
import net.openhft.chronicle.releasenotes.model.ReleaseNote;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.PagedIterable;

public final class GitHubReleaseConnector
implements ReleaseConnector {
    private final GitHub github;
    private final ReleaseNoteCreator releaseNoteCreator;

    public GitHubReleaseConnector(String token) throws IOException {
        this.github = new GitHubBuilder().withOAuthToken(Objects.requireNonNull(token)).build();
        this.releaseNoteCreator = ReleaseNoteCreator.markdown();
    }

    public ReleaseConnector.ReleaseResult createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(branch);
        GHRepository repositoryRef = this.getRepository(repository);
        return this.createRelease(repositoryRef, tag, () -> this.getIssuesForBranch(repositoryRef, branch, tag), ignoredLabels, override);
    }

    public ReleaseConnector.ReleaseResult createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(endTag);
        Objects.requireNonNull(branch);
        GHRepository repositoryRef = this.getRepository(repository);
        return this.createRelease(repositoryRef, tag, () -> this.getIssuesForBranch(repositoryRef, branch, tag, endTag), ignoredLabels, override);
    }

    public ReleaseConnector.ReleaseResult createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(milestone);
        GHRepository repositoryRef = this.getRepository(repository);
        return this.createRelease(repositoryRef, tag, () -> this.getClosedMilestoneIssues(repositoryRef, milestone), ignoredLabels, override);
    }

    public ReleaseConnector.ReleaseResult createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(releases);
        GHRepository repositoryRef = this.getRepository(repository);
        try {
            if (!this.checkTagExists(repositoryRef, tag)) {
                throw new RuntimeException("Tag '" + tag + "' not found");
            }
            GHRelease remoteRelease = repositoryRef.getReleaseByTagName(tag);
            List sourceReleases = releases.entrySet().stream().map(entry -> {
                GHRepository sourceRepository = this.getRepository((String)entry.getKey());
                return ((List)entry.getValue()).stream().map(release -> this.getRelease(sourceRepository, (String)release)).collect(Collectors.toList());
            }).flatMap(Collection::stream).collect(Collectors.toList());
            if (remoteRelease != null) {
                if (!override) {
                    throw new RuntimeException("Release for tag '" + tag + "' already exists: use --override to force an override of an existing release");
                }
                List normalizedReleaseNotes = sourceReleases.stream().map(release -> new ReleaseNote(release.getTagName(), release.getName(), release.getBody())).collect(Collectors.toList());
                ReleaseNote releaseNote = this.releaseNoteCreator.createAggregatedReleaseNote(tag, normalizedReleaseNotes);
                GHRelease release2 = remoteRelease.update().name(releaseNote.getTitle()).body(releaseNote.getBody()).update();
                return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release2.getHtmlUrl());
            }
            List normalizedReleaseNotes = sourceReleases.stream().map(release -> new ReleaseNote(release.getTagName(), release.getName(), release.getBody())).collect(Collectors.toList());
            ReleaseNote releaseNote = this.releaseNoteCreator.createAggregatedReleaseNote(tag, normalizedReleaseNotes);
            GHRelease release3 = repositoryRef.createRelease(releaseNote.getTag()).name(releaseNote.getTitle()).body(releaseNote.getBody()).create();
            return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release3.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((RuntimeException)new RuntimeException("Failed to create release for tag '" + tag + "'"));
        }
    }

    public ReleaseConnector.ReleaseResult createAggregatedRelease(String repository, String tag, List<ReleaseNote> releaseNotes, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(releaseNotes);
        GHRepository repositoryRef = this.getRepository(repository);
        try {
            if (!this.checkTagExists(repositoryRef, tag)) {
                throw new RuntimeException("Tag '" + tag + "' not found");
            }
            GHRelease remoteRelease = repositoryRef.getReleaseByTagName(tag);
            if (remoteRelease != null) {
                if (!override) {
                    throw new RuntimeException("Release for tag '" + tag + "' already exists: use --override to force an override of an existing release");
                }
                ReleaseNote releaseNote = this.releaseNoteCreator.createAggregatedReleaseNote(tag, releaseNotes);
                GHRelease release = remoteRelease.update().name(releaseNote.getTitle()).body(releaseNote.getBody()).update();
                return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release.getHtmlUrl());
            }
            ReleaseNote releaseNote = this.releaseNoteCreator.createAggregatedReleaseNote(tag, releaseNotes);
            GHRelease release = repositoryRef.createRelease(releaseNote.getTag()).name(releaseNote.getTitle()).body(releaseNote.getBody()).create();
            return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((RuntimeException)new RuntimeException("Failed to create release for tag '" + tag + "'"));
        }
    }

    public Class<? extends ConnectorProviderKey> getKey() {
        return GitHubConnectorProviderKey.class;
    }

    private ReleaseConnector.ReleaseResult createRelease(GHRepository repository, String tag, Supplier<List<GHIssue>> issueSupplier, List<String> ignoredLabels, boolean override) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(issueSupplier);
        try {
            if (!this.checkTagExists(repository, tag)) {
                throw new RuntimeException("Tag '" + tag + "' not found");
            }
            GHRelease remoteRelease = repository.getReleaseByTagName(tag);
            if (remoteRelease != null) {
                if (!override) {
                    throw new RuntimeException("Release for tag '" + tag + "' already exists: use --override to force an override of an existing release");
                }
                List issues = this.filterIssueLabels(issueSupplier.get(), ignoredLabels).stream().map(this::mapIssue).collect(Collectors.toList());
                ReleaseNote releaseNote = this.releaseNoteCreator.createReleaseNote(tag, issues);
                GHRelease release = remoteRelease.update().name(releaseNote.getTitle()).body(releaseNote.getBody()).update();
                return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release.getHtmlUrl());
            }
            List issues = this.filterIssueLabels(issueSupplier.get(), ignoredLabels).stream().map(this::mapIssue).collect(Collectors.toList());
            ReleaseNote releaseNote = this.releaseNoteCreator.createReleaseNote(tag, issues);
            GHRelease release = repository.createRelease(releaseNote.getTag()).name(releaseNote.getTitle()).body(releaseNote.getBody()).create();
            return ReleaseConnector.ReleaseResult.success((ReleaseNote)releaseNote, (URL)release.getHtmlUrl());
        }
        catch (IOException e) {
            return ReleaseConnector.ReleaseResult.fail((RuntimeException)new RuntimeException("Failed to create release for tag '" + tag + "'"));
        }
    }

    private GHRepository getRepository(String repository) {
        Objects.requireNonNull(repository);
        try {
            return this.github.getRepository(repository);
        }
        catch (IOException e) {
            throw new RuntimeException("Repository '" + repository + "' not found");
        }
    }

    private GHBranch getBranch(GHRepository repository, String branch) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        try {
            return repository.getBranch(branch);
        }
        catch (IOException e) {
            throw new RuntimeException("Branch '" + branch + "' not found in repository '" + repository + "'");
        }
    }

    private GHRelease getRelease(GHRepository repository, String tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        try {
            return repository.getReleaseByTagName(tag);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find release for tag '" + tag + "' in repository '" + repository.getName() + "'");
        }
    }

    private Map<String, GHTag> getTags(GHRepository repository, String ... tags) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tags);
        List<String> tagSet = Arrays.asList(tags);
        try {
            Map<String, GHTag> collectedTags = this.stream((Iterable)repository.listTags()).filter(ghTag -> tagSet.contains(ghTag.getName())).collect(Collectors.toMap(GHTag::getName, Function.identity()));
            if (collectedTags.size() == tags.length) {
                return collectedTags;
            }
            String missingTags = Arrays.stream(tags).filter(tag -> !collectedTags.containsKey(tag)).collect(Collectors.joining(", "));
            throw new RuntimeException("Failed to find tag(s) [" + missingTags + "] in repository '" + repository.getFullName() + "'");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch tags for repository '" + repository.getFullName() + "'");
        }
    }

    private GHTag getPreviousTag(GHRepository repository, GHBranch branch, GHTag tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(tag);
        Date tagDate = this.getCommitDate(tag.getCommit());
        try {
            return this.stream((Iterable)repository.listTags()).filter(ghTag -> this.getCommitDate(ghTag.getCommit()).before(tagDate)).filter(ghTag -> this.isTagOnBranch(repository, tag, branch)).limit(1L).findFirst().orElseThrow(() -> new RuntimeException("Failed to find a tag before tag '" + tag + "' on branch '" + branch + "' for repository '" + repository.getName() + "'"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch tags for repository '" + repository.getFullName() + "'");
        }
    }

    private boolean checkTagExists(GHRepository repository, String tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        try {
            return this.stream((Iterable)repository.listTags()).anyMatch(ghTag -> ghTag.getName().equals(tag));
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isTagOnBranch(GHRepository repository, GHTag tag, GHBranch branch) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(branch);
        List<GHCommit> commits = this.getCommitsForBranchFromTag(repository, branch, tag);
        return commits.stream().anyMatch(commit -> commit.getSHA1().equals(tag.getCommit().getSHA1()));
    }

    private List<GHCommit> getCommitsForBranchFromTag(GHRepository repository, GHBranch branch, GHTag tag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(tag);
        try {
            PagedIterable commits = repository.queryCommits().from(branch.getSHA1()).since(this.getCommitDate(tag.getCommit())).list();
            return commits.toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commits for branch '" + branch.getName() + "' in repository '" + repository.getName() + "'");
        }
    }

    private List<GHIssue> getIssuesForBranch(GHRepository repository, String branch, String startTag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        return this.getIssuesForBranch(repository, branch, startTag, null);
    }

    private List<GHIssue> getIssuesForBranch(GHRepository repository, String branch, String startTag, String endTag) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        List<GHCommit> commits = this.getCommitsForBranch(repository, branch, startTag, endTag);
        List<Integer> issueIds = this.extractIssueIdsFromCommits(commits);
        return this.getIssuesFromIds(repository, issueIds);
    }

    private List<GHCommit> getCommitsForBranch(GHRepository repository, String branch, String startTag, String endTag) {
        GHCommit endCommit;
        Objects.requireNonNull(repository);
        Objects.requireNonNull(branch);
        Objects.requireNonNull(startTag);
        GHBranch branchRef = this.getBranch(repository, branch);
        Map<String, GHTag> tags = endTag == null ? this.getTags(repository, startTag) : this.getTags(repository, startTag, endTag);
        GHCommit startCommit = tags.get(startTag).getCommit();
        GHCommit gHCommit = endCommit = endTag == null ? this.getPreviousTag(repository, branchRef, tags.get(startTag)).getCommit() : tags.get(endTag).getCommit();
        if (this.getCommitDate(startCommit).before(this.getCommitDate(endCommit))) {
            throw new RuntimeException("Start tag '" + startTag + "' has a commit date before end tag '" + endTag + "'");
        }
        try {
            PagedIterable commits = branchRef.getOwner().queryCommits().from(branchRef.getSHA1()).since(this.getCommitDate(endCommit)).until(this.getCommitDate(startCommit)).list();
            if (this.stream((Iterable)commits).noneMatch(commit -> commit.getSHA1().equals(startCommit.getSHA1()))) {
                throw new RuntimeException("Tag '" + startTag + "' not found on branch '" + branch + "'");
            }
            if (this.stream((Iterable)commits).noneMatch(commit -> commit.getSHA1().equals(endCommit.getSHA1()))) {
                throw new RuntimeException("Tag '" + endTag + "' not found on branch '" + branch + "'");
            }
            return commits.toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commits for branch '" + branchRef.getName() + "' in repository '" + branchRef.getOwner().getName() + "'");
        }
    }

    private List<Integer> extractIssueIdsFromCommits(List<GHCommit> commits) {
        return commits.stream().map(this::extractIssueIdsFromCommit).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Integer> extractIssueIdsFromCommit(GHCommit commit) {
        Objects.requireNonNull(commit);
        try {
            String commitMessage = commit.getCommitShortInfo().getMessage().replaceAll("\n", " ").replaceAll(" +", " ");
            String[] tokens = commitMessage.split(" ");
            return Arrays.stream(tokens).filter(this::isIssueToken).map(token -> Integer.valueOf(token.substring(1))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commit info for commit '" + commit.getSHA1() + "'");
        }
    }

    private boolean isIssueToken(String token) {
        Objects.requireNonNull(token);
        if (!token.startsWith("#")) {
            return false;
        }
        String issueId = token.substring(1);
        if (!issueId.chars().allMatch(Character::isDigit)) {
            return false;
        }
        return issueId.charAt(0) != '0';
    }

    private List<GHIssue> getIssuesFromIds(GHRepository repository, List<Integer> ids) {
        Objects.requireNonNull(repository);
        return this.stream((Iterable)repository.listIssues(GHIssueState.ALL)).filter(ghIssue -> ids.contains(ghIssue.getNumber())).collect(Collectors.toList());
    }

    private List<GHIssue> filterIssueLabels(List<GHIssue> issues, List<String> ignoredLabels) {
        Objects.requireNonNull(issues);
        if (ignoredLabels == null) {
            return issues;
        }
        return issues.stream().filter(issue -> issue.getLabels().stream().noneMatch(ghLabel -> ignoredLabels.contains(ghLabel.getName()))).collect(Collectors.toList());
    }

    private Issue mapIssue(GHIssue issue) {
        return new Issue(issue.getNumber(), issue.getTitle(), issue.getLabels().stream().map(ghLabel -> new Label(ghLabel.getName())).collect(Collectors.toList()), issue.getHtmlUrl());
    }

    private List<GHIssue> getClosedMilestoneIssues(GHRepository repository, String milestone) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestone);
        GHMilestone milestoneRef = this.getMilestone(repository, milestone);
        return this.stream((Iterable)repository.listIssues(GHIssueState.CLOSED)).filter(ghIssue -> ghIssue.getMilestone() != null && ghIssue.getMilestone().getNumber() == milestoneRef.getNumber()).collect(Collectors.toList());
    }

    private GHMilestone getMilestone(GHRepository repository, String milestone) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(milestone);
        return this.stream((Iterable)repository.listMilestones(GHIssueState.ALL)).filter(ghMilestone -> ghMilestone.getTitle().equals(milestone)).findAny().orElseThrow(() -> new RuntimeException("Milestone '" + milestone + "' not found"));
    }

    private Date getCommitDate(GHCommit commit) {
        try {
            return commit.getCommitDate();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to fetch commit date for commit '" + commit.getSHA1() + "'");
        }
    }

    private <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

