/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.connector.Connector;
import net.openhft.chronicle.releasenotes.connector.ReleaseException;
import net.openhft.chronicle.releasenotes.model.AggregatedReleaseNotes;
import net.openhft.chronicle.releasenotes.model.Issue;
import net.openhft.chronicle.releasenotes.model.ReleaseNotes;

public interface ReleaseConnector
extends Connector,
AutoCloseable {
    public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String var1, String var2, String var3, BranchReleaseOptions var4);

    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String branch) {
        return this.createReleaseFromBranch(repository, tag, branch, BranchReleaseOptions.DEFAULT);
    }

    public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String var1, String var2, String var3, String var4, BranchReleaseOptions var5);

    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String endTag, String branch) {
        return this.createReleaseFromBranch(repository, tag, endTag, branch, BranchReleaseOptions.DEFAULT);
    }

    public ReleaseResult<ReleaseNotes> createReleaseFromMilestone(String var1, String var2, String var3, MilestoneReleaseOptions var4);

    default public ReleaseResult<ReleaseNotes> createReleaseFromMilestone(String repository, String tag, String milestone) {
        return this.createReleaseFromMilestone(repository, tag, milestone, MilestoneReleaseOptions.DEFAULT);
    }

    public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String var1, String var2, Map<String, List<String>> var3, AggregateReleaseOptions var4);

    default public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases) {
        return this.createAggregatedRelease(repository, tag, releases, AggregateReleaseOptions.DEFAULT);
    }

    public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String var1, String var2, List<ReleaseNotes> var3, AggregateReleaseOptions var4);

    default public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, List<ReleaseNotes> releaseNotes) {
        return this.createAggregatedRelease(repository, tag, releaseNotes, AggregateReleaseOptions.DEFAULT);
    }

    public ReleaseResult<ReleaseNotes> queryReleaseFromBranch(String var1, String var2, String var3, BranchReleaseOptions var4);

    default public ReleaseResult<ReleaseNotes> queryReleaseFromBranch(String repository, String tag, String branch) {
        return this.createReleaseFromBranch(repository, tag, branch, BranchReleaseOptions.DEFAULT);
    }

    public ReleaseResult<Issue> createIssueComment(String var1, int var2, String var3);

    @Override
    default public void close() throws Exception {
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels, boolean override) {
        BranchReleaseOptions releaseOptions = new BranchReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromBranch(repository, tag, branch, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, branch, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels, boolean override) {
        BranchReleaseOptions releaseOptions = new BranchReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromBranch(repository, tag, endTag, branch, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, endTag, branch, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels, boolean override) {
        MilestoneReleaseOptions releaseOptions = new MilestoneReleaseOptions.Builder().ignoreLabels(ignoredLabels).overrideRelease(override).build();
        return this.createReleaseFromMilestone(repository, tag, milestone, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult<ReleaseNotes> createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels) {
        return this.createReleaseFromMilestone(repository, tag, milestone, ignoredLabels, false);
    }

    @Deprecated
    default public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases, boolean override) {
        AggregateReleaseOptions releaseOptions = new AggregateReleaseOptions.Builder().overrideRelease(override).build();
        return this.createAggregatedRelease(repository, tag, releases, releaseOptions);
    }

    @Deprecated
    default public ReleaseResult<AggregatedReleaseNotes> createAggregatedRelease(String repository, String tag, List<ReleaseNotes> releaseNotes, boolean override) {
        AggregateReleaseOptions releaseOptions = new AggregateReleaseOptions.Builder().overrideRelease(override).build();
        return this.createAggregatedRelease(repository, tag, releaseNotes, releaseOptions);
    }

    public static class AggregateReleaseOptions {
        public static final AggregateReleaseOptions DEFAULT = new AggregateReleaseOptions(false);
        private final boolean overrideRelease;

        private AggregateReleaseOptions(boolean overrideRelease) {
            this.overrideRelease = overrideRelease;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public static final class Builder {
            private boolean overrideRelease;

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public AggregateReleaseOptions build() {
                return new AggregateReleaseOptions(this.overrideRelease);
            }
        }
    }

    public static class MilestoneReleaseOptions {
        public static final MilestoneReleaseOptions DEFAULT = new MilestoneReleaseOptions(new ArrayList<String>(), false, false);
        private final List<String> ignoredLabels;
        private final boolean overrideRelease;
        private final boolean includeAdditionalContext;

        private MilestoneReleaseOptions(List<String> ignoredLabels, boolean overrideRelease, boolean includeAdditionalContext) {
            this.ignoredLabels = ignoredLabels;
            this.overrideRelease = overrideRelease;
            this.includeAdditionalContext = includeAdditionalContext;
        }

        public List<String> getIgnoredLabels() {
            return this.ignoredLabels;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public boolean includeAdditionalContext() {
            return this.includeAdditionalContext;
        }

        public String toString() {
            return "MilestoneReleaseOptions{ignoredLabels=" + this.ignoredLabels + ", overrideRelease=" + this.overrideRelease + '}';
        }

        public static final class Builder {
            private final List<String> ignoredLabels = new ArrayList<String>();
            private boolean overrideRelease;
            private boolean includeAdditionalContext;

            public Builder ignoreLabels(String ... labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder ignoreLabels(List<String> labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(labels);
                return this;
            }

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public Builder includeAdditionalContext(boolean includeAdditionalContext) {
                this.includeAdditionalContext = includeAdditionalContext;
                return this;
            }

            public MilestoneReleaseOptions build() {
                return new MilestoneReleaseOptions(this.ignoredLabels, this.overrideRelease, this.includeAdditionalContext);
            }
        }
    }

    public static final class BranchReleaseOptions {
        public static final BranchReleaseOptions DEFAULT = new BranchReleaseOptions(null, new ArrayList<String>(), false, false, false, false);
        private final String title;
        private final List<String> ignoredLabels;
        private final boolean overrideRelease;
        private final boolean includeIssuesWithoutClosingKeyword;
        private final boolean includePullRequests;
        private final boolean includeAdditionalContext;

        private BranchReleaseOptions(String title, List<String> ignoredLabels, boolean overrideRelease, boolean includeIssuesWithoutClosingKeyword, boolean includePullRequests, boolean includeAdditionalContext) {
            this.title = title;
            this.ignoredLabels = ignoredLabels;
            this.overrideRelease = overrideRelease;
            this.includeIssuesWithoutClosingKeyword = includeIssuesWithoutClosingKeyword;
            this.includePullRequests = includePullRequests;
            this.includeAdditionalContext = includeAdditionalContext;
        }

        public String getTitle() {
            return this.title;
        }

        public List<String> getIgnoredLabels() {
            return this.ignoredLabels;
        }

        public boolean overrideRelease() {
            return this.overrideRelease;
        }

        public boolean includeIssuesWithoutClosingKeyword() {
            return this.includeIssuesWithoutClosingKeyword;
        }

        public boolean includePullRequests() {
            return this.includePullRequests;
        }

        public boolean includeAdditionalContext() {
            return this.includeAdditionalContext;
        }

        public String toString() {
            return "BranchReleaseOptions{title=" + this.title + ", ignoredLabels=" + this.ignoredLabels + ", overrideRelease=" + this.overrideRelease + ", includeIssuesWithoutClosingKeyword=" + this.includeIssuesWithoutClosingKeyword + ", includePullRequests=" + this.includePullRequests + ", includeAdditionalContext=" + this.includeAdditionalContext + '}';
        }

        public static final class Builder {
            private String title;
            private final List<String> ignoredLabels = new ArrayList<String>();
            private boolean overrideRelease;
            private boolean includeIssuesWithoutClosingKeyword;
            private boolean includePullRequests;
            private boolean includeAdditionalContext;

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder ignoreLabels(String ... labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder ignoreLabels(List<String> labels) {
                Objects.requireNonNull(labels);
                this.ignoredLabels.addAll(labels);
                return this;
            }

            public Builder overrideRelease(boolean overrideRelease) {
                this.overrideRelease = overrideRelease;
                return this;
            }

            public Builder includeIssuesWithoutClosingKeyword(boolean includeIssuesWithoutClosingKeyword) {
                this.includeIssuesWithoutClosingKeyword = includeIssuesWithoutClosingKeyword;
                return this;
            }

            public Builder includePullRequests(boolean includePullRequests) {
                this.includePullRequests = includePullRequests;
                return this;
            }

            public Builder includeAdditionalContext(boolean includeAdditionalContext) {
                this.includeAdditionalContext = includeAdditionalContext;
                return this;
            }

            public BranchReleaseOptions build() {
                return new BranchReleaseOptions(this.title, this.ignoredLabels, this.overrideRelease, this.includeIssuesWithoutClosingKeyword, this.includePullRequests, this.includeAdditionalContext);
            }
        }
    }

    public static final class ReleaseResult<T> {
        private final T releaseNotes;
        private final URL releaseUrl;
        private final ReleaseException error;

        private ReleaseResult(T releaseNotes, URL releaseUrl, ReleaseException error) {
            this.releaseNotes = releaseNotes;
            this.releaseUrl = releaseUrl;
            this.error = error;
        }

        public T getReleaseNotes() {
            return this.releaseNotes;
        }

        public URL getReleaseUrl() {
            return this.releaseUrl;
        }

        public ReleaseException getError() {
            return this.error;
        }

        public void throwIfFail() {
            if (this.isFail()) {
                throw this.error;
            }
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public boolean isFail() {
            return !this.isSuccess();
        }

        public static <T> ReleaseResult<T> success(T releaseNotes, URL url) {
            Objects.requireNonNull(url);
            return new ReleaseResult<T>(releaseNotes, url, null);
        }

        public static <T> ReleaseResult<T> fail(ReleaseException error) {
            return new ReleaseResult<Object>(null, null, error);
        }

        public static <T> ReleaseResult<T> fail(Throwable error) {
            return ReleaseResult.fail(new ReleaseException(error.getMessage()));
        }

        public String toString() {
            return "ReleaseResult{releaseNote=" + this.releaseNotes + ", releaseUrl=" + this.releaseUrl + ", error=" + this.error + '}';
        }
    }
}

