/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.ChronicleReaderMain;
import net.openhft.chronicle.queue.reader.ChronicleHistoryReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class ChronicleHistoryReaderMain {
    public static void main(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'args') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.main must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'args') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.main must not be null");
        }
        new ChronicleHistoryReaderMain().run(args);
    }

    protected void run(String[] args) {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        try (ChronicleHistoryReader chronicleHistoryReader = this.chronicleHistoryReader();){
            this.setup(commandLine, chronicleHistoryReader);
            chronicleHistoryReader.execute();
        }
    }

    protected void setup(@NotNull CommandLine commandLine, @NotNull ChronicleHistoryReader chronicleHistoryReader) {
        if (commandLine == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'commandLine') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.setup must not be null");
        }
        if (chronicleHistoryReader == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'chronicleHistoryReader') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.setup must not be null");
        }
        if (commandLine == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'commandLine') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.setup must not be null");
        }
        if (chronicleHistoryReader == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'chronicleHistoryReader') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.setup must not be null");
        }
        ((ChronicleHistoryReader)chronicleHistoryReader.withMessageSink(System.out::println)).withProgress(commandLine.hasOption('p')).withHistosByMethod(commandLine.hasOption('m')).withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('t')) {
            chronicleHistoryReader.withTimeUnit(TimeUnit.valueOf(commandLine.getOptionValue('t')));
        }
        if (commandLine.hasOption('i')) {
            chronicleHistoryReader.withIgnore(Long.parseLong(commandLine.getOptionValue('i')));
        }
        if (commandLine.hasOption('w')) {
            chronicleHistoryReader.withMeasurementWindow(Long.parseLong(commandLine.getOptionValue('w')));
        }
        if (commandLine.hasOption('u')) {
            chronicleHistoryReader.withSummaryOutput(Integer.parseInt(commandLine.getOptionValue('u')));
        }
    }

    @NotNull
    protected ChronicleHistoryReader chronicleHistoryReader() {
        ChronicleHistoryReader chronicleHistoryReader = new ChronicleHistoryReader();
        if (chronicleHistoryReader == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleHistoryReaderMain.chronicleHistoryReader must not return null");
        }
        if (chronicleHistoryReader == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleHistoryReaderMain.chronicleHistoryReader must not return null");
        }
        return chronicleHistoryReader;
    }

    protected CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        if (args == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'args') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.parseCommandLine must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'args') of net/openhft/chronicle/queue/ChronicleHistoryReaderMain.parseCommandLine must not be null");
        }
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelpAndExit(options, 0);
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit(options, 1, e.getMessage());
        }
        return commandLine;
    }

    protected void printHelpAndExit(Options options, int status) {
        this.printHelpAndExit(options, status, null);
    }

    protected void printHelpAndExit(Options options, int status, String message) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printHelp(writer, 180, this.getClass().getSimpleName(), message, options, 1, 3, null, true);
        writer.flush();
        System.exit(status);
    }

    @NotNull
    protected Options options() {
        Options options = new Options();
        ChronicleReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", true);
        ChronicleReaderMain.addOption(options, "h", "help-message", false, "Print this help and exit", false);
        ChronicleReaderMain.addOption(options, "t", "time unit", true, "Time unit. Default nanos", false);
        ChronicleReaderMain.addOption(options, "i", "ignore", true, "How many items to ignore from start", false);
        ChronicleReaderMain.addOption(options, "w", "window", true, "Window duration in time unit. Instead of one output at the end, will output every window period", false);
        ChronicleReaderMain.addOption(options, "u", "histo offset", true, "Summary output. Instead of histograms, will show one value only, in CSV format. Set this to 0 for 50th, 1 for 90th etc., -1 for worst", false);
        options.addOption(new Option("p", false, "Show progress"));
        options.addOption(new Option("m", false, "By method"));
        Options options2 = options;
        if (options2 == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleHistoryReaderMain.options must not return null");
        }
        if (options2 == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleHistoryReaderMain.options must not return null");
        }
        return options2;
    }
}

