/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel.impl;

import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.ThreadLocalAppender;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.NoDocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.converter.NanoTime;

public class PublishQueueChannel
implements ChronicleChannel {
    private final ChronicleChannelCfg channelCfg;
    private final AbstractHandler publishHandler;
    private final ChannelHeader headerOut;
    private final ChronicleQueue publishQueue;
    private final ExcerptTailer tailer;

    public PublishQueueChannel(ChronicleChannelCfg channelCfg, AbstractHandler publishHandler, ChronicleQueue publishQueue) {
        this.channelCfg = channelCfg;
        this.publishHandler = publishHandler;
        this.headerOut = publishHandler.responseHeader(null);
        this.publishQueue = publishQueue;
        this.tailer = publishQueue.createTailer();
    }

    public ChronicleChannelCfg channelCfg() {
        return this.channelCfg;
    }

    public ChannelHeader headerOut() {
        return this.headerOut;
    }

    public ChannelHeader headerIn() {
        return this.publishHandler;
    }

    public void close() {
        Closeable.closeQuietly((Object[])new Object[]{this.tailer, this.publishQueue});
    }

    public boolean isClosed() {
        return this.publishQueue.isClosed();
    }

    public DocumentContext readingDocument() {
        return NoDocumentContext.INSTANCE;
    }

    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        return ThreadLocalAppender.acquireThreadLocalAppender(this.publishQueue).writingDocument(metaData);
    }

    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        return ThreadLocalAppender.acquireThreadLocalAppender(this.publishQueue).acquireWritingDocument(metaData);
    }

    public void testMessage(long now) {
        try (DocumentContext dc = this.writingDocument(true);){
            dc.wire().write((CharSequence)"testMessage").writeLong(NanoTime.INSTANCE, now);
        }
    }

    public long lastTestMessage() {
        throw new UnsupportedOperationException();
    }
}

