/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceCountedCache<K, T extends ReferenceCounted, V, E extends Throwable> {
    private final Map<K, T> cache = new ConcurrentHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator) {
        this.transformer = transformer;
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    V get(@NotNull K key) throws E {
        this.cache.entrySet().removeIf(entry -> ((ReferenceCounted)entry.getValue()).refCount() == 0L);
        @Nullable ReferenceCounted value = (ReferenceCounted)this.cache.get(key);
        if (value == null || !value.tryReserve()) {
            value = (ReferenceCounted)this.creator.apply(key);
            this.cache.put(key, value);
        }
        try {
            V v = this.transformer.apply(value);
            return v;
        }
        finally {
            value.release();
        }
    }
}

