/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;

final class FileSystemDirectoryListing
implements DirectoryListing {
    private final File queueDir;
    private final ToIntFunction<File> fileToCycleFunction;

    FileSystemDirectoryListing(File queueDir, ToIntFunction<File> fileToCycleFunction) {
        this.queueDir = queueDir;
        this.fileToCycleFunction = fileToCycleFunction;
    }

    @Override
    public void onFileCreated(File file, int cycle) {
    }

    @Override
    public int getMaxCreatedCycle() {
        int maxCycle = Integer.MIN_VALUE;
        File[] files = this.queueDir.listFiles((d, n) -> n.endsWith(".cq4"));
        if (files != null) {
            for (File file : files) {
                maxCycle = Math.max(maxCycle, this.fileToCycleFunction.applyAsInt(file));
            }
        }
        return maxCycle;
    }

    @Override
    public int getMinCreatedCycle() {
        int minCycle = Integer.MAX_VALUE;
        File[] files = this.queueDir.listFiles((d, n) -> n.endsWith(".cq4"));
        if (files != null) {
            for (File file : files) {
                minCycle = Math.min(minCycle, this.fileToCycleFunction.applyAsInt(file));
            }
        }
        return minCycle;
    }

    @Override
    public long modCount() {
        return -1L;
    }

    public void close() {
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }
}

