/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;

public class TSQueueLock
extends AbstractTSQueueLock
implements QueueLock {
    private static final String LOCK_KEY = "chronicle.queue.lock";
    private static final long PID = Jvm.getProcessId();
    private final ThreadLocal<Long> lockHolderTidTL = new ThreadLocal();
    private final long timeout;

    public TSQueueLock(File queueDirectoryPath, Supplier<TimingPauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, queueDirectoryPath, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock() {
        this.closeCheck();
        long tid = Thread.currentThread().getId();
        try {
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
            this.lockHolderTidTL.set(tid);
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Couldn't acquire lock after " + this.timeout + "ms for the lock file:" + this.path + ", overriding the lock. Lock was held by PID " + this.lock.getVolatileValue());
            this.forceUnlock();
            this.acquireLock();
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void waitForLock() {
        this.closeCheck();
        if (this.isLockHeldByCurrentThread()) {
            return;
        }
        try {
            while (this.lock.getVolatileValue() != Long.MIN_VALUE) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Queue lock is still held after " + this.timeout + "ms for the lock file:" + this.path + ". Lock is held by PID " + this.lock.getVolatileValue() + ". Unlocking forcibly");
            this.forceUnlock();
        }
        catch (NullPointerException ex) {
            if (!this.tableStore.isClosed()) {
                throw ex;
            }
            throw new IllegalStateException("The table store is closed!", ex);
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void unlock() {
        this.closeCheck();
        if (!this.isLockHeldByCurrentThread()) {
            throw new IllegalStateException("Can't unlock when lock is not held by this thread");
        }
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Queue lock was unlocked by someone else!");
        }
        this.lockHolderTidTL.remove();
    }

    private boolean isLockHeldByCurrentThread() {
        long tid = Thread.currentThread().getId();
        Long lockHolderTid = this.lockHolderTidTL.get();
        return lockHolderTid != null && lockHolderTid == tid;
    }
}

