/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Sequence;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SCQIndexing
implements Demarshallable,
WriteMarshallable,
Closeable {
    private final int indexCount;
    private final int indexCountBits;
    private final int indexSpacing;
    private final int indexSpacingBits;
    private final LongValue index2Index;
    final LongValue nextEntryToBeIndexed;
    private final Supplier<LongArrayValues> longArraySupplier;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> index2indexArray;
    @NotNull
    private final ThreadLocal<WeakReference<LongArrayValuesHolder>> indexArray;
    @NotNull
    private final WriteMarshallable index2IndexTemplate;
    @NotNull
    private final WriteMarshallable indexTemplate;
    LongValue writePosition;
    Sequence sequence;

    @UsedViaReflection
    private SCQIndexing(@NotNull WireIn wire) {
        this(wire.read((WireKey)IndexingFields.indexCount).int32(), wire.read((WireKey)IndexingFields.indexSpacing).int32(), wire.read((WireKey)IndexingFields.index2Index).int64ForBinding(wire.newLongReference()), wire.read((WireKey)IndexingFields.lastIndex).int64ForBinding(wire.newLongReference()), () -> ((WireIn)wire).newLongArrayReference());
    }

    SCQIndexing(@NotNull WireType wireType, int indexCount, int indexSpacing) {
        this(indexCount, indexSpacing, (LongValue)wireType.newLongReference().get(), (LongValue)wireType.newLongReference().get(), wireType.newLongArrayReference());
    }

    public SCQIndexing(int indexCount, int indexSpacing, LongValue index2Index, LongValue nextEntryToBeIndexed, Supplier<LongArrayValues> longArraySupplier) {
        this.indexCount = indexCount;
        this.indexCountBits = Maths.intLog2((long)indexCount);
        this.indexSpacing = indexSpacing;
        this.indexSpacingBits = Maths.intLog2((long)indexSpacing);
        this.index2Index = index2Index;
        this.nextEntryToBeIndexed = nextEntryToBeIndexed;
        this.longArraySupplier = longArraySupplier;
        this.index2indexArray = new ThreadLocal();
        this.indexArray = new ThreadLocal();
        this.index2IndexTemplate = w -> w.writeEventName(() -> "index2index").int64array((long)indexCount);
        this.indexTemplate = w -> w.writeEventName(() -> "index").int64array((long)indexCount);
    }

    @Nullable
    private LongArrayValuesHolder getIndex2IndexArray() {
        return (LongArrayValuesHolder)ThreadLocalHelper.getTL(this.index2indexArray, this.longArraySupplier, las -> new LongArrayValuesHolder((LongArrayValues)las.get()));
    }

    @Nullable
    private LongArrayValuesHolder getIndexArray() {
        return (LongArrayValuesHolder)ThreadLocalHelper.getTL(this.indexArray, this.longArraySupplier, las -> new LongArrayValuesHolder((LongArrayValues)las.get()));
    }

    public long toAddress0(long index) {
        long siftedIndex = index >> this.indexSpacingBits + this.indexCountBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    long toAddress1(long index) {
        long siftedIndex = index >> this.indexSpacingBits;
        long mask = (long)this.indexCount - 1L;
        return mask & siftedIndex;
    }

    public void close() {
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)IndexingFields.indexCount).int64((long)this.indexCount).write((WireKey)IndexingFields.indexSpacing).int64((long)this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(0L, this.nextEntryToBeIndexed);
    }

    long indexToIndex(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        long index2Index = this.index2Index.getVolatileValue();
        return index2Index > 0L ? index2Index : this.acquireIndex2Index(recovery, ec, timeoutMS);
    }

    long acquireIndex2Index(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            return this.acquireIndex2Index0(recovery, ec, timeoutMS);
        }
        catch (TimeoutException fallback) {
            return recovery.recoverIndex2Index(this.index2Index, () -> this.acquireIndex2Index0(recovery, ec, timeoutMS), timeoutMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long acquireIndex2Index0(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS) throws EOFException, TimeoutException, UnrecoverableTimeoutException, StreamCorruptedException {
        long start = System.currentTimeMillis();
        Pauser pauser = ec.wireForIndex().pauser();
        try {
            do {
                long index2Index;
                if ((index2Index = this.index2Index.getVolatileValue()) == -1L) {
                    pauser.pause(timeoutMS, TimeUnit.MILLISECONDS);
                    continue;
                }
                if (index2Index != 0L) {
                    long l = index2Index;
                    return l;
                }
                if (!this.index2Index.compareAndSwapValue(0L, -1L)) continue;
                long index = 0L;
                try {
                    index = this.newIndex(recovery, ec, true, timeoutMS);
                }
                finally {
                    this.index2Index.setOrderedValue(index);
                }
                long l = index;
                return l;
            } while (System.currentTimeMillis() < start + timeoutMS);
        }
        finally {
            pauser.reset();
        }
        throw new TimeoutException("index2index NOT_COMPLETE for too long.");
    }

    @NotNull
    private LongArrayValues arrayForAddress(@NotNull Wire wire, long secondaryAddress) {
        LongArrayValuesHolder holder = this.getIndexArray();
        if (holder.address == secondaryAddress) {
            return holder.values;
        }
        holder.address = secondaryAddress;
        wire.bytes().readPositionRemaining(secondaryAddress, 4L);
        wire.readMetaDataHeader();
        return this.array((WireIn)wire, holder.values, false);
    }

    @NotNull
    private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using, boolean index2index) {
        String name;
        StringBuilder sb = Wires.acquireStringBuilder();
        ValueIn valueIn = w.readEventName(sb);
        String string = name = index2index ? "index2index" : "index";
        if (!name.contentEquals(sb)) {
            throw new IllegalStateException("expecting index, was " + sb);
        }
        valueIn.int64array(using, (Object)this, (o1, o2) -> {});
        return using;
    }

    long newIndex(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, boolean index2index, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        long writePosition = this.writePosition.getVolatileValue();
        Wire wire = ec.wireForIndex();
        wire.bytes().writePosition(writePosition);
        long position = recovery.writeHeader(wire, 0, this.indexCount * 8 + 128, timeoutMS, this.writePosition, this.sequence);
        WriteMarshallable writer = index2index ? this.index2IndexTemplate : this.indexTemplate;
        writer.writeMarshallable((WireOut)wire);
        wire.updateHeader(position, true);
        return position;
    }

    long newIndex(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, @NotNull LongArrayValues index2Index, long index2, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException, TimeoutException {
        try {
            long pos;
            if (index2Index.compareAndSet(index2, 0L, -1L)) {
                long pos2 = this.newIndex(recovery, ec, false, timeoutMS);
                if (pos2 < 0L) {
                    throw new IllegalStateException("pos: " + pos2);
                }
                if (index2Index.compareAndSet(index2, -1L, pos2)) {
                    index2Index.setMaxUsed(index2 + 1L);
                    return pos2;
                }
                throw new IllegalStateException("Index " + index2 + " in index2index was altered");
            }
            Pauser pauser = ec.wireForIndex().pauser();
            while ((pos = index2Index.getVolatileValueAt(index2)) == -1L) {
                pauser.pause(timeoutMS, TimeUnit.MILLISECONDS);
            }
            pauser.reset();
            return pos;
        }
        catch (Exception e) {
            index2Index.compareAndSet(index2, -1L, 0L);
            throw e;
        }
    }

    @Nullable
    ScanResult moveToIndex(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long index) throws UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            ScanResult scanResult = this.moveToIndex0(recovery, ec, index);
            if (scanResult != null) {
                return scanResult;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.moveToIndexFromTheStart(ec, index);
    }

    @NotNull
    private ScanResult moveToIndexFromTheStart(@NotNull ExcerptContext ec, long index) {
        try {
            Wire wire = ec.wire();
            wire.bytes().readPositionUnlimited(0L);
            if (wire.readDataHeader()) {
                return this.linearScan(wire, index, 0L, wire.bytes().readPosition());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return ScanResult.NOT_FOUND;
    }

    @Nullable
    private ScanResult moveToIndex0(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long index) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            LongArrayValues index2index = this.getIndex2index(recovery, ec, ec.timeoutMS());
            long secondaryAddress = 0L;
            long startIndex = index & (long)(~(this.indexSpacing - 1));
            for (long primaryOffset = this.toAddress0(index); primaryOffset >= 0L && (secondaryAddress = index2index.getValueAt(primaryOffset)) == 0L; --primaryOffset) {
                startIndex -= (long)(this.indexCount * this.indexSpacing);
            }
            if (secondaryAddress <= 0L) {
                return null;
            }
            LongArrayValues array1 = this.arrayForAddress(ec.wireForIndex(), secondaryAddress);
            long secondaryOffset = this.toAddress1(index);
            do {
                long fromAddress;
                if ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                    startIndex -= (long)this.indexSpacing;
                    continue;
                }
                if (index == startIndex) {
                    ec.wire().bytes().readPositionUnlimited(fromAddress);
                    return ScanResult.FOUND;
                }
                return this.linearScan(ec.wire(), index, startIndex, fromAddress);
            } while (--secondaryOffset >= 0L);
            return null;
        }
        catch (IllegalStateException e) {
            return this.linearScan(ec.wire(), index, -1L, 0L);
        }
    }

    @NotNull
    private ScanResult linearScan(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
        Bytes bytes = wire.bytes();
        bytes.readPositionUnlimited(knownAddress);
        long i = fromKnownIndex;
        while (true) {
            block6: {
                block5: {
                    try {
                        if (!wire.readDataHeader()) break block5;
                        if (i == toIndex) {
                            return ScanResult.FOUND;
                        }
                        int header = bytes.readInt();
                        if (Wires.isNotComplete((int)header)) {
                            return ScanResult.NOT_REACHED;
                        }
                        bytes.readSkip((long)Wires.lengthOf((int)header));
                        break block6;
                    }
                    catch (EOFException fallback) {
                        if (i != toIndex) break block5;
                        return ScanResult.END_OF_FILE;
                    }
                }
                return i == toIndex ? ScanResult.NOT_FOUND : ScanResult.NOT_REACHED;
            }
            ++i;
        }
    }

    ScanResult linearScanTo(long toIndex, long knownIndex, ExcerptContext ec, long knownAddress) {
        return this.linearScan(ec.wire(), toIndex, knownIndex, knownAddress);
    }

    long linearScanByPosition(@NotNull Wire wire, long toPosition, long indexOfNext, long startAddress, boolean inclusive) throws EOFException {
        assert (toPosition >= 0L);
        Bytes bytes = wire.bytes();
        bytes.readPositionUnlimited(startAddress);
        long i = indexOfNext - 1L;
        while (bytes.readPosition() <= toPosition) {
            int header;
            WireIn.HeaderType headerType;
            try {
                headerType = wire.readDataHeader(true);
            }
            catch (EOFException e) {
                if (toPosition == Long.MAX_VALUE) {
                    return i;
                }
                throw e;
            }
            if (!inclusive && toPosition == bytes.readPosition()) {
                return i;
            }
            switch (headerType) {
                case NONE: {
                    if (toPosition == Long.MAX_VALUE) {
                        return i;
                    }
                    header = bytes.readVolatileInt(bytes.readPosition());
                    throw new IllegalArgumentException("You can't know the index for an entry which hasn't been written. start: " + startAddress + ", at: " + bytes.readPosition() + ", header: " + Integer.toHexString(header) + ", toPos: " + toPosition);
                }
                case META_DATA: {
                    break;
                }
                case DATA: {
                    ++i;
                }
            }
            if (bytes.readPosition() == toPosition) {
                return i;
            }
            header = bytes.readVolatileInt();
            int len = Wires.lengthOf((int)header);
            assert (Wires.isReady((int)header));
            bytes.readSkip((long)len);
        }
        throw new IllegalArgumentException("position not the start of a message, bytes.readPosition()=" + bytes.readPosition() + ",toPosition=" + toPosition);
    }

    long nextEntryToBeIndexed() {
        return this.nextEntryToBeIndexed.getVolatileValue();
    }

    long sequenceForPosition(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long position, boolean inclusive) throws StreamCorruptedException {
        long lastKnownAddress;
        long indexOfNext;
        block11: {
            indexOfNext = 0L;
            lastKnownAddress = 0L;
            try {
                long timeoutMS = ((AbstractWire)ec.wire()).isInsideHeader() ? 0L : ec.timeoutMS();
                LongArrayValues index2indexArr = this.getIndex2index(recovery, ec, timeoutMS);
                if (((Byteable)index2indexArr).bytesStore() == null) {
                    return this.linearScanByPosition(ec.wireForIndex(), position, indexOfNext, lastKnownAddress, inclusive);
                }
                int used2 = Maths.toUInt31((long)index2indexArr.getUsed());
                if (used2 == 0) {
                    this.getSecondaryAddress(recovery, ec, timeoutMS, index2indexArr, 0);
                }
                for (int index2 = used2 - 1; index2 >= 0; --index2) {
                    long secondaryAddress = this.getSecondaryAddress(recovery, ec, timeoutMS, index2indexArr, index2);
                    if (secondaryAddress == 0L) continue;
                    LongArrayValues indexValues = this.arrayForAddress(ec.wireForIndex(), secondaryAddress);
                    int used = Maths.toUInt31((long)indexValues.getUsed());
                    assert (used >= 0);
                    if (used == 0) continue;
                    long posN = indexValues.getVolatileValueAt(0L);
                    assert (posN >= 0L);
                    if (posN > position) continue;
                    for (int index1 = used - 1; index1 >= 0; --index1) {
                        long pos = indexValues.getVolatileValueAt((long)index1);
                        if (pos == 0L || pos > position) continue;
                        lastKnownAddress = pos;
                        indexOfNext = ((long)index2 << this.indexCountBits + this.indexSpacingBits) + (long)(index1 << this.indexSpacingBits);
                        if (lastKnownAddress == position) {
                            return indexOfNext;
                        }
                        break block11;
                    }
                }
            }
            catch (EOFException | IllegalStateException e) {
                Jvm.debug().on(this.getClass(), "Attempt to find " + Long.toHexString(position), (Throwable)e);
            }
        }
        try {
            return this.linearScanByPosition(ec.wireForIndex(), position, indexOfNext, lastKnownAddress, inclusive);
        }
        catch (EOFException e) {
            throw new IllegalStateException(e);
        }
    }

    private LongArrayValues getIndex2index(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        LongArrayValuesHolder holder = this.getIndex2IndexArray();
        LongArrayValues values = holder.values;
        if (((Byteable)values).bytesStore() != null || timeoutMS == 0L) {
            return values;
        }
        long indexToIndex0 = this.indexToIndex(recovery, ec, timeoutMS);
        Wire wire = ec.wireForIndex();
        while (true) {
            DocumentContext context = wire.readingDocument(indexToIndex0);
            Throwable throwable = null;
            try {
                if (!context.isPresent() || !context.isMetaData()) {
                    wire.pauser().pause();
                    continue;
                }
                LongArrayValues longArrayValues = this.array((WireIn)wire, values, true);
                return longArrayValues;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                context.close();
                continue;
            }
            break;
        }
    }

    private long getSecondaryAddress(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS, @NotNull LongArrayValues index2indexArr, int index2) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        try {
            return this.getSecondaryAddress1(recovery, ec, timeoutMS, index2indexArr, index2);
        }
        catch (TimeoutException fallback) {
            ec.wire().pauser().reset();
            ec.wireForIndex().pauser().reset();
            return recovery.recoverSecondaryAddress(index2indexArr, index2, () -> this.getSecondaryAddress1(recovery, ec, timeoutMS, index2indexArr, index2), timeoutMS);
        }
    }

    long getSecondaryAddress1(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long timeoutMS, @NotNull LongArrayValues index2indexArr, int index2) throws EOFException, TimeoutException, UnrecoverableTimeoutException, StreamCorruptedException {
        long secondaryAddress = index2indexArr.getVolatileValueAt((long)index2);
        if (secondaryAddress == 0L) {
            if (timeoutMS == 0L) {
                return 0L;
            }
            secondaryAddress = this.newIndex(recovery, ec, index2indexArr, index2, timeoutMS);
            long sa = index2indexArr.getValueAt((long)index2);
            if (sa != secondaryAddress) {
                throw new AssertionError();
            }
        } else if (secondaryAddress == -1L) {
            secondaryAddress = this.getSecondaryAddress0(ec, timeoutMS, index2indexArr, index2);
        }
        return secondaryAddress;
    }

    private long getSecondaryAddress0(@NotNull ExcerptContext ec, long timeoutMS, @NotNull LongArrayValues index2indexArr, int index2) throws TimeoutException {
        long secondaryAddress;
        Pauser pauser = ec.wireForIndex().pauser();
        while ((secondaryAddress = index2indexArr.getVolatileValueAt((long)index2)) == -1L) {
            pauser.pause(timeoutMS, TimeUnit.MILLISECONDS);
        }
        pauser.reset();
        return secondaryAddress;
    }

    void setPositionForSequenceNumber(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec, long sequenceNumber, long position) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        if ((sequenceNumber & (long)(this.indexSpacing - 1)) != 0L) {
            return;
        }
        Wire wire = ec.wireForIndex();
        Bytes bytes = wire.bytes();
        if (position > bytes.capacity()) {
            throw new IllegalArgumentException("pos: " + position);
        }
        LongArrayValues index2indexArr = this.getIndex2index(recovery, ec, ec.timeoutMS());
        if (((Byteable)index2indexArr).bytesStore() == null) {
            assert (false);
            return;
        }
        int index2 = (int)(sequenceNumber >>> this.indexCountBits + this.indexSpacingBits);
        if (index2 >= this.indexCount) {
            throw new IllegalStateException("Unable to index " + sequenceNumber);
        }
        long secondaryAddress = this.getSecondaryAddress(recovery, ec, ec.timeoutMS(), index2indexArr, index2);
        if (secondaryAddress > bytes.capacity()) {
            throw new IllegalStateException("sa2: " + secondaryAddress);
        }
        bytes.readLimit(bytes.capacity());
        LongArrayValues indexValues = this.arrayForAddress(wire, secondaryAddress);
        int index3 = (int)(sequenceNumber >>> this.indexSpacingBits & (long)(this.indexCount - 1));
        long posN = indexValues.getValueAt((long)index3);
        if (posN == 0L) {
            indexValues.setValueAt((long)index3, position);
            indexValues.setMaxUsed((long)(index3 + 1));
        } else assert (posN == position);
        this.nextEntryToBeIndexed.setMaxValue(sequenceNumber + (long)this.indexSpacing);
    }

    public boolean indexable(long index) {
        return (index & (long)(this.indexSpacing - 1)) != 0L;
    }

    public long lastSequenceNumber(@NotNull StoreRecovery recovery, @NotNull ExcerptContext ec) throws StreamCorruptedException {
        return this.sequenceForPosition(recovery, ec, Long.MAX_VALUE, false);
    }

    int indexCount() {
        return this.indexCount;
    }

    int indexSpacing() {
        return this.indexSpacing;
    }

    static class LongArrayValuesHolder {
        final LongArrayValues values;
        long address;

        LongArrayValuesHolder(LongArrayValues values) {
            this.values = values;
            this.address = Long.MIN_VALUE;
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }
}

