/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.NoDocumentContext;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);

    public static class StoreTailer
    implements ExcerptTailer,
    SourceContext,
    ExcerptContext {
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreTailerContext context = new StoreTailerContext();
        private final int indexSpacingMask;
        long index;
        WireStore store;
        private int cycle;
        private long timeForNextCycle = Long.MAX_VALUE;
        private TailerDirection direction = TailerDirection.FORWARD;
        private boolean lazyIndexing = false;
        private Wire wireForIndex;
        private boolean readAfterReplicaAcknowledged;
        private TailerState state = TailerState.UNINITIALISED;

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.setCycle(Integer.MIN_VALUE);
            this.index = 0L;
            queue.addCloseListener(this, StoreTailer::close);
            this.indexSpacingMask = queue.rollCycle().defaultIndexSpacing() - 1;
        }

        private static boolean isReadOnly(Bytes bytes) {
            return bytes instanceof MappedBytes && !((MappedBytes)bytes).mappedFile().file().canWrite();
        }

        private void close() {
            this.context.wire(null);
            Wire w0 = this.wireForIndex;
            if (w0 != null) {
                w0.bytes().release();
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            this.store = null;
        }

        @Override
        public Wire wire() {
            return this.context.wire();
        }

        @Override
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        public String toString() {
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(this.index) + ", index cycle=" + this.queue.rollCycle().toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        public DocumentContext readingDocument(boolean includeMetaData) {
            try {
                if (this.context.present(this.next(includeMetaData))) {
                    assert (this.wire().startUse());
                    return this.context;
                }
                RollCycle rollCycle = this.queue.rollCycle();
                if (this.state == TailerState.CYCLE_NOT_FOUND && this.direction == TailerDirection.FORWARD) {
                    int firstCycle = this.queue.firstCycle();
                    if (rollCycle.toCycle(this.index) < firstCycle) {
                        this.toStart();
                    }
                }
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableTimeoutException unrecoverableTimeoutException) {
                // empty catch block
            }
            return NoDocumentContext.INSTANCE;
        }

        private boolean next(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            if (this.state == TailerState.FOUND_CYCLE) {
                try {
                    return this.inACycle(includeMetaData);
                }
                catch (EOFException eof) {
                    this.state = TailerState.END_OF_CYCLE;
                }
            }
            return this.next0(includeMetaData);
        }

        private boolean next0(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            block9: for (int i = 0; i < 1000; ++i) {
                switch (this.state) {
                    case UNINITIALISED: {
                        long firstIndex = this.queue.firstIndex();
                        if (firstIndex == Long.MAX_VALUE) {
                            return false;
                        }
                        if (this.moveToIndex(firstIndex)) continue block9;
                        return false;
                    }
                    case FOUND_CYCLE: {
                        try {
                            return this.inACycle(includeMetaData);
                        }
                        catch (EOFException eof) {
                            this.state = TailerState.END_OF_CYCLE;
                            continue block9;
                        }
                    }
                    case END_OF_CYCLE: {
                        long oldIndex = this.index;
                        int currentCycle = this.queue.rollCycle().toCycle(oldIndex);
                        long nextIndex = this.nextIndexWithNextAvailableCycle(currentCycle);
                        if (nextIndex != Long.MIN_VALUE && this.moveToIndex(nextIndex)) {
                            this.state = TailerState.FOUND_CYCLE;
                            continue block9;
                        }
                        this.moveToIndex(oldIndex);
                        this.state = TailerState.END_OF_CYCLE;
                        return false;
                    }
                    case BEYOND_START_OF_CYCLE: {
                        long nextIndex;
                        if (this.direction == TailerDirection.FORWARD) {
                            this.state = TailerState.UNINITIALISED;
                            continue block9;
                        }
                        if (this.direction == TailerDirection.BACKWARD) {
                            boolean foundCycle = this.cycle(this.queue.rollCycle().toCycle(this.index), false);
                            if (foundCycle) {
                                long lastSequenceNumberInThisCycle = this.store.sequenceForPosition(this, Long.MAX_VALUE, false);
                                nextIndex = this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumberInThisCycle);
                                this.moveToIndex(nextIndex);
                                this.state = TailerState.FOUND_CYCLE;
                                continue block9;
                            }
                            int cycle = this.queue.rollCycle().toCycle(this.index);
                            long nextIndex2 = this.nextIndexWithNextAvailableCycle(cycle);
                            if (nextIndex2 != Long.MIN_VALUE) {
                                this.moveToIndex(nextIndex2);
                                this.state = TailerState.FOUND_CYCLE;
                                continue block9;
                            }
                            this.state = TailerState.BEYOND_START_OF_CYCLE;
                            return false;
                        }
                        throw new AssertionError((Object)("direction not set, direction=" + (Object)((Object)this.direction)));
                    }
                    case CYCLE_NOT_FOUND: {
                        if (this.index == Long.MIN_VALUE) {
                            if (this.store != null) {
                                this.queue.release(this.store);
                            }
                            this.store = null;
                            return false;
                        }
                        if (this.moveToIndex(this.index)) {
                            this.state = TailerState.FOUND_CYCLE;
                            continue block9;
                        }
                        return false;
                    }
                    default: {
                        throw new AssertionError((Object)("state=" + (Object)((Object)this.state)));
                    }
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle, state=" + (Object)((Object)this.state));
        }

        private boolean inACycle(boolean includeMetaData) throws EOFException, StreamCorruptedException {
            Bytes bytes = this.wire().bytes();
            bytes.readLimit(bytes.capacity());
            if (this.readAfterReplicaAcknowledged) {
                long lastSequenceAck = this.store.lastAcknowledgedIndexReplicated();
                long seq = this.queue.rollCycle().toSequenceNumber(this.index);
                if (seq > lastSequenceAck) {
                    return false;
                }
            }
            if (this.direction != TailerDirection.FORWARD && !this.moveToIndex(this.index)) {
                return false;
            }
            switch (this.wire().readDataHeader(includeMetaData)) {
                case NONE: {
                    boolean cycleChange2;
                    long now = this.queue.time().currentTimeMillis();
                    boolean bl = cycleChange2 = now >= this.timeForNextCycle;
                    if (cycleChange2 && !StoreTailer.isReadOnly(bytes)) {
                        return this.checkMoveToNextCycle(includeMetaData, bytes);
                    }
                    return false;
                }
                case META_DATA: {
                    this.context.metaData(true);
                    break;
                }
                case DATA: {
                    this.context.metaData(false);
                }
            }
            if ((this.index & (long)this.indexSpacingMask) == 0L) {
                this.indexEntry(bytes);
            }
            this.context.closeReadLimit(bytes.capacity());
            this.wire().readAndSetLength(bytes.readPosition());
            long end = bytes.readLimit();
            this.context.closeReadPosition(end);
            return true;
        }

        private void indexEntry(Bytes<?> bytes) throws StreamCorruptedException {
            if (this.store.indexable(this.index) && !this.lazyIndexing && this.direction == TailerDirection.FORWARD && !this.context.isMetaData()) {
                this.store.setPositionForSequenceNumber(this, this.queue.rollCycle().toSequenceNumber(this.index), bytes.readPosition());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkMoveToNextCycle(boolean includeMetaData, Bytes<?> bytes) throws EOFException, StreamCorruptedException {
            long pos = bytes.readPosition();
            long lim = bytes.readLimit();
            long wlim = bytes.writeLimit();
            try {
                bytes.writePosition(pos);
                this.store.writeEOF(this.wire(), this.timeoutMS());
            }
            catch (TimeoutException e) {
                Jvm.warn().on(this.getClass(), "Unable to append EOF, skipping", (Throwable)e);
            }
            finally {
                bytes.writeLimit(wlim);
                bytes.readLimit(lim);
                bytes.readPosition(pos);
            }
            return this.inACycle(includeMetaData);
        }

        private long nextIndexWithNextAvailableCycle(int cycle) {
            long doubleCheck;
            long nextIndex;
            if (cycle == Integer.MIN_VALUE) {
                throw new AssertionError((Object)"cycle == Integer.MIN_VALUE");
            }
            do {
                int nextCycle;
                if ((nextIndex = this.nextIndexWithNextAvailableCycle0(cycle)) == Long.MIN_VALUE || (nextCycle = this.queue.rollCycle().toCycle(nextIndex)) != cycle + 1) continue;
                return nextIndex;
            } while (nextIndex != (doubleCheck = this.nextIndexWithNextAvailableCycle0(cycle)));
            if (nextIndex != Long.MIN_VALUE && this.queue.rollCycle().toCycle(nextIndex) - 1 != cycle) {
                LOG.debug("Rolled " + (this.queue.rollCycle().toCycle(nextIndex) - cycle) + " times to find the next cycle file. This can occur if your appenders have not written anything for a while, leaving the cycle files with a gap.");
            }
            return nextIndex;
        }

        private long nextIndexWithNextAvailableCycle0(int cycle) {
            if (cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) {
                return Long.MIN_VALUE;
            }
            int nextCycle = cycle + this.direction.add();
            boolean found = this.cycle(nextCycle, false);
            if (found) {
                return this.nextIndexWithinFoundCycle(nextCycle);
            }
            try {
                int nextCycle0 = this.queue.nextCycle(this.cycle, this.direction);
                if (nextCycle0 == -1) {
                    return Long.MIN_VALUE;
                }
                return this.nextIndexWithinFoundCycle(nextCycle0);
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }

        private long nextIndexWithinFoundCycle(int nextCycle) {
            this.state = TailerState.FOUND_CYCLE;
            if (this.direction == TailerDirection.FORWARD) {
                return this.queue.rollCycle().toIndex(nextCycle, 0L);
            }
            if (this.direction == TailerDirection.BACKWARD) {
                try {
                    long lastSequenceNumber0 = this.store.lastSequenceNumber(this);
                    return this.queue.rollCycle().toIndex(nextCycle, lastSequenceNumber0);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            throw new IllegalStateException("direction=" + (Object)((Object)this.direction));
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            ScanResult scanResult = this.moveToIndexResult(index);
            return scanResult == ScanResult.FOUND;
        }

        ScanResult moveToIndexResult(long index) {
            int cycle = this.queue.rollCycle().toCycle(index);
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            if (LOG.isDebugEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (!(cycle == this.cycle && this.state == TailerState.FOUND_CYCLE || this.cycle(cycle, false))) {
                return ScanResult.NOT_REACHED;
            }
            this.index(index);
            ScanResult scanResult = this.store.moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire().bytes();
            if (scanResult == ScanResult.FOUND) {
                this.state = TailerState.FOUND_CYCLE;
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                this.state = TailerState.UNINITIALISED;
                return this;
            }
            if (firstCycle != this.cycle) {
                boolean found = this.cycle(firstCycle, false);
                assert (found || this.store == null);
                if (found) {
                    this.state = TailerState.FOUND_CYCLE;
                }
            }
            this.index(this.queue.rollCycle().toIndex(this.cycle, 0L));
            this.state = TailerState.FOUND_CYCLE;
            if (this.wire() != null) {
                this.wire().bytes().readPosition(0L);
            }
            return this;
        }

        private long approximateLastIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                if (lastCycle == Integer.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                WireStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                assert (wireStore != null);
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.resetWires();
                }
                long sequenceNumber = this.store.lastSequenceNumber(this);
                return rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean headerNumberCheck(AbstractWire wire) {
            wire.headNumberCheck((actual, position) -> {
                try {
                    long expecting = this.store.sequenceForPosition(this, position, false);
                    if (actual == expecting) {
                        return true;
                    }
                    LOG.error("", (Throwable)((Object)new AssertionError((Object)("header number check failed expecting=" + expecting + "  !=  actual=" + actual))));
                    return false;
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    return false;
                }
            });
            return true;
        }

        private void resetWires() {
            WireType wireType = this.queue.wireType();
            AbstractWire wire = (AbstractWire)this.readAnywhere((Wire)wireType.apply((Object)this.store.bytes()));
            assert (this.headerNumberCheck(wire));
            this.context.wire(wire);
            Wire wireForIndexOld = this.wireForIndex;
            this.wireForIndex = this.readAnywhere((Wire)wireType.apply((Object)this.store.bytes()));
            assert (this.headerNumberCheck((AbstractWire)this.wireForIndex));
            if (wireForIndexOld != null) {
                wireForIndexOld.bytes().release();
            }
        }

        private Wire readAnywhere(Wire wire) {
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            return wire;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            long index = this.approximateLastIndex();
            if (index == Long.MIN_VALUE) {
                if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                    this.state = TailerState.UNINITIALISED;
                }
                return this;
            }
            switch (this.moveToIndexResult(index)) {
                case NOT_FOUND: {
                    throw new IllegalStateException("NOT_FOUND");
                }
                case FOUND: {
                    if (this.direction != TailerDirection.FORWARD) break;
                    switch (this.moveToIndexResult(++index)) {
                        case FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break;
                        }
                        case NOT_REACHED: {
                            throw new IllegalStateException("NOT_REACHED after FOUND");
                        }
                        case NOT_FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                        }
                    }
                    break;
                }
                case NOT_REACHED: {
                    this.approximateLastIndex();
                    throw new IllegalStateException("NOT_REACHED index: " + Long.toHexString(index));
                }
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        public ExcerptTailer direction(TailerDirection direction) {
            TailerDirection oldDirection = this.direction();
            this.direction = direction;
            if (oldDirection == TailerDirection.BACKWARD && direction == TailerDirection.FORWARD) {
                this.moveToIndex(this.index);
            }
            return this;
        }

        @Override
        public RollingChronicleQueue queue() {
            return this.queue;
        }

        private void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long seq = rollCycle.toSequenceNumber(this.index);
            int cycle = rollCycle.toCycle(this.index);
            seq += (long)this.direction.add();
            switch (this.direction) {
                case NONE: {
                    break;
                }
                case FORWARD: {
                    if (rollCycle.toSequenceNumber(seq) >= seq) break;
                    this.cycle(cycle + 1, false);
                    seq = 0L;
                    break;
                }
                case BACKWARD: {
                    if (seq >= 0L) break;
                    this.windBackCycle(cycle);
                    return;
                }
            }
            this.index = rollCycle.toIndex(cycle, seq);
        }

        private void windBackCycle(int cycle) {
            if (this.tryWindBack(cycle - 1)) {
                return;
            }
            --cycle;
            long first = this.queue.firstCycle();
            while ((long)cycle >= first) {
                if (this.tryWindBack(cycle)) {
                    return;
                }
                --cycle;
            }
            this.index(this.queue.rollCycle().toIndex(cycle, -1L));
            this.state = TailerState.BEYOND_START_OF_CYCLE;
        }

        private boolean tryWindBack(int cycle) {
            long count = this.queue.exceptsPerCycle(cycle);
            if (count <= 0L) {
                return false;
            }
            RollCycle rollCycle = this.queue.rollCycle();
            this.moveToIndex(rollCycle.toIndex(cycle, count - 1L));
            this.state = TailerState.FOUND_CYCLE;
            return true;
        }

        void index(long index) {
            this.index = index;
        }

        private boolean cycle(int cycle, boolean createIfAbsent) {
            if (this.cycle == cycle && this.state == TailerState.FOUND_CYCLE) {
                return true;
            }
            WireStore nextStore = this.queue.storeForCycle(cycle, this.queue.epoch(), createIfAbsent);
            if (nextStore == null && this.store == null) {
                return false;
            }
            if (nextStore == null) {
                this.state = this.direction == TailerDirection.BACKWARD ? TailerState.BEYOND_START_OF_CYCLE : TailerState.CYCLE_NOT_FOUND;
                return false;
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            if (nextStore == this.store) {
                return true;
            }
            this.context.wire(null);
            this.store = nextStore;
            this.state = TailerState.FOUND_CYCLE;
            this.setCycle(cycle);
            this.resetWires();
            Wire wire = this.wire();
            wire.parent((Object)this);
            wire.pauser(this.queue.pauserSupplier.get());
            return true;
        }

        void release() {
            if (this.store != null) {
                this.store.release();
                this.store = null;
            }
            this.state = TailerState.UNINITIALISED;
        }

        @Override
        public void readAfterReplicaAcknowledged(boolean readAfterReplicaAcknowledged) {
            this.readAfterReplicaAcknowledged = readAfterReplicaAcknowledged;
        }

        @Override
        public boolean readAfterReplicaAcknowledged() {
            return this.readAfterReplicaAcknowledged;
        }

        @Override
        public TailerState state() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExcerptTailer afterLastWritten(ChronicleQueue queue) {
            if (queue == this.queue) {
                throw new IllegalArgumentException("You must pass the queue written to, not the queue read");
            }
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            StringBuilder sb = new StringBuilder();
            VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(false);
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!context.isData()) {
                        this.toStart();
                        StoreTailer storeTailer = this;
                        return storeTailer;
                    }
                    ValueIn valueIn = context.wire().readEventName(sb);
                    if (!StringUtils.isEqual((CharSequence)"history", (CharSequence)sb)) continue;
                    Wire wire = context.wire();
                    Object parent = wire.parent();
                    try {
                        wire.parent(null);
                        valueIn.marshallable((ReadMarshallable)veh);
                    }
                    finally {
                        wire.parent(parent);
                    }
                    int i = veh.sources() - 1;
                    if (i < 0) continue;
                    long sourceIndex = veh.sourceIndex(i);
                    if (!this.moveToIndex(sourceIndex)) {
                        throw new IORuntimeException("Unable to wind to index: " + sourceIndex);
                    }
                    try (DocumentContext content = this.readingDocument();){
                        if (!content.isPresent()) {
                            throw new IORuntimeException("Unable to wind to index: " + (sourceIndex + 1L));
                        }
                    }
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UsedViaReflection
        public void lastAcknowledgedIndexReplicated(long acknowledgeIndex) {
            Jvm.debug().on(this.getClass(), "received lastAcknowledgedIndexReplicated=" + Long.toHexString(acknowledgeIndex) + " ,file=" + this.queue().file().getAbsolutePath());
            StoreTailer temp = this.queue.acquireTailer();
            try {
                RollCycle rollCycle = this.queue.rollCycle();
                int cycle0 = rollCycle.toCycle(acknowledgeIndex);
                if (!temp.cycle(cycle0, false)) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " for a cycle which could not found");
                    return;
                }
                if (temp.store == null) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " discarded.");
                    return;
                }
                temp.store.lastAcknowledgedIndexReplicated(acknowledgeIndex);
            }
            finally {
                temp.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastAcknowledgedIndexReplicated() throws EOFException {
            StoreTailer temp = (StoreTailer)this.queue.acquireTailer().toEnd();
            try {
                long l = temp.store.lastAcknowledgedIndexReplicated();
                return l;
            }
            finally {
                temp.release();
            }
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
            this.timeForNextCycle = cycle == Integer.MIN_VALUE ? Long.MAX_VALUE : (long)(cycle + 1) * (long)this.queue.rollCycle().length() + this.queue.epoch();
        }

        class StoreTailerContext
        extends ReadDocumentContext {
            StoreTailerContext() {
                super(null);
            }

            public long index() {
                return StoreTailer.this.index();
            }

            public int sourceId() {
                return StoreTailer.this.sourceId();
            }

            public void close() {
                if (this.isPresent()) {
                    StoreTailer.this.incrementIndex();
                }
                super.close();
            }

            boolean present(boolean present) {
                this.present = present;
                return this.present;
            }

            public void wire(@Nullable AbstractWire wire) {
                AbstractWire oldWire = this.wire;
                this.wire = wire;
                if (oldWire != null) {
                    oldWire.bytes().release();
                }
            }
        }
    }

    static class StoreAppender
    implements ExcerptAppender,
    ExcerptContext,
    InternalAppender {
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreAppenderContext context;
        WireStore store;
        private int cycle = Integer.MIN_VALUE;
        private Wire wire;
        private Wire bufferWire;
        private Wire wireForIndex;
        private long position = 0L;
        private volatile Thread appendingThread = null;
        private long lastIndex = Long.MIN_VALUE;
        private boolean lazyIndexing = false;
        private long lastPosition;
        private int lastCycle;
        private PretoucherState pretoucher = null;
        private MarshallableOut.Padding padToCacheLines = MarshallableOut.Padding.SMART;

        StoreAppender(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            queue.addCloseListener(this, StoreAppender::close);
            this.context = new StoreAppenderContext();
        }

        @Override
        public MarshallableOut.Padding padToCacheAlign() {
            return this.padToCacheLines;
        }

        @Override
        public void padToCacheAlign(MarshallableOut.Padding padToCacheLines) {
            this.padToCacheLines = padToCacheLines;
        }

        public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                marshallable.writeMarshallable((BytesOut)dc.wire().bytes());
                if (this.padToCacheAlign() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        public void writeText(CharSequence text) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                dc.wire().bytes().append8bit(text);
                if (this.padToCacheAlign() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        void close() {
            Wire w0 = this.wireForIndex;
            this.wireForIndex = null;
            if (w0 != null) {
                w0.bytes().release();
            }
            Wire w = this.wire;
            this.wire = null;
            if (w != null) {
                w.bytes().release();
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            this.store = null;
        }

        @Override
        public void pretouch() {
            this.setCycle(this.queue.cycle(), true);
            if (this.pretoucher == null) {
                this.pretoucher = new PretoucherState(() -> this.store.writePosition());
            }
            this.pretoucher.pretouch((MappedBytes)this.wire.bytes());
        }

        @Override
        public Wire wire() {
            return this.wire;
        }

        @Override
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        void lastIndex(long index) {
            this.lastIndex = index;
        }

        public boolean recordHistory() {
            return this.sourceId() != 0;
        }

        private void setCycle(int cycle, boolean createIfAbsent) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle, createIfAbsent);
            }
        }

        private void setCycle2(int cycle, boolean createIfAbsent) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            SingleChronicleQueue queue = this.queue;
            if (this.store != null) {
                queue.release(this.store);
            }
            this.store = queue.storeForCycle(cycle, queue.epoch(), createIfAbsent);
            this.resetWires(queue);
            this.cycle = cycle;
            assert (this.wire.startUse());
            this.wire.parent((Object)this);
            this.wire.pauser(queue.pauserSupplier.get());
            this.resetPosition();
            queue.onRoll(cycle);
        }

        private void resetWires(SingleChronicleQueue queue) {
            WireType wireType = queue.wireType();
            Wire oldw = this.wire;
            this.wire = (Wire)wireType.apply((Object)this.store.bytes());
            if (oldw != null) {
                oldw.bytes().release();
            }
            Wire old = this.wireForIndex;
            this.wireForIndex = (Wire)wireType.apply((Object)this.store.bytes());
            if (old != null) {
                old.bytes().release();
            }
        }

        private void resetPosition() throws UnrecoverableTimeoutException {
            try {
                if (this.store == null || this.wire == null) {
                    return;
                }
                this.position(this.store.writePosition());
                Bytes bytes = this.wire.bytes();
                int header = bytes.readVolatileInt(this.position);
                assert (this.position == 0L || Wires.isReadyData((int)header));
                bytes.writePosition(this.position + 4L + (long)Wires.lengthOf((int)header));
                if (this.lazyIndexing) {
                    this.wire.headerNumber(Long.MIN_VALUE);
                    return;
                }
                long headerNumber = this.store.sequenceForPosition(this, this.position, true);
                this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber + 1L) - 1L);
                assert (this.lazyIndexing || this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.position));
            }
            catch (StreamCorruptedException | BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
            assert (this.checkWritePositionHeaderNumber());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            assert (this.checkWritePositionHeaderNumber());
            boolean ok = false;
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle || this.wire == null) {
                    this.rollCycleTo(cycle);
                }
                for (int i = 0; i <= 100; ++i) {
                    try {
                        assert (this.wire != null);
                        long pos = this.store.writeHeader(this.wire, 0, (int)(this.queue.blockSize() / 4L), this.timeoutMS());
                        this.position(pos);
                        this.context.isClosed = false;
                        this.context.metaData = false;
                        this.context.wire = this.wire;
                        this.context.padToCacheAlign = this.padToCacheAlign() != MarshallableOut.Padding.NEVER;
                        break;
                    }
                    catch (EOFException theySeeMeRolling) {
                        assert (!((AbstractWire)this.wire).isInsideHeader());
                        int qCycle = this.queue.cycle();
                        if (cycle < this.queue.cycle()) {
                            cycle = qCycle;
                            this.setCycle2(cycle, true);
                        } else if (cycle == qCycle) {
                            this.setCycle2(++cycle, true);
                        } else {
                            throw new IllegalStateException("Found an EOF on the next cycle file, this next file, should not have an EOF as its cycle number is greater than the current cycle (based on the current time), this should only happen if it was written by a different appender set with a different EPOC or different roll cycle.All your appenders ( that write to a given directory ) should have the same EPOCH and roll cycle qCycle=" + qCycle + ", cycle=" + cycle);
                        }
                        if (i != 100) continue;
                        throw new IllegalStateException("Unable to roll to the current cycle");
                    }
                }
                ok = true;
            }
            finally {
                if (!ok) assert (this.resetAppendingThread());
            }
            this.context.metaData(metaData);
            return this.context;
        }

        boolean checkWritePositionHeaderNumber() {
            if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
                return true;
            }
            try {
                long pos1 = this.position;
                long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, pos1, true);
                if (seq1 != seq2) {
                    String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + "  pos1: " + pos1 + " seq1: " + seq1 + " seq2: " + seq2;
                    System.err.println(message);
                    throw new AssertionError((Object)message);
                }
            }
            catch (IOException e) {
                Jvm.fatal().on(this.getClass(), (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
            return true;
        }

        @Override
        public DocumentContext writingDocument(long index) {
            this.context.isClosed = false;
            assert (this.checkAppendingThread());
            this.context.wire = this.acquireBufferWire();
            this.context.wire.headerNumber(index);
            this.context.isClosed = false;
            return this.context;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @Override
        public void writeBytes(@NotNull BytesStore bytes) throws UnrecoverableTimeoutException {
            this.append(Maths.toUInt31((long)bytes.readRemaining()), (m, w) -> {
                Bytes cfr_ignored_0 = (Bytes)w.bytes().write(m);
            }, bytes);
        }

        Wire acquireBufferWire() {
            if (this.bufferWire == null) {
                this.bufferWire = (Wire)this.queue.wireType().apply((Object)Bytes.elasticByteBuffer());
            } else {
                this.bufferWire.clear();
            }
            return this.bufferWire;
        }

        @Override
        public void writeBytes(long index, BytesStore bytes) {
            block14: {
                if (index < 0L) {
                    throw new IllegalArgumentException("index: " + index);
                }
                if (bytes.isEmpty()) {
                    throw new UnsupportedOperationException("Cannot append a zero length message");
                }
                assert (this.checkAppendingThread());
                try {
                    this.moveToIndexForWrite(index);
                    Bytes wireBytes = this.wire.bytes();
                    try {
                        int length = bytes.length();
                        this.wire.headerNumber(index);
                        this.position(this.store.writeHeader(this.wire, length, length, this.timeoutMS()));
                        wireBytes.write(bytes);
                        this.wire.updateHeader(length, this.position, false);
                        this.writeIndexForPosition(index, this.position);
                        this.lastIndex(index);
                        this.lastPosition = this.position;
                        this.lastCycle = this.cycle;
                        this.store.writePosition(this.position);
                    }
                    catch (EOFException theySeeMeRolling) {
                        if (wireBytes.compareAndSwapInt(wireBytes.writePosition(), -1073741824, Integer.MIN_VALUE)) {
                            wireBytes.write(bytes);
                            this.wire.updateHeader(0, this.position, false);
                        }
                    }
                }
                catch (IllegalStateException ise) {
                    if (!ise.getMessage().contains("index already exists")) {
                        Jvm.warn().on(this.getClass(), "Ignoring duplicate", (Throwable)ise);
                        throw ise;
                    }
                }
                catch (EOFException | StreamCorruptedException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                finally {
                    if (this.wire == null) break block14;
                    Bytes wireBytes = this.wire.bytes();
                    if ($assertionsDisabled || this.resetAppendingThread()) break block14;
                    throw new AssertionError();
                }
            }
        }

        private void position(long position) {
            if (position > this.store.writePosition() + this.queue.blockSize()) {
                throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
            }
            this.position = position;
        }

        private void moveToIndexForWrite(long index) throws EOFException {
            if (this.wire != null && this.wire.headerNumber() == index) {
                return;
            }
            int cycle = this.queue.rollCycle().toCycle(index);
            ScanResult scanResult = this.moveToIndex(cycle, this.queue.rollCycle().toSequenceNumber(index));
            switch (scanResult) {
                case FOUND: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " as the index already exists");
                }
                case NOT_REACHED: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue");
                }
            }
        }

        ScanResult moveToIndex(int cycle, long sequenceNumber) throws UnrecoverableTimeoutException {
            if (LOG.isDebugEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (this.cycle != cycle) {
                if (cycle > this.cycle) {
                    this.rollCycleTo(cycle);
                } else {
                    this.setCycle2(cycle, true);
                }
            }
            ScanResult scanResult = this.store.moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire.bytes();
            if (scanResult == ScanResult.NOT_FOUND) {
                bytes.writePosition(bytes.readPosition());
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        public long lastIndexAppended() {
            if (this.lastIndex != Long.MIN_VALUE) {
                return this.lastIndex;
            }
            if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
                throw new IllegalStateException("nothing has been appended, so there is no last index");
            }
            try {
                long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
                long index = this.queue.rollCycle().toIndex(this.lastCycle, sequenceNumber);
                this.lastIndex(index);
                return index;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int cycle() {
            if (this.cycle == Integer.MIN_VALUE) {
                int cycle = this.queue.lastCycle();
                if (cycle < 0) {
                    cycle = this.queue.cycle();
                }
                this.setCycle2(cycle, true);
            }
            return this.cycle;
        }

        @Override
        public SingleChronicleQueue queue() {
            return this.queue;
        }

        void beforeAppend(Wire wire, long index) {
        }

        private <T> void append(int length, WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle || this.wire == null) {
                    this.rollCycleTo(cycle);
                }
                try {
                    this.position(this.store.writeHeader(this.wire, length, length, this.timeoutMS()));
                    assert (((AbstractWire)this.wire).isInsideHeader());
                    this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
                    wireWriter.write(writer, (WireOut)this.wire);
                    this.wire.updateHeader(length, this.position, false);
                    this.lastIndex(this.wire.headerNumber());
                    this.lastPosition = this.position;
                    this.lastCycle = cycle;
                    this.store.writePosition(this.position);
                    this.writeIndexForPosition(this.lastIndex, this.position);
                }
                catch (EOFException theySeeMeRolling) {
                    try {
                        this.append2(length, wireWriter, writer);
                    }
                    catch (EOFException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            catch (StreamCorruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                assert (this.resetAppendingThread());
            }
        }

        private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
            if (this.cycle == cycle) {
                throw new AssertionError();
            }
            if (this.wire != null) {
                try {
                    this.store.writeEOF(this.wire, this.timeoutMS());
                }
                catch (TimeoutException e) {
                    Jvm.warn().on(SingleChronicleQueueExcerpts.class, "Unable to terminate the previous cycle, continuing", (Throwable)e);
                }
            }
            this.setCycle2(cycle, true);
        }

        public void writeEndOfCycleIfRequired() {
            if (this.wire != null && this.queue.cycle() != this.cycle) {
                try {
                    this.store.writeEOF(this.wire, this.timeoutMS());
                }
                catch (TimeoutException e) {
                    Jvm.warn().on(SingleChronicleQueueExcerpts.class, "Unable to terminate the previous cycle, continuing", (Throwable)e);
                }
            }
        }

        <T> void append2(int length, WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException, EOFException, StreamCorruptedException {
            this.setCycle(Math.max(this.queue.cycle(), this.cycle + 1), true);
            this.position(this.store.writeHeader(this.wire, length, length, this.timeoutMS()));
            this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
            wireWriter.write(writer, (WireOut)this.wire);
            this.wire.updateHeader(length, this.position, false);
        }

        private boolean checkAppendingThread() {
            Thread appendingThread = this.appendingThread;
            Thread currentThread = Thread.currentThread();
            if (appendingThread != null) {
                if (appendingThread == currentThread) {
                    throw new IllegalStateException("Nested blocks of writingDocument() not supported");
                }
                throw new IllegalStateException("Attempting to use Appender in " + currentThread + " while used by " + appendingThread);
            }
            this.appendingThread = currentThread;
            return true;
        }

        private boolean resetAppendingThread() {
            if (this.appendingThread == null) {
                throw new IllegalStateException("Attempting to release Appender in " + Thread.currentThread() + " but already released");
            }
            this.appendingThread = null;
            return true;
        }

        void writeIndexForPosition(long index, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
            if (!this.lazyIndexing) {
                long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
                this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
            }
        }

        boolean checkIndex(long index, long position) {
            try {
                long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, position, true);
                if (seq1 != seq2) {
                    long seq3 = ((SingleChronicleQueueStore)this.store).indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                    System.out.println("Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                    System.out.println(this.store.dump());
                    assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                    assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        class StoreAppenderContext
        implements DocumentContext {
            boolean isClosed;
            boolean padToCacheAlign = true;
            private boolean metaData = false;
            private Wire wire;

            StoreAppenderContext() {
            }

            public int sourceId() {
                return StoreAppender.this.sourceId();
            }

            public boolean isPresent() {
                return false;
            }

            public Wire wire() {
                return this.wire;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void metaData(boolean metaData) {
                this.metaData = metaData;
            }

            public boolean isClosed() {
                return this.isClosed;
            }

            public void close() {
                if (this.isClosed) {
                    LOG.warn("Already Closed, close was called twice.");
                    return;
                }
                try {
                    if (this.wire == StoreAppender.this.wire) {
                        if (this.padToCacheAlign) {
                            this.wire.padToCacheAlign();
                        }
                        this.wire.updateHeader(StoreAppender.this.position, this.metaData);
                        StoreAppender.this.lastPosition = StoreAppender.this.position;
                        StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                        if (!this.metaData) {
                            StoreAppender.this.lastIndex(this.wire.headerNumber());
                            StoreAppender.this.store.writePosition(StoreAppender.this.position);
                            if (StoreAppender.this.lastIndex != Long.MIN_VALUE) {
                                StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.position);
                            } else assert (StoreAppender.this.lazyIndexing || StoreAppender.this.lastIndex == Long.MIN_VALUE || StoreAppender.this.checkIndex(StoreAppender.this.lastIndex, StoreAppender.this.position));
                        }
                        assert (StoreAppender.this.checkWritePositionHeaderNumber());
                    } else if (this.wire != null) {
                        this.isClosed = true;
                        assert (StoreAppender.this.resetAppendingThread());
                        StoreAppender.this.writeBytes(this.wire.headerNumber(), (BytesStore)this.wire.bytes());
                        this.wire = StoreAppender.this.wire;
                    }
                }
                catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    assert (this.isClosed || StoreAppender.this.resetAppendingThread());
                }
            }

            public long index() throws IORuntimeException {
                if (this.wire.headerNumber() == Long.MIN_VALUE) {
                    try {
                        long headerNumber0 = StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.sequenceForPosition(StoreAppender.this, StoreAppender.this.position, false));
                        assert (((AbstractWire)this.wire).isInsideHeader());
                        return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                }
                return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
            }

            public boolean isNotComplete() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface InternalAppender {
        public void writeBytes(long var1, BytesStore var3);
    }

    @FunctionalInterface
    static interface WireWriter<T> {
        public void write(T var1, WireOut var2);
    }
}

