/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.NoDocumentContext;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);

    public static class StoreTailer
    implements ExcerptTailer,
    SourceContext {
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreTailerContext context = new StoreTailerContext();
        private int cycle;
        private long index;
        private WireStore store;
        private TailerDirection direction = TailerDirection.FORWARD;
        private boolean lazyIndexing = false;
        private int indexSpacingMask;

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.cycle = Integer.MIN_VALUE;
            this.index = 0L;
            this.indexSpacingMask = queue.rollCycle().defaultIndexSpacing() - 1;
            this.toStart();
        }

        @Override
        public ExcerptTailer lazyIndexing(boolean lazyIndexing) {
            this.lazyIndexing = lazyIndexing;
            return this;
        }

        @Override
        public boolean lazyIndexing() {
            return this.lazyIndexing;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        public String toString() {
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(this.index) + ", index cycle=" + this.queue.rollCycle().toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        public DocumentContext readingDocument(boolean includeMetaData) {
            try {
                assert (this.context.wire() == null || this.context.wire().startUse());
                if (this.context.present(this.next(includeMetaData))) {
                    return this.context;
                }
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableTimeoutException unrecoverableTimeoutException) {
                // empty catch block
            }
            return NoDocumentContext.INSTANCE;
        }

        private boolean next(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            if (this.store == null) {
                long firstIndex = this.queue.firstIndex();
                if (firstIndex == Long.MAX_VALUE) {
                    return false;
                }
                if (!this.moveToIndex(firstIndex)) {
                    return false;
                }
            }
            Bytes bytes = this.context.wire().bytes();
            bytes.readLimit(bytes.capacity());
            for (int i = 0; i < 1000; ++i) {
                try {
                    if (this.direction != TailerDirection.FORWARD && !this.moveToIndex(this.index)) {
                        return false;
                    }
                    switch (this.context.wire().readDataHeader(includeMetaData)) {
                        case NONE: {
                            return false;
                        }
                        case META_DATA: {
                            this.context.metaData(true);
                            break;
                        }
                        case DATA: {
                            this.context.metaData(false);
                        }
                    }
                    if (!this.lazyIndexing && this.direction == TailerDirection.FORWARD && (this.index & (long)this.indexSpacingMask) == 0L && !this.context.isMetaData()) {
                        this.store.setPositionForSequenceNumber(this.context.wire(), this.queue.rollCycle().toSequenceNumber(this.index), bytes.readPosition(), this.queue.timeoutMS);
                    }
                    this.context.closeReadLimit(bytes.capacity());
                    this.context.wire().readAndSetLength(bytes.readPosition());
                    long end = bytes.readLimit();
                    this.context.closeReadPosition(end);
                    return true;
                }
                catch (EOFException eof) {
                    if (this.cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE || this.moveToIndex(this.cycle + this.direction.add(), 0L) != ScanResult.FOUND) {
                        return false;
                    }
                    bytes = this.context.wire().bytes();
                    continue;
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle");
        }

        @Override
        public long index() {
            if (this.store == null) {
                return Long.MIN_VALUE;
            }
            return this.queue.rollCycle().toIndex(this.cycle, this.index);
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            ScanResult scanResult = this.moveToIndexResult(index);
            return scanResult == ScanResult.FOUND;
        }

        ScanResult moveToIndexResult(long index) {
            int cycle = this.queue.rollCycle().toCycle(index);
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            return this.moveToIndex(cycle, sequenceNumber, index);
        }

        ScanResult moveToIndex(int cycle, long sequenceNumber) {
            return this.moveToIndex(cycle, sequenceNumber, this.queue.rollCycle().toIndex(cycle, sequenceNumber));
        }

        ScanResult moveToIndex(int cycle, long sequenceNumber, long index) {
            if (LOG.isDebugEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (cycle != this.cycle) {
                this.cycle(cycle, false);
            }
            this.index = index;
            if (this.store == null) {
                return ScanResult.NOT_REACHED;
            }
            ScanResult scanResult = this.store.moveToIndexForRead(this.context.wire(), sequenceNumber, this.queue.timeoutMS);
            Bytes bytes = this.context.wire().bytes();
            if (scanResult == ScanResult.FOUND) {
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                return this;
            }
            if (firstCycle != this.cycle) {
                this.cycle(firstCycle, false);
            }
            this.index = this.queue.rollCycle().toIndex(this.cycle, 0L);
            if (this.context.wire() != null) {
                this.context.wire().bytes().readPosition(0L);
            }
            return this;
        }

        private long approximateLastIndex() {
            try {
                RollCycle rollCycle = this.queue.rollCycle();
                int lastCycle = this.queue.lastCycle();
                if (lastCycle == Integer.MIN_VALUE) {
                    return rollCycle.toIndex(this.queue.cycle(), 0L);
                }
                WireStore store = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                if (store == null) {
                    return Long.MIN_VALUE;
                }
                Wire wire = (Wire)this.queue.wireType().apply((Object)store.bytes());
                long position = store.writePosition();
                long sequenceNumber = store.sequenceForPosition(wire, position, 0L);
                return rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            long index = this.approximateLastIndex();
            if (index == Long.MIN_VALUE) {
                return this;
            }
            if (this.direction != TailerDirection.FORWARD && this.queue.rollCycle().toSequenceNumber(index) != 0L) {
                --index;
            }
            if (this.moveToIndexResult(index) == ScanResult.NOT_REACHED && this.moveToIndexResult(index - 1L) == ScanResult.NOT_REACHED) {
                Jvm.debug().on(this.getClass(), "Failed to moveToIndex(" + Long.toHexString(index - 1L) + " for toEnd()");
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        public ExcerptTailer direction(TailerDirection direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public RollingChronicleQueue queue() {
            return this.queue;
        }

        private <T> boolean __read(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            if (this.store == null) {
                this.toStart();
                if (this.store == null) {
                    return false;
                }
            }
            if (this.read0(t, c)) {
                this.incrementIndex();
                return true;
            }
            return false;
        }

        private void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long seq = rollCycle.toSequenceNumber(this.index);
            if (rollCycle.toSequenceNumber(seq += (long)this.direction.add()) < seq) {
                this.cycle(this.cycle + 1, false);
                seq = 0L;
            } else if (seq < 0L) {
                if (seq == -1L) {
                    this.cycle(this.cycle - 1, false);
                } else {
                    throw new IllegalStateException("Winding to the previous day not supported");
                }
            }
            this.index = rollCycle.toIndex(this.cycle, seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <T> boolean read0(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            Wire wire = this.context.wire();
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            for (int i = 0; i < 1000; ++i) {
                boolean bl;
                if (this.direction != TailerDirection.FORWARD && !this.moveToIndex(this.index)) {
                    return false;
                }
                if (!wire.readDataHeader()) return false;
                wire.readAndSetLength(bytes.readPosition());
                long end = bytes.readLimit();
                try {
                    c.accept(t, wire);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(end);
                        throw throwable;
                    }
                    catch (EOFException eof) {
                        if (this.cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE || this.moveToIndex(this.cycle + this.direction.add(), 0L) != ScanResult.FOUND) {
                            return false;
                        }
                        bytes = wire.bytes();
                        continue;
                    }
                }
                ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(end);
                return bl;
            }
            throw new IllegalStateException("Unable to progress to the next cycle");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private StoreTailer cycle(int cycle, boolean createIfAbsent) {
            if (this.cycle != cycle) {
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.store = this.queue.storeForCycle(cycle, this.queue.epoch(), createIfAbsent);
                if (this.store == null) {
                    this.context.wire(null);
                    return this;
                }
                this.cycle = cycle;
                this.context.wire((AbstractWire)this.queue.wireType().apply((Object)this.store.bytes()));
                Wire wire = this.context.wire();
                assert (wire.startUse());
                try {
                    wire.parent((Object)this);
                    wire.pauser(this.queue.pauserSupplier.get());
                }
                finally {
                    assert (wire.endUse());
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExcerptTailer afterLastWritten(ChronicleQueue queue) {
            if (queue == this.queue) {
                throw new IllegalArgumentException("You must pass the queue written to, not the queue read");
            }
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            StringBuilder sb = new StringBuilder();
            VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(false);
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!context.isData()) {
                        this.toStart();
                        StoreTailer storeTailer = this;
                        return storeTailer;
                    }
                    ValueIn valueIn = context.wire().readEventName(sb);
                    if (!StringUtils.isEqual((CharSequence)"history", (CharSequence)sb)) continue;
                    Wire wire = context.wire();
                    Object parent = wire.parent();
                    try {
                        wire.parent(null);
                        valueIn.marshallable((ReadMarshallable)veh);
                    }
                    finally {
                        wire.parent(parent);
                    }
                    int i = veh.sources() - 1;
                    if (i < 0) continue;
                    long sourceIndex = veh.sourceIndex(i);
                    if (!this.moveToIndex(sourceIndex)) {
                        throw new IORuntimeException("Unable to wind to index: " + sourceIndex);
                    }
                    try (DocumentContext content = this.readingDocument();){
                        if (!content.isPresent()) {
                            throw new IORuntimeException("Unable to wind to index: " + (sourceIndex + 1L));
                        }
                    }
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }

        @UsedViaReflection
        public void lastAcknowledgedIndexReplicated(long acknowledgeIndex) {
            if (this.store != null) {
                this.store.lastAcknowledgedIndexReplicated(acknowledgeIndex);
            }
        }

        class StoreTailerContext
        extends ReadDocumentContext {
            public StoreTailerContext() {
                super(null);
            }

            public long index() {
                return StoreTailer.this.index();
            }

            public int sourceId() {
                return StoreTailer.this.sourceId();
            }

            public void close() {
                if (this.isPresent()) {
                    StoreTailer.this.incrementIndex();
                }
                super.close();
            }

            public boolean present(boolean present) {
                this.present = present;
                return this.present;
            }

            public void wire(AbstractWire wire) {
                this.wire = wire;
            }
        }
    }

    public static class StoreAppender
    implements ExcerptAppender {
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreAppenderContext context;
        private int cycle = Integer.MIN_VALUE;
        private WireStore store;
        private Wire wire;
        private Wire bufferWire;
        private long position = -1L;
        private volatile Thread appendingThread = null;
        private long lastIndex = Long.MIN_VALUE;
        private boolean lazyIndexing = false;
        private long lastPosition;
        private int lastCycle;

        public StoreAppender(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.context = new StoreAppenderContext();
        }

        @Override
        public ExcerptAppender lazyIndexing(boolean lazyIndexing) {
            this.lazyIndexing = lazyIndexing;
            this.resetPosition();
            return this;
        }

        @Override
        public boolean lazyIndexing() {
            return this.lazyIndexing;
        }

        public boolean recordHistory() {
            return this.sourceId() != 0;
        }

        private void setCycle(int cycle, boolean createIfAbsent) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle, createIfAbsent);
            }
        }

        private void setCycle2(int cycle, boolean createIfAbsent) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            SingleChronicleQueue queue = this.queue;
            if (this.store != null) {
                queue.release(this.store);
            }
            this.store = queue.storeForCycle(cycle, queue.epoch(), createIfAbsent);
            this.wire = (Wire)queue.wireType().apply((Object)this.store.bytes());
            if (this.store == null) {
                this.wire = null;
                return;
            }
            this.cycle = cycle;
            this.wire = (Wire)queue.wireType().apply((Object)this.store.bytes());
            this.cycle = cycle;
            assert (this.wire.startUse());
            this.wire.parent((Object)this);
            this.wire.pauser(queue.pauserSupplier.get());
            this.resetPosition();
        }

        private void resetPosition() throws UnrecoverableTimeoutException {
            try {
                if (this.store == null || this.wire == null) {
                    return;
                }
                long position = this.store.writePosition();
                this.wire.bytes().writePosition(position);
                if (this.lazyIndexing) {
                    return;
                }
                long headerNumber = this.store.sequenceForPosition(this.wire, position, this.queue.timeoutMS);
                this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber) - 1L);
            }
            catch (EOFException | StreamCorruptedException | BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DocumentContext writingDocument() throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            boolean ok = false;
            try {
                for (int i = 0; i < 100; ++i) {
                    try {
                        int cycle = this.queue.cycle();
                        if (this.cycle != cycle || this.wire == null) {
                            this.rollCycleTo(cycle);
                        }
                        this.position = this.wire.bytes().writePosition();
                        assert (this.wire != null);
                        this.position(this.store.writeHeader(this.wire, 0, this.queue.timeoutMS));
                        this.context.metaData = false;
                        this.context.wire = this.wire;
                        break;
                    }
                    catch (EOFException eOFException) {
                        continue;
                    }
                }
                ok = true;
            }
            finally {
                if (!ok) assert (this.resetAppendingThread());
            }
            return this.context;
        }

        @Override
        public DocumentContext writingDocument(long index) {
            assert (this.checkAppendingThread());
            this.context.wire = this.acquireBufferWire();
            this.context.wire.headerNumber(index);
            return this.context;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        public void writeBytes(@NotNull Bytes bytes) throws UnrecoverableTimeoutException {
            this.append(Maths.toUInt31((long)bytes.readRemaining()), (m, w) -> {
                Bytes cfr_ignored_0 = (Bytes)w.bytes().write((BytesStore)m);
            }, bytes);
        }

        Wire acquireBufferWire() {
            if (this.bufferWire == null) {
                this.bufferWire = (Wire)this.queue.wireType().apply((Object)Bytes.elasticByteBuffer());
            } else {
                this.bufferWire.clear();
            }
            return this.bufferWire;
        }

        @Override
        public void writeBytes(long index, BytesStore bytes) throws StreamCorruptedException {
            if (bytes.isEmpty()) {
                throw new UnsupportedOperationException("Cannot append a zero length message");
            }
            assert (this.checkAppendingThread());
            try {
                this.moveToIndexForWrite(index);
                Bytes wireBytes = this.wire.bytes();
                try {
                    int length = bytes.length();
                    this.position(this.store.writeHeader(this.wire, length, this.queue.timeoutMS));
                    wireBytes.write(bytes);
                    this.wire.updateHeader(length, this.position, false);
                    this.lastIndex = this.wire.headerNumber();
                    this.lastPosition = this.position;
                    this.lastCycle = this.cycle;
                }
                catch (EOFException theySeeMeRolling) {
                    if (wireBytes.compareAndSwapInt(wireBytes.writePosition(), -1073741824, Integer.MIN_VALUE)) {
                        wireBytes.write(bytes);
                        this.wire.updateHeader(0, this.position, false);
                    }
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            finally {
                if (this.wire != null) {
                    Bytes wireBytes = this.wire.bytes();
                    this.store.writePosition(wireBytes.writePosition());
                    assert (this.resetAppendingThread());
                }
            }
        }

        private void position(long position) {
            this.position = position;
        }

        void moveToIndexForWrite(long index) throws EOFException {
            int cycle = this.queue.rollCycle().toCycle(index);
            ScanResult scanResult = this.moveToIndex(cycle, this.queue.rollCycle().toSequenceNumber(index));
            switch (scanResult) {
                case FOUND: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " as the index already exists");
                }
                case NOT_REACHED: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue");
                }
            }
        }

        ScanResult moveToIndex(int cycle, long sequenceNumber) throws UnrecoverableTimeoutException, EOFException {
            if (LOG.isDebugEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (this.cycle != cycle) {
                if (cycle > this.cycle) {
                    this.rollCycleTo(cycle);
                } else {
                    this.setCycle2(cycle, true);
                }
            }
            ScanResult scanResult = this.store.moveToIndexForRead(this.wire, sequenceNumber, this.queue.timeoutMS);
            Bytes bytes = this.wire.bytes();
            if (scanResult == ScanResult.NOT_FOUND) {
                this.wire.bytes().writePosition(this.wire.bytes().readPosition());
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        public long lastIndexAppended() {
            if (this.lastIndex != Long.MIN_VALUE) {
                return this.lastIndex;
            }
            if (this.lastPosition != Long.MIN_VALUE && this.wire != null) {
                try {
                    this.lastIndex = this.queue.rollCycle().toIndex(this.lastCycle, this.store.sequenceForPosition(this.wire, this.lastPosition, 0L));
                    return this.lastIndex;
                }
                catch (Exception e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            }
            throw new IllegalStateException("nothing has been appended, so there is no last index");
        }

        @Override
        public int cycle() {
            if (this.cycle == Integer.MIN_VALUE) {
                int cycle = this.queue.lastCycle();
                if (cycle < 0) {
                    cycle = this.queue.cycle();
                }
                this.setCycle2(cycle, true);
            }
            return this.cycle;
        }

        @Override
        public SingleChronicleQueue queue() {
            return this.queue;
        }

        private <T> void append(int length, WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle || this.wire == null) {
                    this.rollCycleTo(cycle);
                }
                try {
                    this.position(this.store.writeHeader(this.wire, length, this.queue.timeoutMS));
                    wireWriter.write(writer, (WireOut)this.wire);
                    this.wire.updateHeader(length, this.position, false);
                    this.lastIndex = this.wire.headerNumber();
                    this.lastPosition = this.position;
                    this.lastCycle = cycle;
                    this.store.writePosition(this.wire.bytes().writePosition());
                    this.writeIndexForPosition(this.lastIndex, this.position, this.queue.timeoutMS);
                }
                catch (EOFException theySeeMeRolling) {
                    try {
                        this.append2(length, wireWriter, writer);
                    }
                    catch (EOFException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            catch (StreamCorruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                assert (this.resetAppendingThread());
            }
        }

        private long headerNumber() {
            if (this.wire.headerNumber() == Long.MIN_VALUE) {
                try {
                    long headerNumber = this.store.sequenceForPosition(this.wire, this.position, 0L);
                    this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber));
                }
                catch (Exception e) {
                    Jvm.rethrow((Throwable)e);
                }
            }
            return this.wire.headerNumber();
        }

        private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
            if (this.cycle == cycle) {
                throw new AssertionError();
            }
            if (this.wire != null) {
                this.store.writeEOF(this.wire, this.queue.timeoutMS);
            }
            this.setCycle2(cycle, true);
            this.resetPosition();
        }

        private <T> void append2(int length, WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException, EOFException, StreamCorruptedException {
            this.setCycle(Math.max(this.queue.cycle(), this.cycle + 1), true);
            this.position(this.store.writeHeader(this.wire, length, this.queue.timeoutMS));
            wireWriter.write(writer, (WireOut)this.wire);
            this.wire.updateHeader(length, this.position, false);
        }

        private boolean checkAppendingThread() {
            Thread appendingThread = this.appendingThread;
            Thread currentThread = Thread.currentThread();
            if (appendingThread != null) {
                if (appendingThread == currentThread) {
                    throw new IllegalStateException("Nested blocks of writingDocument() not supported");
                }
                throw new IllegalStateException("Attempting to use Appender in " + currentThread + " while used by " + appendingThread);
            }
            this.appendingThread = currentThread;
            return true;
        }

        private boolean resetAppendingThread() {
            if (this.appendingThread == null) {
                throw new IllegalStateException("Attempting to release Appender in " + Thread.currentThread() + " but already released");
            }
            this.appendingThread = null;
            return true;
        }

        void writeIndexForPosition(long index, long position, long timeoutMS) throws UnrecoverableTimeoutException, StreamCorruptedException {
            assert (this.lazyIndexing || this.checkIndex(index, position, timeoutMS));
            if (!this.lazyIndexing) {
                this.store.setPositionForSequenceNumber(this.wire, this.queue.rollCycle().toSequenceNumber(index), position, timeoutMS);
            }
        }

        boolean checkIndex(long index, long position, long timeoutMS) {
            try {
                long seq1 = this.queue.rollCycle().toSequenceNumber(index);
                long seq2 = this.store.sequenceForPosition(this.wire, position, timeoutMS);
                if (seq1 != seq2) {
                    long seq3 = ((SingleChronicleQueueStore)this.store).indexing.linearScanByPosition(this.wire, position, 0L, 0L);
                    System.out.println(Long.toHexString(seq1) + " - " + Long.toHexString(seq2) + " - " + Long.toHexString(seq3));
                    this.store.sequenceForPosition(this.wire, position, timeoutMS);
                    assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        class StoreAppenderContext
        implements DocumentContext {
            private boolean metaData = false;
            private Wire wire;

            StoreAppenderContext() {
            }

            public int sourceId() {
                return StoreAppender.this.sourceId();
            }

            public boolean isPresent() {
                return false;
            }

            public Wire wire() {
                return this.wire;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void metaData(boolean metaData) {
                this.metaData = metaData;
            }

            public void close() {
                block14: {
                    boolean isClosed = false;
                    try {
                        assert (this.wire.bytes().writePosition() >= StoreAppender.this.position);
                        if (this.wire == StoreAppender.this.wire) {
                            this.wire.updateHeader(StoreAppender.this.position, this.metaData);
                            assert (!((AbstractWire)this.wire).isInsideHeader());
                            StoreAppender.this.lastIndex = this.wire.headerNumber();
                            StoreAppender.this.lastPosition = StoreAppender.this.position;
                            StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                            if (!this.metaData && StoreAppender.this.lastIndex != Long.MIN_VALUE) {
                                StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.position, ((StoreAppender)StoreAppender.this).queue.timeoutMS);
                            }
                            StoreAppender.this.store.writePosition(this.wire.bytes().writePosition());
                        } else {
                            isClosed = true;
                            assert (StoreAppender.this.resetAppendingThread());
                            StoreAppender.this.writeBytes(this.wire.headerNumber(), (BytesStore)this.wire.bytes());
                        }
                    }
                    catch (BufferUnderflowException bue) {
                        if (!this.wire.bytes().isClosed()) {
                            throw bue;
                        }
                    }
                    catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                        throw new IllegalStateException(e);
                    }
                    finally {
                        if ($assertionsDisabled || isClosed || StoreAppender.this.resetAppendingThread()) break block14;
                        throw new AssertionError();
                    }
                }
            }

            public long index() throws IORuntimeException {
                if (this.wire.headerNumber() == Long.MIN_VALUE) {
                    try {
                        long headerNumber0 = StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.sequenceForPosition(this.wire, StoreAppender.this.position, 0L));
                        assert (((AbstractWire)this.wire).isInsideHeader());
                        this.wire.headerNumber(headerNumber0 - 1L);
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                }
                return this.isMetaData() ? this.wire.headerNumber() : this.wire.headerNumber() + 1L;
            }

            public boolean isNotComplete() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @FunctionalInterface
    public static interface WireWriter<T> {
        public void write(T var1, WireOut var2);
    }
}

