/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SimpleStoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleChronicleQueueStore
implements WireStore {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueStore.class);
    @NotNull
    private final WireIn wire;
    @NotNull
    private final WireType wireType;
    @NotNull
    private final SCQRoll roll;
    @NotNull
    private final LongValue writePosition;
    private final MappedBytes mappedBytes;
    private final MappedFile mappedFile;
    @NotNull
    private final SCQIndexing indexing;
    @NotNull
    private final ReferenceCounter refCount;
    private final StoreRecovery recovery;
    @Nullable
    private LongValue lastAcknowledgedIndexReplicated;

    @UsedViaReflection
    private SingleChronicleQueueStore(WireIn wire) {
        assert (wire.startUse());
        this.wire = wire;
        this.wireType = (WireType)wire.read((WireKey)MetaDataField.wireType).object(WireType.class);
        assert (this.wireType != null);
        this.writePosition = wire.newLongReference();
        this.wire.read((WireKey)MetaDataField.writePosition).int64(this.writePosition);
        this.roll = (SCQRoll)wire.read((WireKey)MetaDataField.roll).typedMarshallable();
        this.mappedBytes = (MappedBytes)wire.bytes();
        this.mappedFile = this.mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        this.indexing = (SCQIndexing)wire.read((WireKey)MetaDataField.indexing).typedMarshallable();
        assert (this.indexing != null);
        this.indexing.writePosition = this.writePosition;
        this.lastAcknowledgedIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64ForBinding(null) : null;
        this.recovery = wire.bytes().readRemaining() > 0L ? (StoreRecovery)wire.read((WireKey)MetaDataField.recovery).typedMarshallable() : new SimpleStoreRecovery();
    }

    SingleChronicleQueueStore(@Nullable RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, long epoch, int indexCount, int indexSpacing, StoreRecovery recovery) {
        this.recovery = recovery;
        this.roll = new SCQRoll(rollCycle, epoch);
        this.wire = null;
        this.wireType = wireType;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        indexCount = Maths.nextPower2((int)indexCount, (int)8);
        indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newLongReference().get();
        this.lastAcknowledgedIndexReplicated = (LongValue)wireType.newLongReference().get();
    }

    public static void dumpStore(Wire wire) {
        Bytes bytes = wire.bytes();
        bytes.readPosition(0L);
        LOG.debug(Wires.fromSizePrefixedBlobs((Bytes)bytes));
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        bytes.readLimit(bytes.realCapacity());
        return Wires.fromSizePrefixedBlobs((Bytes)bytes);
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    public WireStore writePosition(long position) {
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    public long epoch() {
        return this.roll.epoch();
    }

    @Override
    public ScanResult moveToIndexForRead(@NotNull Wire wire, long index, long timeoutMS) {
        try {
            return this.indexing.moveToIndex(this.recovery, wire, index, timeoutMS);
        }
        catch (UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
        catch (StreamCorruptedException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes((MappedFile)this.mappedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long indexForPosition(Wire wire, long position, long timeoutMS) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        Bytes bytes = wire.bytes();
        long position0 = bytes.readPosition();
        long remaining0 = bytes.readRemaining();
        try {
            long l = this.indexing.indexForPosition(this.recovery, wire, position, timeoutMS);
            return l;
        }
        finally {
            bytes.readPositionRemaining(position0, remaining0);
        }
    }

    public String toString() {
        return "SingleChronicleQueueStore{indexing=" + this.indexing + ", wireType=" + this.wireType + ", roll=" + this.roll + ", writePosition=" + this.writePosition + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + ", lastAcknowledgedIndexReplicated=" + this.lastAcknowledgedIndexReplicated + '}';
    }

    private void onCleanup() {
        if (this.wire != null) assert (this.wire.endUse());
        this.mappedBytes.release();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        if (this.lastAcknowledgedIndexReplicated == null) {
            this.lastAcknowledgedIndexReplicated = wire.newLongReference();
        }
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType).write((WireKey)MetaDataField.writePosition).int64forBinding(0L, this.writePosition).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing).write((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64forBinding(0L, this.lastAcknowledgedIndexReplicated);
        wire.write((WireKey)MetaDataField.recovery).typedMarshallable((WriteMarshallable)this.recovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPositionForIndex(Wire wire, long index, long position, long timeoutMS) throws UnrecoverableTimeoutException, StreamCorruptedException {
        Bytes bytes = wire.bytes();
        if (position < 0L || position > bytes.capacity()) {
            throw new IllegalArgumentException("position: " + position);
        }
        long readPosition = bytes.readPosition();
        long readRemaining = bytes.readRemaining();
        try {
            this.indexing.setPositionForIndex(this.recovery, wire, index, position, timeoutMS);
        }
        catch (EOFException eOFException) {
        }
        finally {
            bytes.readPositionRemaining(readPosition, readRemaining);
        }
    }

    @Override
    public long writeHeader(Wire wire, int length, long timeoutMS) throws EOFException, UnrecoverableTimeoutException {
        return this.recovery.writeHeader(wire, length, timeoutMS);
    }

    @Override
    public void writeEOF(AbstractWire wire, long timeoutMS) throws UnrecoverableTimeoutException {
        try {
            wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.recovery.writeEndOfWire((Wire)wire, timeoutMS);
        }
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{SCQIndexing.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "Roll");
    }

    static enum MetaDataField implements WireKey
    {
        wireType,
        writePosition,
        roll,
        indexing,
        lastAcknowledgedIndexReplicated,
        recovery;


        @Nullable
        public Object defaultValue() {
            throw new IORuntimeException("field " + (String)this.name() + " required");
        }
    }
}

