/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import org.jetbrains.annotations.NotNull;

public class WireStorePool {
    @NotNull
    private final WireStoreSupplier supplier;
    @NotNull
    private final Map<RollDetails, WireStore> stores;

    private WireStorePool(@NotNull WireStoreSupplier supplier) {
        this.supplier = supplier;
        this.stores = new ConcurrentHashMap<RollDetails, WireStore>();
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier) {
        return new WireStorePool(supplier);
    }

    public void close() {
    }

    public synchronized WireStore acquire(int cycle, long epoch) {
        RollDetails rollDetails = new RollDetails(cycle, epoch);
        WireStore store = this.stores.get(rollDetails);
        if (store == null) {
            store = (WireStore)this.supplier.apply(cycle, epoch);
            this.stores.put(rollDetails, store);
        } else {
            store.reserve();
        }
        return store;
    }

    public synchronized void release(@NotNull WireStore store) {
        store.release();
        if (store.refCount() <= 0L) {
            for (Map.Entry<RollDetails, WireStore> entry : this.stores.entrySet()) {
                if (entry.getValue() != store) continue;
                this.stores.remove(entry.getKey());
            }
        }
    }

    private class RollDetails {
        private final long cycle;
        private final long epoch;

        public RollDetails(long cycle, long epoch) {
            this.cycle = cycle;
            this.epoch = epoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RollDetails)) {
                return false;
            }
            RollDetails rollDetails = (RollDetails)o;
            return this.cycle == rollDetails.cycle && this.epoch == rollDetails.epoch;
        }

        public int hashCode() {
            int result = (int)(this.cycle ^ this.cycle >>> 32);
            result = 31 * result + (int)(this.epoch ^ this.epoch >>> 32);
            return result;
        }
    }
}

