/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    private static final long LONG_NOT_READY = -1L;
    private static final long NUMBER_OF_ENTRIES_IN_EACH_INDEX = 131072L;
    @NotNull
    private final WireType wireType;
    @NotNull
    private final Roll roll;
    @NotNull
    private final LongValue writePosition;
    private final MappedFile mappedFile;
    @NotNull
    private final Indexing indexing;
    @Nullable
    private Closeable resourceCleaner;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);

    @UsedViaReflection
    private SingleChronicleQueueStore(WireIn wire) {
        this.wireType = (WireType)wire.read((WireKey)MetaDataField.wireType).object(WireType.class);
        assert (this.wireType != null);
        this.writePosition = wire.newLongReference();
        wire.read((WireKey)MetaDataField.writePosition).int64(this.writePosition);
        this.roll = (Roll)wire.read((WireKey)MetaDataField.roll).typedMarshallable();
        MappedBytes mappedBytes = (MappedBytes)wire.bytes();
        this.mappedFile = mappedBytes.mappedFile();
        this.indexing = (Indexing)wire.read((WireKey)MetaDataField.indexing).typedMarshallable();
        assert (this.indexing != null);
        this.indexing.writePosition = this.writePosition;
    }

    public SingleChronicleQueueStore(@Nullable RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, long rollEpoc, int indexCount, int indexSpacing) {
        this.roll = new Roll(rollCycle, rollEpoc);
        this.resourceCleaner = null;
        this.wireType = wireType;
        this.mappedFile = mappedBytes.mappedFile();
        indexCount = Maths.nextPower2((int)indexCount, (int)8);
        indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.indexing = new Indexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newLongReference().get();
    }

    public static void dumpStore(Wire wire) {
        Bytes bytes = wire.bytes();
        bytes.readPosition(0L);
        System.out.println(Wires.fromSizePrefixedBlobs((Bytes)bytes));
    }

    @Override
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        bytes.readLimit(bytes.realCapacity());
        return Wires.fromSizePrefixedBlobs((Bytes)bytes);
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    public WireStore writePosition(long position) {
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    public long epoch() {
        return this.roll.epoch();
    }

    @Override
    public long lastEntryIndexed(Wire wire, long timeoutMS) {
        return this.indexing.lastEntryIndexed(wire, timeoutMS);
    }

    @Override
    public boolean appendRollMeta(@NotNull Wire wire, long cycle, long timeoutMS) throws TimeoutException {
        wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS);
        return true;
    }

    @Override
    public ScanResult moveToIndex(@NotNull Wire wire, long index, long timeoutMS) throws TimeoutException {
        return this.indexing.moveToIndex(wire, index, timeoutMS);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @NotNull
    public MappedBytes mappedBytes() {
        return MappedBytes.mappedBytes((MappedFile)this.mappedFile);
    }

    @Override
    public long indexForPosition(Wire wire, long position, long timeoutMS) throws EOFException, TimeoutException {
        return this.indexing.indexForPosition(wire, position, timeoutMS);
    }

    private synchronized void performRelease() {
        try {
            if (this.resourceCleaner != null) {
                this.resourceCleaner.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType).write((WireKey)MetaDataField.writePosition).int64forBinding(0L, this.writePosition).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(Indexing.class, "Indexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(Roll.class, "Roll");
    }

    static class Roll
    implements Demarshallable,
    WriteMarshallable {
        private final long epoch;
        private final int length;
        @Nullable
        private final String format;

        private Roll(WireIn wire) {
            this.length = wire.read((WireKey)RollFields.length).int32();
            this.format = wire.read((WireKey)RollFields.format).text();
            this.epoch = wire.read((WireKey)RollFields.epoch).int64();
        }

        Roll(@NotNull RollCycle rollCycle, long rollEpoch) {
            this.length = rollCycle.length();
            this.format = rollCycle.format();
            this.epoch = rollEpoch;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((WireKey)RollFields.length).int32(this.length).write((WireKey)RollFields.format).text((CharSequence)this.format).write((WireKey)RollFields.epoch).int64(this.epoch);
        }

        public long epoch() {
            return this.epoch;
        }
    }

    static class Indexing
    implements Demarshallable,
    WriteMarshallable {
        private final int indexCount;
        private final int indexCountBits;
        private final int indexSpacing;
        private final int indexSpacingBits;
        private final LongValue index2Index;
        private final LongValue nextEntryToIndex;
        private final ThreadLocal<LongArrayValues> index2indexArray;
        private final ThreadLocal<LongArrayValues> indexArray;
        private final WriteMarshallable index2IndexTemplate;
        private final WriteMarshallable indexTemplate;
        LongValue writePosition;

        private Indexing(@NotNull WireIn wire) {
            this(wire.read((WireKey)IndexingFields.indexCount).int32(), wire.read((WireKey)IndexingFields.indexSpacing).int32(), wire.read((WireKey)IndexingFields.index2Index).int64ForBinding(wire.newLongReference()), wire.read((WireKey)IndexingFields.lastIndex).int64ForBinding(wire.newLongReference()), () -> ((WireIn)wire).newLongArrayReference());
        }

        Indexing(@NotNull WireType wireType, int indexCount, int indexSpacing) {
            this(indexCount, indexSpacing, (LongValue)wireType.newLongReference().get(), (LongValue)wireType.newLongReference().get(), wireType.newLongArrayReference());
        }

        public Indexing(int indexCount, int indexSpacing, LongValue index2Index, LongValue nextEntryToIndex, Supplier<LongArrayValues> longArraySupplier) {
            this.indexCount = indexCount;
            this.indexCountBits = Maths.intLog2((long)indexCount);
            this.indexSpacing = indexSpacing;
            this.indexSpacingBits = Maths.intLog2((long)indexSpacing);
            this.index2Index = index2Index;
            this.nextEntryToIndex = nextEntryToIndex;
            this.index2indexArray = ThreadLocal.withInitial(longArraySupplier);
            this.indexArray = ThreadLocal.withInitial(longArraySupplier);
            this.index2IndexTemplate = w -> w.writeEventName(() -> "index2index").int64array((long)indexCount);
            this.indexTemplate = w -> w.writeEventName(() -> "index").int64array((long)indexCount);
        }

        public long toAddress0(long index) {
            long siftedIndex = index >> this.indexSpacingBits + this.indexCountBits;
            long mask = (long)this.indexCount - 1L;
            long maskedShiftedIndex = mask & siftedIndex;
            return maskedShiftedIndex;
        }

        public long toAddress1(long index) {
            long siftedIndex = index >> this.indexSpacingBits;
            long mask = (long)this.indexCount - 1L;
            return mask & siftedIndex;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((WireKey)IndexingFields.indexCount).int64((long)this.indexCount).write((WireKey)IndexingFields.indexSpacing).int64((long)this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.lastIndex).int64forBinding(0L, this.nextEntryToIndex);
        }

        long indexToIndex(@NotNull Wire wire, long timeoutMS) throws EOFException, TimeoutException {
            long index2Index = this.index2Index.getVolatileValue();
            return index2Index > 0L ? index2Index : this.acquireIndex2Index(wire, timeoutMS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long acquireIndex2Index(Wire wire, long timeoutMS) throws EOFException, TimeoutException {
            long start = System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() < start + timeoutMS) {
                    long index2Index = this.index2Index.getVolatileValue();
                    if (index2Index == -1L) {
                        wire.pauser().pause(timeoutMS, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    if (index2Index != 0L) {
                        long l = index2Index;
                        return l;
                    }
                    if (!this.index2Index.compareAndSwapValue(0L, -1L)) continue;
                    long index = 0L;
                    try {
                        index = this.newIndex(wire, true, timeoutMS);
                    }
                    finally {
                        this.index2Index.setOrderedValue(index);
                    }
                    long l = index;
                    return l;
                }
            }
            finally {
                wire.pauser().reset();
            }
            throw new IllegalStateException("index2index NOT_READY for too long.");
        }

        @NotNull
        private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using, boolean index2index) {
            String name;
            StringBuilder sb = Wires.acquireStringBuilder();
            ValueIn valueIn = w.readEventName(sb);
            String string = name = index2index ? "index2index" : "index";
            if (!name.contentEquals(sb)) {
                throw new IllegalStateException("expecting index, was " + sb);
            }
            valueIn.int64array(using, (Object)this, (o1, o2) -> {});
            return using;
        }

        long newIndex(@NotNull Wire wire, boolean index2index, long timeoutMS) throws EOFException {
            long writePosition = this.writePosition.getValue();
            wire.bytes().writePosition(writePosition);
            long position = 0L;
            try {
                position = wire.writeHeader(timeoutMS, TimeUnit.MILLISECONDS);
                WriteMarshallable writer = index2index ? this.index2IndexTemplate : this.indexTemplate;
                writer.writeMarshallable((WireOut)wire);
                wire.updateHeader(position, true);
            }
            catch (StreamCorruptedException | TimeoutException e) {
                throw new AssertionError((Object)e);
            }
            this.writePosition.setMaxValue(wire.bytes().writePosition());
            return position;
        }

        long newIndex(Wire wire, LongArrayValues index2Index, long index2, long timeoutMS) throws EOFException {
            long pos;
            if (index2Index.compareAndSet(index2, 0L, -1L)) {
                long pos2 = this.newIndex(wire, false, timeoutMS);
                if (index2Index.compareAndSet(index2, -1L, pos2)) {
                    index2Index.setMaxUsed(index2 + 1L);
                    return pos2;
                }
                throw new IllegalStateException("Index " + index2 + " in index2index was altered");
            }
            while ((pos = index2Index.getVolatileValueAt(index2)) == -1L) {
                wire.pauser().pause();
            }
            wire.pauser().reset();
            return pos;
        }

        ScanResult moveToIndex(@NotNull Wire wire, long index, long timeoutMS) throws TimeoutException {
            try {
                ScanResult scanResult = this.moveToIndex0(wire, index, timeoutMS);
                if (scanResult != null) {
                    return scanResult;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return this.moveToIndexFromTheStart(wire, index);
        }

        private ScanResult moveToIndexFromTheStart(@NotNull Wire wire, long index) {
            try {
                wire.bytes().readPosition(0L);
                if (wire.readDataHeader()) {
                    return this.linearScan(wire, index, 0L, wire.bytes().readPosition());
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return ScanResult.NOT_FOUND;
        }

        ScanResult moveToIndex0(@NotNull Wire wire, long index, long timeoutMS) throws EOFException, TimeoutException {
            LongArrayValues index2index = this.getIndex2index(wire, timeoutMS);
            Bytes bytes = wire.bytes();
            ((Bytes)bytes.writeLimit(bytes.capacity())).readLimit(bytes.capacity());
            long secondaryAddress = 0L;
            long startIndex = index & (long)(~(this.indexSpacing - 1));
            for (long primaryOffset = this.toAddress0(index); primaryOffset >= 0L && (secondaryAddress = index2index.getValueAt(primaryOffset)) == 0L; --primaryOffset) {
                startIndex -= (long)(this.indexCount * this.indexSpacing);
            }
            if (secondaryAddress <= 0L) {
                return null;
            }
            bytes.readPosition(secondaryAddress);
            wire.readMetaDataHeader();
            LongArrayValues array = this.indexArray.get();
            LongArrayValues array1 = this.array((WireIn)wire, array, false);
            long secondaryOffset = this.toAddress1(index);
            do {
                long fromAddress;
                if ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                    startIndex -= (long)this.indexSpacing;
                    continue;
                }
                if (index == startIndex) {
                    ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(fromAddress);
                    return ScanResult.FOUND;
                }
                return this.linearScan(wire, index, startIndex, fromAddress);
            } while (--secondaryOffset >= 0L);
            return null;
        }

        private ScanResult linearScan(@NotNull Wire wire, long toIndex, long fromKnownIndex, long knownAddress) {
            Bytes bytes = wire.bytes();
            long end = this.writePosition.getValue();
            ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(knownAddress);
            long i = fromKnownIndex;
            while (true) {
                block6: {
                    block5: {
                        try {
                            if (!wire.readDataHeader()) break block5;
                            if (i == toIndex) {
                                return ScanResult.FOUND;
                            }
                            if (bytes.readPosition() > end) {
                                return ScanResult.NOT_REACHED;
                            }
                            bytes.readSkip((long)Wires.lengthOf((long)bytes.readInt()));
                            break block6;
                        }
                        catch (EOFException eOFException) {
                            // empty catch block
                        }
                    }
                    return i == toIndex ? ScanResult.NOT_FOUND : ScanResult.NOT_REACHED;
                }
                ++i;
            }
        }

        private long linearScanByPosition(@NotNull Wire wire, long toPosition, long fromKnownIndex, long knownAddress) throws EOFException {
            Bytes bytes = wire.bytes();
            ((Bytes)bytes.readLimit(this.writePosition.getValue())).readPosition(knownAddress);
            long i = fromKnownIndex;
            while (true) {
                boolean found = wire.readDataHeader();
                if (bytes.readPosition() == toPosition) {
                    return i;
                }
                bytes.readSkip((long)Wires.lengthOf((long)bytes.readInt()));
                if (bytes.readPosition() > toPosition) {
                    return i;
                }
                if (!found) {
                    if (toPosition == Long.MAX_VALUE) {
                        return i - 1L;
                    }
                    throw new EOFException();
                }
                ++i;
            }
        }

        public long lastEntryIndexed(Wire wire, long timeoutMS) {
            try {
                this.indexForPosition(wire, Long.MAX_VALUE, timeoutMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.nextEntryToIndex.getValue() - 1L;
        }

        public LongArrayValues getIndex2index(Wire wire, long timeoutMS) throws EOFException, TimeoutException {
            LongArrayValues values = this.index2indexArray.get();
            if (((Byteable)values).bytesStore() != null) {
                return values;
            }
            long indexToIndex0 = this.indexToIndex(wire, timeoutMS);
            wire.bytes().readLimit(wire.bytes().capacity());
            try (DocumentContext context = wire.readingDocument(indexToIndex0);){
                if (!context.isPresent() || !context.isMetaData()) {
                    SingleChronicleQueueStore.dumpStore(wire);
                    throw new IllegalStateException("document present=" + context.isPresent() + ", metaData=" + context.isMetaData());
                }
                LongArrayValues longArrayValues = this.array((WireIn)wire, values, true);
                return longArrayValues;
            }
        }

        public long indexForPosition(Wire wire, long position, long timeoutMS) throws EOFException, TimeoutException {
            LongArrayValues index2indexArr = this.getIndex2index(wire, timeoutMS);
            LongArrayValues indexArr = this.indexArray.get();
            long lastKnownAddress = 0L;
            long lastKnownIndex = -1L;
            Bytes bytes = wire.bytes();
            for (int index2 = 0; index2 < this.indexCount; ++index2) {
                long secondaryAddress = index2indexArr.getValueAt((long)index2);
                if (secondaryAddress == 0L) {
                    secondaryAddress = this.newIndex(wire, index2indexArr, index2, timeoutMS);
                }
                bytes.readLimit(bytes.capacity());
                try (DocumentContext context = wire.readingDocument(secondaryAddress);){
                    if (!context.isPresent() || !context.isMetaData()) {
                        throw new IllegalStateException("document present=" + context.isPresent() + ", metaData=" + context.isMetaData());
                    }
                    LongArrayValues array1 = this.array((WireIn)wire, indexArr, false);
                    long posN = array1.getValueAt((long)(this.indexCount - 1));
                    if (posN > 0L && posN < position) {
                        lastKnownAddress = posN;
                        lastKnownIndex = ((long)index2 + 1L << this.indexCountBits) - 1L << this.indexSpacingBits;
                        continue;
                    }
                    for (int index1 = 0; index1 < this.indexCount; ++index1) {
                        long nextIndex;
                        ScanResult scanResult;
                        long pos = array1.getValueAt((long)index1);
                        if (pos != 0L) {
                            lastKnownAddress = pos;
                            lastKnownIndex = ((long)index2 << this.indexCountBits + this.indexSpacingBits) + (long)(index1 << this.indexSpacingBits);
                            continue;
                        }
                        if (lastKnownIndex < 0L) {
                            scanResult = this.firstScan(wire);
                            nextIndex = 0L;
                        } else {
                            nextIndex = lastKnownIndex + (long)this.indexSpacing;
                            scanResult = this.linearScan(wire, nextIndex, lastKnownIndex, lastKnownAddress);
                        }
                        if (scanResult == ScanResult.FOUND) {
                            long nextPosition;
                            lastKnownAddress = nextPosition = bytes.readPosition();
                            array1.setOrderedValueAt((long)index1, lastKnownAddress);
                            array1.setMaxUsed((long)(index1 + 1));
                            if (nextPosition == position) {
                                this.nextEntryToIndex.setMaxValue(nextIndex + 1L);
                                long l = nextIndex;
                                return l;
                            }
                            lastKnownIndex = nextIndex;
                            continue;
                        }
                        long ret = this.linearScanByPosition(wire, position, lastKnownIndex, lastKnownAddress);
                        this.nextEntryToIndex.setMaxValue(ret + 1L);
                        long l = ret;
                        return l;
                    }
                    continue;
                }
            }
            throw new AssertionError();
        }

        @NotNull
        private ScanResult firstScan(Wire wire) {
            try {
                wire.bytes().readPosition(0L);
                return wire.readDataHeader() ? ScanResult.FOUND : ScanResult.NOT_REACHED;
            }
            catch (EOFException e) {
                return ScanResult.NOT_FOUND;
            }
        }
    }

    static enum RollFields implements WireKey
    {
        cycle,
        length,
        format,
        epoch;

    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        lastIndex;

    }

    static enum MetaDataField implements WireKey
    {
        wireType,
        writePosition,
        roll,
        indexing;


        @Nullable
        public Object defaultValue() {
            throw new IORuntimeException("field " + (String)this.name() + " required");
        }
    }
}

