/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.IOException;
import java.util.Map;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.koloboke.collect.map.hash.HashLongObjMaps;
import org.jetbrains.annotations.NotNull;

public class WireStorePool {
    private final WireStoreSupplier supplier;
    private final Map<Long, WireStore> stores;

    public WireStorePool(@NotNull WireStoreSupplier supplier) {
        this.supplier = supplier;
        this.stores = HashLongObjMaps.newMutableMap();
    }

    public synchronized WireStore acquire(long cycle) throws IOException {
        WireStore store = this.stores.get(cycle);
        if (store == null) {
            store = (WireStore)this.supplier.apply(cycle);
            this.stores.put(cycle, store);
        } else {
            store.reserve();
        }
        return store;
    }

    public synchronized void release(WireStore store) {
        store.release();
        if (store.refCount() <= 0L) {
            this.stores.remove(store.cycle());
        }
    }

    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier) {
        return new WireStorePool(supplier);
    }
}

