/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.stage.replication.ReplicableEntryDelegating;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.ReplicatedIterationContext;
import net.openhft.chronicle.map.impl.stage.data.ZeroBytesStore;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValueData;
import net.openhft.chronicle.set.SetAbsentEntry;
import net.openhft.chronicle.set.SetContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledReplicatedMapIterationContext<K, V, R>
extends ChainingInterface
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
HashSegmentContext<K, MapEntry<K, V>>,
ReplicatedHashSegmentContext<K, MapEntry<K, V>>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
RemoteOperationContext<K>,
ReplicableEntry,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContext<K, V, R>,
ReplicatedChronicleMapHolder<K, V, R>,
ReplicatedIterationContext<K, V, R>,
MapReplicableEntry<K, V>,
SetContext<K, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final ReadLock innerReadLock;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledReplicatedMapIterationContext.class);
    public final WriteLock innerWriteLock;
    public final SizedReader<K> keyReader;
    public final UpdateLock innerUpdateLock;
    public final SizedReader<V> valueReader;
    public final ChainingInterface rootContextInThisThread;
    final DummyValueZeroData dummyValue;
    final WrappedValueBytesData wrappedValueBytesData;
    final HashEntryChecksumStrategy hashEntryChecksumStrategy;
    public final List<ChainingInterface> contextChain;
    public final EntryKeyBytesData entryKey;
    public final EntryValueBytesData entryValue;
    final WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder;
    final ReplicatedMapEntryDelegating entryDelegating;
    private final ReplicatedChronicleMap<K, V, R> m;
    public final ReusableBitSet freeList;
    public final PointerBytesStore segmentBS;
    final ReplicatedMapAbsentDelegatingForIteration absentEntryDelegating;
    public final ChecksumStrategy checksumStrategy;
    public final Bytes segmentBytes;
    long searchKey = 0L;
    public long searchStartPos;
    public long keySize = -1L;
    public long hashLookupEntry = 0L;
    public int segmentIndex = -1;
    public long segmentHeaderAddress;
    public SegmentHeader segmentHeader = null;
    public int tier = -1;
    public long tierIndex;
    public long tierBaseAddr;
    long entrySpaceOffset = 0L;
    boolean used;
    EntriesToTest entriesToTest = null;
    public boolean entryRemovedOnThisIteration = false;
    public Data<K> inputKey = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean nestedContextsLockedOnSameSegment;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextLockedOnThisSegment = null;
    public long hashLookupPos = -1L;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public long keyOffset = -1L;
    public long valueSizeOffset = -1L;
    public long valueSize = -1L;
    public long valueOffset;
    long replicationBytesOffset = -1L;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;
    long keyHash = 0L;
    public boolean delayedUpdateChecksum = false;
    public int allocatedChunks = 0;
    public byte innerRemoteIdentifier = 0;
    public long innerRemoteTimestamp;
    public byte innerRemoteNodeIdentifier;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean reallocGuarded(long fromPos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.realloc(fromPos, oldChunks, newChunks);
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks();
    }

    public long allocReturnCodeGuarded(int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.allocReturnCode(chunks);
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForWrite();
    }

    @Override
    public void close() {
        this.closeLocks();
        this.closeSegment();
        this.entryValue.closeCachedEntryValue();
        this.closeReplicationUpdate();
        this.closeEntryOffset();
        this.closeKeySearch();
        this.wrappedValueBytesData.closeCachedWrappedValue();
        this.entryKey.closeCachedEntryKey();
        this.closeKeyHash();
        this.wrappedValueInstanceDataHolder.closeWrappedData();
        this.wrappedValueBytesData.closeWrappedValueBytesStore();
        this.closeValueSize();
        this.closeSegmentTier();
        this.wrappedValueBytesData.closeWrappedValueBytes();
        this.closeHashLookupPos();
        this.closeAllocatedChunks();
        this.closeKeyOffset();
        this.wrappedValueInstanceDataHolder.closeNext();
        this.closePos();
        this.wrappedValueBytesData.closeNext();
        this.closeEntrySizeInChunks();
        this.closeInputKey();
        this.closeDelayedUpdateChecksum();
        this.closeEntryRemovedOnThisIteration();
        this.closeSearchKey();
        this.closeEntriesToTest();
        this.closeSegmentHeader();
        this.closeReplicationState();
        this.closeUsed();
        this.closeSegmentIndex();
        this.closeHashLookupEntry();
        this.closeKeySize();
        this.wrappedValueInstanceDataHolder.closeValue();
        this.closeValueSizeOffset();
        this.closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants();
        this.closeHashLookupSearchHlDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants();
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.wrappedValueBytesData.closeWrappedValueBytesDataInnerGetUsingDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.closeHashLookupSearchNextPosDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeHashLookupSearchFoundDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachLockOperationDependants();
        this.closeReplicatedChronicleMapHolderImplMDependants();
        this.closeHashLookupSearchAddrDependants();
        this.closeReplicatedMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
    }

    public void freeExtraGuarded(long pos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.freeExtra(pos, oldChunks, newChunks);
    }

    public void freeGuarded(long fromPos, int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.free(fromPos, chunks);
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    private long _MapEntryStages_countValueSizeOffset() {
        return this.keyEnd();
    }

    private long _MapEntryStages_sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)((ReplicatedChronicleMap)this.m()).keySizeMarshaller.storingLength(keySize) + keySize + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.storingLength(valueSize);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledReplicatedMapIterationContext(ChainingInterface c, ReplicatedChronicleMap<K, V, R> m) {
        this.contextChain = c.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = c;
        this.m = m;
        this.dummyValue = new DummyValueZeroData();
        this.owner = Thread.currentThread();
        this.entryDelegating = new ReplicatedMapEntryDelegating();
        this.entryKey = new EntryKeyBytesData();
        this.valueReader = StatefulCopyable.copyIfNeeded(((ReplicatedChronicleMap)this.m()).valueReader);
        this.entryValue = new EntryValueBytesData();
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.absentEntryDelegating = new ReplicatedMapAbsentDelegatingForIteration();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    public CompiledReplicatedMapIterationContext(ReplicatedChronicleMap<K, V, R> m) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.m = m;
        this.dummyValue = new DummyValueZeroData();
        this.owner = Thread.currentThread();
        this.entryDelegating = new ReplicatedMapEntryDelegating();
        this.entryKey = new EntryKeyBytesData();
        this.valueReader = StatefulCopyable.copyIfNeeded(((ReplicatedChronicleMap)this.m()).valueReader);
        this.entryValue = new EntryValueBytesData();
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.absentEntryDelegating = new ReplicatedMapAbsentDelegatingForIteration();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        assert (this.totalReadLockCount + change >= 0) : "read underflow";
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        assert (this.totalUpdateLockCount + change >= 0) : "update underflow";
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        assert (this.totalWriteLockCount + change >= 0) : "write underflow";
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    private long _MapSegmentIteration_tierEntriesForIteration() {
        return this.tierEntries();
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long lowestPossiblyFreeChunk = this.lowestPossiblyFreeChunk();
        if (lowestPossiblyFreeChunk + (long)chunks > h.actualChunksPerSegmentTier) {
            return -1L;
        }
        if (this.tierEntries() >= h.maxEntriesPerHashLookup) {
            return -1L;
        }
        assert (lowestPossiblyFreeChunk < h.actualChunksPerSegmentTier);
        long ret = this.freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegmentTier) {
            if (ret + (long)chunks > h.actualChunksPerSegmentTier) {
                assert (ret != -1L);
                this.freeList.clearRange(ret, ret + (long)chunks);
            }
            return -1L;
        }
        this.tierEntries(this.tierEntries() + 1L);
        if (chunks == 1 || this.freeList.isSet(lowestPossiblyFreeChunk)) {
            this.lowestPossiblyFreeChunk(ret + (long)chunks);
        }
        return ret;
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkOnEachLockOperation();
    }

    private void _MapSegmentIteration_doRemove() {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    private void _MapSegmentIteration_doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    private void _SegmentStages_checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && java.util.Objects.equals(key = ((CompiledReplicatedMapIterationContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    private void _SegmentStages_nextTier() {
        VanillaChronicleHash h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex(), this.tier() + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex();
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
        }
    }

    private void _TierRecovery_removeDuplicatesInSegment() {
        long startHlPos = 0L;
        VanillaChronicleMap m = this.m();
        CompactOffHeapLinearHashTable hashLookup = m.hashLookup;
        long currentTierBaseAddr = this.tierBaseAddr();
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startHlPos))) {
            startHlPos = hashLookup.step(startHlPos);
        }
        long hlPos = startHlPos;
        int steps = 0;
        long entries = 0L;
        do {
            hlPos = hashLookup.step(hlPos);
            ++steps;
            long entry = hashLookup.readEntry(currentTierBaseAddr, hlPos);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            Data<K> key = this.key();
            try (ExternalHashQueryContext c = m.queryContext((Data)key);){
                HashEntry entry2 = c.entry();
                Data key2 = ((MapEntry)((Object)c)).key();
                if (key2.bytes().address(key2.offset()) != key.bytes().address(key.offset())) {
                    LOG.error("entries with duplicate key {} in segment {}: with values {} and {}, removing the latter", new Object[]{key, c.segmentIndex(), entry2 != null ? ((MapEntry)((Object)c)).value() : "<deleted>", !this.entryDeleted() ? this.value() : "<deleted>"});
                    if (hashLookup.remove(currentTierBaseAddr, hlPos) == hlPos) continue;
                    hlPos = hashLookup.stepBack(hlPos);
                    --steps;
                    continue;
                }
            }
            ++entries;
        } while (hlPos != startHlPos || steps == 0);
        this.recoverTierEntriesCounter(entries);
        this.recoverLowestPossibleFreeChunkTiered();
    }

    public void free(long fromPos, int chunks) {
        this.tierEntries(this.tierEntries() - 1L);
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(fromPos);
        }
    }

    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + (long)newChunks;
        this.freeList.clearRange(from, pos + (long)oldChunks);
        if (from < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(from);
        }
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                if (this.decrementRead() == 0 && this.updateZero() && this.writeZero()) {
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                }
                return;
            }
            case UPDATE_LOCKED: {
                if (this.decrementUpdate() == 0 && this.writeZero()) {
                    if (this.readZero()) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                    } else {
                        this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    }
                }
                return;
            }
            case WRITE_LOCKED: {
                if (this.decrementWrite() != 0) break;
                if (!this.updateZero()) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (!this.readZero()) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBytes.capacity());
        return this.segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L);
        return this.segmentBytes;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface nextNode;
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while ((nextNode = prevContext.nextNode()) != this && nextNode != null) {
            prevContext = nextNode;
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    private Object _MapSegmentIteration_entryForIteration() {
        return this;
    }

    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    private boolean _MapEntryStages_entryDeleted() {
        return false;
    }

    private boolean _MapSegmentIteration_forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    private boolean _MapSegmentIteration_shouldTestEntry() {
        return true;
    }

    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (fromPos + (long)newChunks < this.h().actualChunksPerSegmentTier && this.freeList.isRangeClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
            this.freeList.setRange(fromPos + (long)oldChunks, fromPos + (long)newChunks);
            return true;
        }
        return false;
    }

    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    private void _MapEntryStages_relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset(), this.pos(), this.entrySizeInChunks());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), hl.key(oldEntry), this.pos());
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return LOG;
    }

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public DummyValueZeroData dummyValue() {
        return this.dummyValue;
    }

    public WrappedValueBytesData wrappedValueBytesData() {
        return this.wrappedValueBytesData;
    }

    public HashEntryChecksumStrategy hashEntryChecksumStrategy() {
        return this.hashEntryChecksumStrategy;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder() {
        return this.wrappedValueInstanceDataHolder;
    }

    public ReplicatedMapEntryDelegating entryDelegating() {
        return this.entryDelegating;
    }

    public ReplicatedMapAbsentDelegatingForIteration absentEntryDelegating() {
        return this.absentEntryDelegating;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachLockOperationDependants();
    }

    public void checkOnEachLockOperation() {
        this.checkAccessingFromOwnerThread();
        if (!this.h().isOpen()) {
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        }
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachLockOperationDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    public void closeReplicatedMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        }
        this.initDelayedUpdateChecksum(true);
    }

    @Override
    public Data<V> wrapValueBytesAsData(BytesStore bytesStore, long offset, long size) {
        Objects.requireNonNull(bytesStore);
        this.checkOnEachPublicOperation();
        WrappedValueBytesData wrapped = this.wrappedValueBytesData;
        wrapped = wrapped.getUnusedWrappedValueBytesDataGuarded();
        wrapped.initWrappedValueBytesStore(bytesStore, offset, size);
        return wrapped;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        }
        return this.delayedUpdateChecksumInit() || this.checksumStrategy.innerCheckSum();
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceDataHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.dummyValue;
    }

    @Override
    public ReplicatedChronicleMap<K, V, R> m() {
        return this.m;
    }

    public void closeReplicatedChronicleMapHolderImplMDependants() {
        this.closeValueSize();
        this.wrappedValueInstanceDataHolder.closeValue();
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        long sizeWithoutChecksum = ((ReplicatedChronicleMap)this.m()).constantlySizedEntry ? VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue + valueSize, ((ReplicatedChronicleMap)this.m()).alignment) : (((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation ? sizeOfEverythingBeforeValue + (long)((ReplicatedChronicleMap)this.m()).worstAlignment + valueSize : VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, ((ReplicatedChronicleMap)this.m()).alignment) + valueSize);
        return sizeWithoutChecksum + this.checksumStrategy.extraEntryBytes();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.replaceValue(entry, newValue);
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return this._MapEntryStages_sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.remove(entry);
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    public byte currentNodeIdentifier() {
        return ((ReplicatedChronicleMap)this.m()).identifier();
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.insert(absentEntry, value);
    }

    @Override
    public ChronicleSet<K> set() {
        return this.m.chronicleSet;
    }

    @Override
    public ChronicleHash<K, ?, ?, ?> hash() {
        return this.set() != null ? this.set() : this.map();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }

    @Override
    @NotNull
    public CompiledReplicatedMapIterationContext<K, V, R> context() {
        return this;
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException("Update or Write locking is forbidden in the contextof locked iteration context");
        }
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    public void closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    public void initSearchKey(long searchKey) {
        boolean wasSearchKeyInit = this.searchKeyInit();
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        if (wasSearchKeyInit) {
            this.closeSearchKeyDependants();
        }
    }

    public long searchKey() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchKey;
    }

    public long searchStartPos() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    public void closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        boolean wasKeySizeInit = this.keySizeInit();
        this.keySize = keySize;
        if (wasKeySizeInit) {
            this.closeKeySizeDependants();
        }
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public boolean hashLookupEntryInit() {
        return this.hashLookupEntry != 0L;
    }

    public void initHashLookupEntry(long entry) {
        this.hashLookupEntry = entry;
    }

    public long hashLookupEntry() {
        assert (this.hashLookupEntryInit()) : "HashLookupEntry should be init";
        return this.hashLookupEntry;
    }

    void closeHashLookupEntry() {
        if (!this.hashLookupEntryInit()) {
            return;
        }
        this.hashLookupEntry = 0L;
    }

    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        boolean wasSegmentIndexInit = this.segmentIndexInit();
        this.segmentIndex = segmentIndex;
        if (wasSegmentIndexInit) {
            this.closeSegmentIndexDependants();
        }
    }

    @Override
    public int segmentIndex() {
        assert (this.segmentIndexInit()) : "SegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        boolean wasSegmentHeaderInit = this.segmentHeaderInit();
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        if (wasSegmentHeaderInit) {
            this.closeSegmentHeaderDependants();
        }
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public boolean segmentTierInit() {
        return this.tier >= 0;
    }

    public void initSegmentTier() {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tierIndex = this.segmentIndex() + 1;
        this.tierBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.tier = 0;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier_WithBaseAddr(int tier, long tierBaseAddr, long tierIndex) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public int tier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeKeyHash();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeHashLookupPos();
        this.closeHashLookupSearchAddrDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeSegment();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    private void shiftHashLookupEntries() {
        VanillaChronicleHash h = this.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.tierBaseAddr();
        long hlPos = 0L;
        long steps = 0L;
        block0: do {
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            long searchKey = hl.key(hlEntry);
            long hlHolePos = hl.hlPos(searchKey);
            while (hlHolePos != hlPos) {
                long hlHoleEntry = hl.readEntry(hlAddr, hlHolePos);
                if (hl.empty(hlHoleEntry)) {
                    hl.writeEntry(hlAddr, hlHolePos, hlEntry);
                    if (hl.remove(hlAddr, hlPos) == hlPos) continue block0;
                    hlPos = hl.stepBack(hlPos);
                    --steps;
                    continue block0;
                }
                hlHolePos = hl.step(hlHolePos);
            }
        } while ((hlPos = hl.step(hlPos)) != 0L || ++steps == 0L);
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr() + this.h().tierHashLookupOuterSize;
    }

    public void closeIterationSegmentStagesTierCountersAreaAddrDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTier() {
        if (this.tier() == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier() - 1, this.prevTierIndex());
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void goToFirstTier() {
        while (this.tier() != 0) {
            this.prevTier();
        }
    }

    public void tierEntries(long tierEntries) {
        if (this.tier() == 0) {
            this.segmentHeader().entries(this.segmentHeaderAddress(), tierEntries);
        } else {
            TierCountersArea.entries(this.tierCountersAreaAddr(), tierEntries);
        }
    }

    public long tierEntries() {
        if (this.tier() == 0) {
            return this.segmentHeader().entries(this.segmentHeaderAddress());
        }
        return TierCountersArea.entries(this.tierCountersAreaAddr());
    }

    public void closeIterationSegmentStagesTierEntriesDependants() {
        this.closeSegment();
    }

    private void recoverTierEntriesCounter(long entries) {
        if (this.tierEntries() != entries) {
            LOG.error("Wrong number of entries counter for tier with index {}, stored: {}, should be: {}", new Object[]{this.tierIndex(), this.tierEntries(), entries});
            this.tierEntries(entries);
        }
    }

    public void tierDeleted(long tierDeleted) {
        if (this.tier() == 0) {
            this.segmentHeader().deleted(this.segmentHeaderAddress(), tierDeleted);
        } else {
            TierCountersArea.deleted(this.tierCountersAreaAddr(), tierDeleted);
        }
    }

    public long tierDeleted() {
        if (this.tier() == 0) {
            return this.segmentHeader().deleted(this.segmentHeaderAddress());
        }
        return TierCountersArea.deleted(this.tierCountersAreaAddr());
    }

    public void moveChange(long oldTierIndex, long oldPos, long newPos) {
        ((ReplicatedChronicleMap)this.m()).moveChange(oldTierIndex, oldPos, this.tierIndex(), newPos);
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeHashLookupSearchAddrDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if (this.tier() == 0) {
            this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress(), lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    public void closeIterationSegmentStagesLowestPossiblyFreeChunkDependants() {
        this.closeSegment();
    }

    public long lowestPossiblyFreeChunk() {
        if (this.tier() == 0) {
            return this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress());
        }
        return TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr());
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        boolean wasSegmentInit = this.segmentInit();
        VanillaChronicleHash h = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.tierFreeListOuterSize + (long)h.tierEntrySpaceInnerOffset;
        if (wasSegmentInit) {
            this.closeSegmentDependants();
        }
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    public Bytes segmentBytes() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytes;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.closeEntryOffset();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    private void recoverLowestPossibleFreeChunkTiered() {
        long lowestFreeChunk = this.freeList().nextClearBit(0L);
        if (lowestFreeChunk == -1L) {
            lowestFreeChunk = ((ReplicatedChronicleMap)this.m()).actualChunksPerSegmentTier;
        }
        if (this.lowestPossiblyFreeChunk() != lowestFreeChunk) {
            LOG.error("wrong lowest free chunk for tier with index {}, stored: {}, should be: {}", new Object[]{this.tierIndex(), this.lowestPossiblyFreeChunk(), lowestFreeChunk});
            this.lowestPossiblyFreeChunk(lowestFreeChunk);
        }
    }

    private void zeroOutFirstSegmentTierCountersArea() {
        long tierCountersAreaAddr;
        this.nextTierIndex(0L);
        if (this.prevTierIndex() != 0L) {
            LOG.error("stored prev tier index in first tier of segment {}: {}, should be 0", (Object)this.segmentIndex(), (Object)this.prevTierIndex());
            this.prevTierIndex(0L);
        }
        if (TierCountersArea.segmentIndex(tierCountersAreaAddr = this.tierCountersAreaAddr()) != 0) {
            LOG.error("stored segment index in first tier of segment {}: {}, should be 0", (Object)this.segmentIndex(), (Object)TierCountersArea.segmentIndex(tierCountersAreaAddr));
            TierCountersArea.segmentIndex(tierCountersAreaAddr, 0);
        }
        if (TierCountersArea.tier(tierCountersAreaAddr) != 0) {
            LOG.error("stored tier in first tier of segment {}: {}, should be 0", (Object)this.segmentIndex(), (Object)TierCountersArea.tier(tierCountersAreaAddr));
            TierCountersArea.tier(tierCountersAreaAddr, 0);
        }
    }

    public void nextTier() {
        this._SegmentStages_nextTier();
        if (this.hashLookupEntryInit()) {
            this.initSearchKey(this.h().hashLookup.key(this.hashLookupEntry()));
        }
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    @Override
    public long size() {
        this.goToFirstTier();
        long size = this.tierEntries() - this.tierDeleted();
        while (this.hasNextTier()) {
            this.nextTier();
            size += this.tierEntries() - this.tierDeleted();
        }
        return size;
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCodeGuarded(chunks);
        if (prevPos >= 0L) {
            this.freeGuarded(prevPos, prevChunks);
        }
        if (ret >= 0L) {
            return ret;
        }
        do {
            this.nextTier();
        } while ((ret = this.allocReturnCodeGuarded(chunks)) < 0L);
        return ret;
    }

    public void verifyTierCountersAreaData() {
        block2: {
            long currentTierIndex;
            this.goToFirstTier();
            do {
                int tierSegmentIndex;
                if ((tierSegmentIndex = TierCountersArea.segmentIndex(this.tierCountersAreaAddr())) != this.segmentIndex()) {
                    throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports it belongs to segmentIndex " + tierSegmentIndex));
                }
                if (!this.hasNextTier()) break block2;
                currentTierIndex = this.tierIndex();
                this.nextTier();
            } while (this.prevTierIndex() == currentTierIndex);
            throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports the previous tierIndex is " + this.prevTierIndex() + " while actually it is " + currentTierIndex));
        }
    }

    private void resetSegmentLock() {
        long lockState = this.segmentHeader().getLockState(this.segmentHeaderAddress());
        if (lockState != this.segmentHeader().resetLockState()) {
            LOG.error("lock of segment {} is not clear: {}", (Object)this.segmentIndex(), (Object)this.segmentHeader().lockStateToString(lockState));
            this.segmentHeader().resetLock(this.segmentHeaderAddress());
        }
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    public boolean entriesToTestInit() {
        return this.entriesToTest != null;
    }

    void initEntriesToTest(EntriesToTest entriesToTest) {
        this.entriesToTest = entriesToTest;
    }

    public EntriesToTest entriesToTest() {
        assert (this.entriesToTestInit()) : "EntriesToTest should be init";
        return this.entriesToTest;
    }

    public void closeEntriesToTest() {
        if (!this.entriesToTestInit()) {
            return;
        }
        this.entriesToTest = null;
    }

    public long tierEntriesForIteration() {
        return this.entriesToTest() == EntriesToTest.ALL ? this.tierEntries() : this.tierEntries() - this.tierDeleted();
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!this.entryRemovedOnThisIterationInit()) {
            return;
        }
        this.entryRemovedOnThisIteration = false;
    }

    public boolean inputKeyInit() {
        return this.inputKey != null;
    }

    public void initInputKey(Data<K> inputKey) {
        boolean wasInputKeyInit = this.inputKeyInit();
        this.inputKey = inputKey;
        if (wasInputKeyInit) {
            this.closeInputKeyDependants();
        }
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
    }

    public void closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextLockedOnThisSegment != null;
    }

    void initLocks() {
        int i;
        boolean wasLocksInit = this.locksInit();
        if (this.segmentHeader() == null) {
            throw new AssertionError();
        }
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        if (wasLocksInit) {
            this.closeLocksDependants();
        }
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nestedContextsLockedOnSameSegment;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextLockedOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeDelayedUpdateChecksum();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        if (this.tier() < 0) {
            throw new AssertionError();
        }
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public void initHashLookupPos(long hashLookupPos) {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        this.hashLookupPos = hashLookupPos;
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos()) break block2;
            } while (this.hl().key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("HashLookup overflow should never occur");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.tierBaseAddr(), this.hashLookupPos(), newValue);
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment().totalWriteLockCount();
        return s;
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        boolean wasPosInit = this.posInit();
        this.pos = pos;
        if (wasPosInit) {
            this.closePosDependants();
        }
    }

    @Override
    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public void dropChange() {
        ((ReplicatedChronicleMap)this.m()).dropChange(this.tierIndex(), this.pos());
    }

    @Override
    public void dropChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.dropChange();
    }

    public boolean changed() {
        return ((ReplicatedChronicleMap)this.m()).isChanged(this.tierIndex(), this.pos());
    }

    @Override
    public boolean isChanged() {
        this.checkOnEachPublicOperation();
        this.innerReadLock.lock();
        return this.changed();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        boolean wasEntryOffsetInit = this.entryOffsetInit();
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        if (wasEntryOffsetInit) {
            this.closeEntryOffsetDependants();
        }
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.closeDelayedUpdateChecksum();
    }

    @Override
    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void closeReplicatedMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    public void raiseChangeFor(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.m()).raiseChangeFor(this.tierIndex(), this.pos(), remoteIdentifier);
    }

    @Override
    public void raiseChangedFor(byte remoteIdentifier) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChangeFor(remoteIdentifier);
    }

    public void raiseChange() {
        ((ReplicatedChronicleMap)this.m()).raiseChange(this.tierIndex(), this.pos());
    }

    public void updateChange() {
        if (!this.replicationUpdateInit()) {
            this.raiseChange();
        }
    }

    @Override
    public void raiseChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChange();
    }

    public void dropChangeFor(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.m()).dropChangeFor(this.tierIndex(), this.pos(), remoteIdentifier);
    }

    @Override
    public void dropChangedFor(byte remoteIdentifier) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.dropChangeFor(remoteIdentifier);
    }

    public void raiseChangeForAllExcept(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.m()).raiseChangeForAllExcept(this.tierIndex(), this.pos(), remoteIdentifier);
    }

    @Override
    public void raiseChangedForAllExcept(byte remoteIdentifier) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChangeForAllExcept(remoteIdentifier);
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        boolean wasKeyOffsetInit = this.keyOffsetInit();
        this.keyOffset = keyOffset;
        if (wasKeyOffsetInit) {
            this.closeKeyOffsetDependants();
        }
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeReplicatedMapEntryStagesKeyEndDependants() {
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeReplicationState();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long countValueSizeOffset() {
        return this._MapEntryStages_countValueSizeOffset() + 10L;
    }

    public void closeReplicatedMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        boolean wasValueSizeOffsetInit = this.valueSizeOffsetInit();
        this.valueSizeOffset = this.countValueSizeOffset();
        if (wasValueSizeOffsetInit) {
            this.closeValueSizeOffsetDependants();
        }
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        boolean wasValueSizeInit = this.valueSizeInit();
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(segmentBytes);
        this.valueOffset = segmentBytes.readPosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    void initValueSize(long valueSize) {
        boolean wasValueSizeInit = this.valueSizeInit();
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.valueSizeOffset());
        ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, ((ReplicatedChronicleMap)this.m()).alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        boolean wasValueSizeInit = this.valueSizeInit();
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public void writeValue(Data<?> value) {
        this.initDelayedUpdateChecksum(true);
        RandomDataInput valueBytes = value.bytes();
        if (valueBytes instanceof NativeBytesStore && valueBytes.address(value.offset()) == this.segmentBS().address(this.valueOffset())) {
            return;
        }
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset();
    }

    public boolean replicationStateInit() {
        return this.replicationBytesOffset != -1L;
    }

    void initReplicationState() {
        this.replicationBytesOffset = this.keyEnd();
    }

    public long replicationBytesOffset() {
        if (!this.replicationStateInit()) {
            this.initReplicationState();
        }
        return this.replicationBytesOffset;
    }

    public void closeReplicationState() {
        if (!this.replicationStateInit()) {
            return;
        }
        this.replicationBytesOffset = -1L;
    }

    void updateReplicationState(byte identifier, long timestamp) {
        this.initDelayedUpdateChecksum(true);
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.replicationBytesOffset());
        segmentBytes.writeLong(timestamp);
        segmentBytes.writeByte(identifier);
    }

    public void updatedReplicationStateOnAbsentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            this.updateReplicationState(((ReplicatedChronicleMap)this.m()).identifier(), TimeProvider.currentTime());
        }
    }

    @Override
    public void updateOrigin(byte newIdentifier, long newTimestamp) {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        this.updateReplicationState(newIdentifier, newTimestamp);
    }

    private long entryDeletedOffset() {
        return this.replicationBytesOffset() + 9L;
    }

    public void writeEntryDeleted() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), true);
    }

    public void writeEntryPresent() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), false);
    }

    public boolean entryDeleted() {
        return this.segmentBS().readBoolean(this.entryDeletedOffset());
    }

    private void recoverTierDeleted() {
        VanillaChronicleHash h = this.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.tierBaseAddr();
        long deleted = 0L;
        long hlPos = 0L;
        do {
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            this.readExistingEntry(hl.value(hlEntry));
            if (!this.entryDeleted()) continue;
            ++deleted;
        } while ((hlPos = hl.step(hlPos)) != 0L);
        if (this.tierDeleted() != deleted) {
            LOG.error("wrong deleted counter for tier with index {}, stored: {}, should be: {}", new Object[]{this.tierIndex(), this.tierDeleted(), deleted});
            this.tierDeleted(deleted);
        }
    }

    public Object entryForIteration() {
        return !this.entryDeleted() ? this.entryDelegating : this.absentEntryDelegating;
    }

    public boolean shouldTestEntry() {
        return this.entriesToTest() == EntriesToTest.ALL || !this.entryDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean forEachTierEntryWhile(Predicate<? super T> predicate, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        long leftEntries = this.tierEntriesForIteration();
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.initHashLookupPos(startPos);
        int steps = 0;
        do {
            currentHashLookupPos = hashLookup.step(this.hashLookupPos());
            ++steps;
            this.setHashLookupPosGuarded(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            if (!this.shouldTestEntry()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!predicate.test(this.entryForIteration())) {
                    interrupted = true;
                    break;
                }
                if (--leftEntries != 0L) continue;
                break;
            }
            finally {
                if (this.tier() != currentTier) {
                    this.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    --steps;
                    this.initHashLookupPos(currentHashLookupPos);
                }
                this.innerWriteLock.unlock();
                this.closeKeyOffset();
            }
        } while (currentHashLookupPos != startPos || steps == 0);
        if (!interrupted && leftEntries > 0L) {
            throw new IllegalStateException("We a tier without interruption, but according to tier counters there should be " + leftEntries + " more entries. Size diverged?");
        }
        return interrupted;
    }

    public <T> boolean innerForEachSegmentEntryWhile(Predicate<? super T> predicate) {
        try {
            this.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                boolean interrupted;
                if (interrupted = this.forEachTierEntryWhile(predicate, currentTier = this.tier(), currentTierBaseAddr = this.tierBaseAddr(), currentTierIndex = this.tierIndex())) {
                    boolean bl = false;
                    return bl;
                }
                if (currentTier == 0) {
                    boolean bl = true;
                    return bl;
                }
                this.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.PRESENT);
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super MapEntry<K, V>> action) {
        this.forEachSegmentEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)e -> {
            action.accept((Object)e);
            return true;
        }));
    }

    @Override
    public boolean forEachSegmentReplicableEntryWhile(Predicate<? super ReplicableEntry> predicate) {
        this.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.ALL);
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentReplicableEntry(Consumer<? super ReplicableEntry> action) {
        this.forEachSegmentReplicableEntryWhile(e -> {
            action.accept((ReplicableEntry)e);
            return true;
        });
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.entryDeleted();
        this._MapSegmentIteration_doRemove();
        this.dropChange();
        if (wasDeleted) {
            this.tierDeleted(this.tierDeleted() - 1L);
        }
    }

    public long timestamp() {
        return this.segmentBS().readLong(this.replicationBytesOffset());
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation();
        return this.timestamp();
    }

    public void updatedReplicationStateOnPresentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            long timestamp = Math.max(this.timestamp() + 1L, TimeProvider.currentTime());
            this.updateReplicationState(((ReplicatedChronicleMap)this.m()).identifier(), timestamp);
        }
    }

    private long timestampOffset() {
        return this.replicationBytesOffset();
    }

    private long identifierOffset() {
        return this.replicationBytesOffset() + 8L;
    }

    byte identifier() {
        return this.segmentBS().readByte(this.identifierOffset());
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation();
        return this.identifier();
    }

    public long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeReplicatedMapEntryStagesEntryEndDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeReplicatedMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.freeGuarded(this.pos(), this.entrySizeInChunks());
        this.incrementModCountGuarded();
    }

    public void iterationRemove() {
        if (this.h().hashLookup.remove(this.tierBaseAddr(), this.hashLookupPos()) != this.hashLookupPos()) {
            this.setHashLookupPosGuarded(this.h().hashLookup.stepBack(this.hashLookupPos()));
        }
        this.innerRemoveEntryExceptHashLookupUpdate();
    }

    private void cleanupModificationIterationBits() {
        VanillaChronicleMap m = this.m();
        ReplicatedChronicleMap.ModificationIterator[] its = ((ReplicatedChronicleMap)m).acquireAllModificationIterators();
        ReusableBitSet freeList = this.freeList();
        long pos = 0L;
        while (pos < ((ReplicatedChronicleMap)m).actualChunksPerSegmentTier) {
            long nextPos = freeList.nextSetBit(pos);
            if (nextPos > pos) {
                for (ReplicatedChronicleMap.ModificationIterator it : its) {
                    it.clearRange0(this.tierIndex(), pos, nextPos);
                }
            }
            if (nextPos > 0L) {
                this.readExistingEntry(nextPos);
                if (this.entrySizeInChunks() > 1) {
                    for (ReplicatedChronicleMap.ModificationIterator it : its) {
                        it.clearRange0(this.tierIndex(), nextPos + 1L, nextPos + (long)this.entrySizeInChunks());
                    }
                }
                pos = nextPos + (long)this.entrySizeInChunks();
                continue;
            }
            for (ReplicatedChronicleMap.ModificationIterator it : its) {
                it.clearRange0(this.tierIndex(), pos, ((ReplicatedChronicleMap)m).actualChunksPerSegmentTier);
            }
        }
    }

    public void removeDuplicatesInSegment() {
        this._TierRecovery_removeDuplicatesInSegment();
        this.recoverTierDeleted();
        this.cleanupModificationIterationBits();
    }

    private void removeDuplicatesInSegments() {
        VanillaChronicleHash h = this.h();
        block0: for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.initSegmentIndex(segmentIndex);
            this.initSegmentTier();
            this.goToLastTier();
            while (true) {
                this.removeDuplicatesInSegment();
                if (this.tier() <= 0) continue block0;
                this.prevTier();
            }
        }
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize());
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.searchState = null;
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.nestedContextsLockedOnSameSegment() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    public void putNewVolatile(long entryPos) {
        boolean keySearchReInit;
        boolean bl = keySearchReInit = !this.keySearchInit();
        if (this.searchStatePresent()) {
            throw new AssertionError();
        }
        if (keySearchReInit) {
            this.readExistingEntry(entryPos);
        }
        this.hl().checkValueForPut(entryPos);
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), this.searchKey(), entryPos);
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        boolean wasKeyHashInit = this.keyHashInit();
        long addr = this.tierBaseAddr() + this.keyOffset();
        long len = this.keySize();
        this.keyHash = LongHashFunction.xx_r39().hashMemory(addr, len);
        if (wasKeyHashInit) {
            this.closeKeyHashDependants();
        }
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.closeKeyHashDependants();
        this.keyHash = 0L;
    }

    public void closeKeyHashDependants() {
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public void closeIterationKeyHashCodeKeyHashCodeDependants() {
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    private int checkEntry(long searchKey, long entryPos, int segmentIndex) {
        Logger log = LOG;
        VanillaChronicleHash h = this.h();
        if (entryPos < 0L || entryPos >= h.actualChunksPerSegmentTier) {
            log.error("Entry pos is out of range: {}, should be 0-{}", (Object)entryPos, (Object)(h.actualChunksPerSegmentTier - 1L));
            return -1;
        }
        try {
            this.readExistingEntry(entryPos);
        }
        catch (Exception e) {
            log.error("Exception while reading entry key size: {}", (Throwable)e);
            return -1;
        }
        if (this.keyEnd() > this.segmentBytes().capacity()) {
            log.error("Wrong key size: {}", (Object)this.keySize());
            return -1;
        }
        long keyHashCode = this.keyHashCode();
        int segmentIndexFromKey = h.hashSplitting.segmentIndex(keyHashCode);
        if (segmentIndexFromKey < 0 || segmentIndexFromKey >= h.actualSegments) {
            log.error("Segment index from the entry key hash code is out of range: {}, should be 0-{}, entry key: {}", new Object[]{segmentIndexFromKey, h.actualSegments - 1, this.key()});
            return -1;
        }
        long segmentHashFromKey = h.hashSplitting.segmentHash(keyHashCode);
        long searchKeyFromKey = h.hashLookup.maskUnsetKey(segmentHashFromKey);
        if (searchKey != searchKeyFromKey) {
            log.error("HashLookup searchKey: {}, HashLookup searchKey from the entry key hash code: {}, entry key: {}", new Object[]{searchKey, searchKeyFromKey, this.key()});
            return -1;
        }
        try {
            long entryAndChecksumEnd = this.entryEnd() + this.checksumStrategy.extraEntryBytes();
            if (entryAndChecksumEnd > this.segmentBytes().capacity()) {
                log.error("Wrong value size: {}, key: {}", (Object)this.valueSize(), this.key());
                return -1;
            }
        }
        catch (Exception ex) {
            log.error("Exception while reading entry value size: {}, key: {}", (Object)ex, this.key());
            return -1;
        }
        int storedChecksum = this.checksumStrategy.storedChecksum();
        int checksumFromEntry = this.checksumStrategy.computeChecksum();
        if (storedChecksum != checksumFromEntry) {
            log.error("Checksum doesn't match, stored: {}, should be from the entry bytes: {}, key: {}, value: {}", new Object[]{storedChecksum, checksumFromEntry, this.key(), this.value()});
            return -1;
        }
        if (!this.freeList().isRangeClear(entryPos, entryPos + (long)this.entrySizeInChunks())) {
            log.error("Overlapping entry: positions {}-{}, key: {}, value: {}", new Object[]{entryPos, entryPos + (long)this.entrySizeInChunks() - 1L, this.key(), this.value()});
            return -1;
        }
        if (segmentIndex < 0) {
            return segmentIndexFromKey;
        }
        if (segmentIndex != segmentIndexFromKey) {
            log.error("Expected segment index: {}, segment index from the entry key: {}, key: {}, value: {}", new Object[]{segmentIndex, searchKeyFromKey, this.key(), this.value()});
            return -1;
        }
        return segmentIndex;
    }

    public int recoverTier(int segmentIndex) {
        this.freeList().clearAll();
        Logger log = LOG;
        VanillaChronicleHash h = this.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.tierBaseAddr();
        long validEntries = 0L;
        long hlPos = 0L;
        block0: do {
            long startInsertPos;
            long entryPos;
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            hl.clearEntry(hlAddr, hlPos);
            if (validEntries >= h.maxEntriesPerHashLookup) {
                log.error("Too many entries in tier with index {}, max is {}", (Object)this.tierIndex(), (Object)h.maxEntriesPerHashLookup);
                continue;
            }
            long searchKey = hl.key(hlEntry);
            int si = this.checkEntry(searchKey, entryPos = hl.value(hlEntry), segmentIndex);
            if (si < 0) continue;
            this.freeList().setRange(entryPos, entryPos + (long)this.entrySizeInChunks());
            segmentIndex = si;
            long insertPos = startInsertPos = hl.hlPos(searchKey);
            do {
                long hlInsertEntry;
                if (hl.empty(hlInsertEntry = hl.readEntry(hlAddr, insertPos))) {
                    hl.writeEntry(hlAddr, insertPos, hl.entry(searchKey, entryPos));
                    ++validEntries;
                    continue block0;
                }
                if (insertPos == hlPos) {
                    throw new ChronicleHashRecoveryFailedException("Concurrent modification of ChronicleMap at " + h.file() + " while recovery procedure is in progress");
                }
                if (hl.key(hlInsertEntry) != searchKey) continue;
                long anotherEntryPos = hl.value(hlInsertEntry);
                if (anotherEntryPos == entryPos) {
                    ++validEntries;
                    continue block0;
                }
                long currentKeyOffset = this.keyOffset();
                long currentKeySize = this.keySize();
                int currentEntrySizeInChunks = this.entrySizeInChunks();
                if (insertPos >= 0L && insertPos < hlPos) {
                    this.readExistingEntry(anotherEntryPos);
                } else if (this.checkEntry(searchKey, anotherEntryPos, segmentIndex) < 0) continue;
                if (this.keySize() != currentKeySize || !BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)currentKeyOffset, (RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (long)currentKeySize)) continue;
                log.error("Entries with duplicate keys within a tier: at pos {} and {} with key {}, first value is {}", new Object[]{entryPos, anotherEntryPos, this.key(), this.value()});
                this.freeList().clearRange(entryPos, entryPos + (long)currentEntrySizeInChunks);
                continue block0;
            } while ((insertPos = hl.step(insertPos)) != startInsertPos);
            throw new ChronicleHashRecoveryFailedException("HashLookup overflow should never occur. It might also be concurrent access to ChronicleMap at " + h.file() + " while recovery procedure is in progress");
        } while ((hlPos = hl.step(hlPos)) != 0L);
        this.shiftHashLookupEntries();
        return segmentIndex;
    }

    @Override
    public void recoverSegments() {
        long storedFirstFreeTierIndex;
        Logger log = LOG;
        VanillaChronicleHash h = this.h();
        for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.initSegmentIndex(segmentIndex);
            this.resetSegmentLock();
            this.zeroOutFirstSegmentTierCountersArea();
            this.recoverTier(segmentIndex);
        }
        VanillaGlobalMutableState globalMutableState = h.globalMutableState();
        long storedExtraTiersInUse = globalMutableState.getExtraTiersInUse();
        long allocatedExtraTiers = (long)globalMutableState.getAllocatedExtraTierBulks() * h.tiersInBulk;
        long expectedExtraTiersInUse = Math.max(0L, Math.min(storedExtraTiersInUse, allocatedExtraTiers));
        long actualExtraTiersInUse = 0L;
        long firstFreeExtraTierIndex = -1L;
        for (long extraTierIndex = 0L; extraTierIndex < expectedExtraTiersInUse; ++extraTierIndex) {
            long tierCountersAreaAddr;
            long tierIndex = h.extraTierIndexToTierIndex(extraTierIndex);
            this.initSegmentTier(0, tierIndex);
            int segmentIndex = this.recoverTier(-1);
            if (segmentIndex >= 0) {
                tierCountersAreaAddr = this.tierCountersAreaAddr();
                int storedSegmentIndex = TierCountersArea.segmentIndex(tierCountersAreaAddr);
                if (storedSegmentIndex != segmentIndex) {
                    log.error("wrong segment index stored in tier counters area of tier with index {}: {}, should be, based on entries: {}", new Object[]{tierIndex, storedSegmentIndex, segmentIndex});
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, segmentIndex);
                }
            } else {
                firstFreeExtraTierIndex = extraTierIndex;
                break;
            }
            this.nextTierIndex(0L);
            this.initSegmentIndex(segmentIndex);
            this.goToLastTier();
            this.nextTierIndex(tierIndex);
            TierCountersArea.prevTierIndex(tierCountersAreaAddr, this.tierIndex());
            TierCountersArea.tier(tierCountersAreaAddr, this.tier() + 1);
            actualExtraTiersInUse = extraTierIndex + 1L;
        }
        if (storedExtraTiersInUse != actualExtraTiersInUse) {
            log.error("wrong number of actual tiers in use in global mutable state, stored: {}, should be: {}", (Object)storedExtraTiersInUse, (Object)actualExtraTiersInUse);
            globalMutableState.setExtraTiersInUse(actualExtraTiersInUse);
        }
        long firstFreeTierIndex = firstFreeExtraTierIndex == -1L ? (allocatedExtraTiers > expectedExtraTiersInUse ? h.extraTierIndexToTierIndex(expectedExtraTiersInUse) : 0L) : h.extraTierIndexToTierIndex(firstFreeExtraTierIndex);
        if (firstFreeTierIndex > 0L) {
            long lastTierIndex = h.extraTierIndexToTierIndex(allocatedExtraTiers - 1L);
            h.linkAndZeroOutFreeTiers(firstFreeTierIndex, lastTierIndex);
        }
        if ((storedFirstFreeTierIndex = globalMutableState.getFirstFreeTierIndex()) != firstFreeTierIndex) {
            log.error("wrong first free tier index in global mutable state, stored: {}, should be: {}", (Object)storedFirstFreeTierIndex, (Object)firstFreeTierIndex);
        }
        this.removeDuplicatesInSegments();
    }

    boolean delayedUpdateChecksumInit() {
        return this.delayedUpdateChecksum;
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (this.entryOffsetInit() && this.keySizeOffset() >= 0L);
        assert (this.locksInit() && this.localLockState() != LocalLockState.UNLOCKED);
        assert (delayedUpdateChecksum);
        this.delayedUpdateChecksum = true;
    }

    public void closeDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!((ReplicatedChronicleMap)this.m()).constantlySizedEntry && ((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.freeExtraGuarded(this.pos(), this.allocatedChunks(), this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.pos());
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.tier() != tierBeforeAllocation;
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long oldPos = this.pos();
        long oldTierIndex = this.tierIndex();
        this._MapEntryStages_relocation(newValue, newSizeOfEverythingBeforeValue);
        this.moveChange(oldTierIndex, oldPos, this.pos());
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, ((ReplicatedChronicleMap)this.m()).alignment)));
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.reallocGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeExtraGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks);
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
    }

    public void doInsert(Data<V> value) {
        this.checkOnEachPublicOperation();
        if (this.entryDeleted()) {
            try {
                this.tierDeleted(this.tierDeleted() - 1L);
                this.innerDefaultReplaceValue(value);
                this.incrementModCountGuarded();
                this.writeEntryPresent();
                this.updatedReplicationStateOnPresentEntry();
                this.updateChange();
            }
            finally {
                this.innerWriteLock.unlock();
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
    }

    public void doInsert() {
        if (this.set() == null) {
            throw new IllegalStateException("Called SetAbsentEntry.doInsert() from Map context");
        }
        this.doInsert(DummyValueData.INSTANCE);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
            this.updatedReplicationStateOnPresentEntry();
            this.updateChange();
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        try {
            if (this.valueSize() > this.dummyValue.size()) {
                this.innerDefaultReplaceValue(this.dummyValue);
            }
            this.updatedReplicationStateOnPresentEntry();
            this.writeEntryDeleted();
            this.updateChange();
            this.tierDeleted(this.tierDeleted() + 1L);
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    public boolean replicationUpdateInit() {
        return this.innerRemoteIdentifier != 0;
    }

    public void initReplicationUpdate(byte identifier, long timestamp, byte remoteNodeIdentifier) {
        this.innerRemoteTimestamp = timestamp;
        if (identifier == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        this.innerRemoteIdentifier = identifier;
        if (remoteNodeIdentifier == 0) {
            throw new IllegalStateException("remote node identifier can't be 0");
        }
        this.innerRemoteNodeIdentifier = remoteNodeIdentifier;
    }

    public byte innerRemoteIdentifier() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteIdentifier;
    }

    public byte innerRemoteNodeIdentifier() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteNodeIdentifier;
    }

    public long innerRemoteTimestamp() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteTimestamp;
    }

    public void closeReplicationUpdate() {
        if (!this.replicationUpdateInit()) {
            return;
        }
        this.innerRemoteIdentifier = 0;
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteTimestamp();
    }

    @Override
    public byte remoteNodeIdentifier() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteNodeIdentifier();
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteIdentifier();
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public class ReplicatedMapEntryDelegating
    implements ReplicableEntryDelegating,
    MapEntry<K, V> {
        @Override
        @NotNull
        public Data<V> value() {
            return CompiledReplicatedMapIterationContext.this.value();
        }

        @Override
        @NotNull
        public Data<K> key() {
            return CompiledReplicatedMapIterationContext.this.key();
        }

        @Override
        @NotNull
        public MapContext<K, V, ?> context() {
            return CompiledReplicatedMapIterationContext.this.context();
        }

        @Override
        public ReplicableEntry d() {
            return CompiledReplicatedMapIterationContext.this;
        }

        @Override
        public void doReplaceValue(Data<V> newValue) {
            CompiledReplicatedMapIterationContext.this.doReplaceValue(newValue);
        }

        @Override
        public void doRemove() {
            CompiledReplicatedMapIterationContext.this.doRemove();
        }
    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledReplicatedMapIterationContext.this.decrementWriteGuarded() == 0) {
                        CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                }
            }
        }

        @Override
        public void lock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapIterationContext.this.segmentHeader().writeLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            return CompiledReplicatedMapIterationContext.this.localLockState().write;
        }
    }

    public class WrappedValueInstanceDataHolder {
        private final DataAccess<V> wrappedValueDataAccess;
        private WrappedValueInstanceDataHolder next;
        private V value;
        public Data<V> wrappedData = null;

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = (DataAccess)((ReplicatedChronicleMap)CompiledReplicatedMapIterationContext.this.m()).valueDataAccess.copy();
        }

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceDataHolder();
            }
            return this.next.getUnusedWrappedValueHolder();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueInstanceDataHolder next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            boolean wasValueInit = this.valueInit();
            CompiledReplicatedMapIterationContext.this.m().checkValue(value);
            this.value = value;
            if (wasValueInit) {
                this.closeValueDependants();
            }
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next() != null) {
                this.next().closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public boolean wrappedDataInit() {
            return this.wrappedData != null;
        }

        private void initWrappedData() {
            this.wrappedData = this.wrappedValueDataAccess.getData(this.value());
        }

        public Data<V> wrappedData() {
            if (!this.wrappedDataInit()) {
                this.initWrappedData();
            }
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }
    }

    public class WrappedValueBytesData
    extends AbstractData<V> {
        private final VanillaBytes wrappedValueBytes = new VanillaBytes((BytesStore)NoBytesStore.NO_BYTES_STORE);
        private WrappedValueBytesData next;
        private long wrappedValueBytesOffset;
        private long wrappedValueBytesSize;
        private BytesStore wrappedValueBytesStore;
        private boolean wrappedValueBytesUsed = false;
        private V cachedWrappedValue;
        private boolean cachedWrappedValueRead = false;

        public WrappedValueBytesData getUnusedWrappedValueBytesDataGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueBytesData();
        }

        public WrappedValueBytesData getUnusedWrappedValueBytesData() {
            if (!this.wrappedValueBytesStoreInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueBytesData();
            }
            return this.next.getUnusedWrappedValueBytesData();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueBytesData next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeWrappedValueBytesStore();
        }

        boolean wrappedValueBytesStoreInit() {
            return this.wrappedValueBytesStore != null;
        }

        public void initWrappedValueBytesStore(BytesStore bytesStore, long offset, long size) {
            boolean wasWrappedValueBytesStoreInit = this.wrappedValueBytesStoreInit();
            this.wrappedValueBytesStore = bytesStore;
            this.wrappedValueBytesOffset = offset;
            this.wrappedValueBytesSize = size;
            if (wasWrappedValueBytesStoreInit) {
                this.closeWrappedValueBytesStoreDependants();
            }
        }

        public long wrappedValueBytesSize() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesSize;
        }

        public long wrappedValueBytesOffset() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesOffset;
        }

        public BytesStore wrappedValueBytesStore() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesStore;
        }

        void closeWrappedValueBytesStore() {
            if (!this.wrappedValueBytesStoreInit()) {
                return;
            }
            this.closeWrappedValueBytesStoreDependants();
            this.wrappedValueBytesStore = null;
            if (this.next() != null) {
                this.next().closeWrappedValueBytesStore();
            }
        }

        public void closeWrappedValueBytesStoreDependants() {
            this.closeWrappedValueBytes();
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesSize();
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesOffset();
        }

        boolean wrappedValueBytesInit() {
            return this.wrappedValueBytesUsed;
        }

        void initWrappedValueBytes() {
            boolean wasWrappedValueBytesInit = this.wrappedValueBytesInit();
            this.wrappedValueBytes.bytesStore(this.wrappedValueBytesStore(), this.wrappedValueBytesOffset(), this.wrappedValueBytesSize());
            this.wrappedValueBytesUsed = true;
            if (wasWrappedValueBytesInit) {
                this.closeWrappedValueBytesDependants();
            }
        }

        public VanillaBytes wrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                this.initWrappedValueBytes();
            }
            return this.wrappedValueBytes;
        }

        void closeWrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                return;
            }
            this.closeWrappedValueBytesDependants();
            this.wrappedValueBytes.bytesStore((BytesStore)NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.wrappedValueBytesUsed = false;
        }

        public void closeWrappedValueBytesDependants() {
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytes().bytesStore();
        }

        private V innerGetUsing(V usingValue) {
            this.wrappedValueBytes().readPosition(this.wrappedValueBytesOffset());
            return CompiledReplicatedMapIterationContext.this.valueReader.read((Bytes)this.wrappedValueBytes(), this.wrappedValueBytesSize(), usingValue);
        }

        public void closeWrappedValueBytesDataInnerGetUsingDependants() {
            this.closeCachedWrappedValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        public boolean cachedWrappedValueInit() {
            return this.cachedWrappedValueRead;
        }

        private void initCachedWrappedValue() {
            this.cachedWrappedValue = this.innerGetUsing(this.cachedWrappedValue);
            this.cachedWrappedValueRead = true;
        }

        public V cachedWrappedValue() {
            if (!this.cachedWrappedValueInit()) {
                this.initCachedWrappedValue();
            }
            return this.cachedWrappedValue;
        }

        public void closeCachedWrappedValue() {
            if (!this.cachedWrappedValueInit()) {
                return;
            }
            this.cachedWrappedValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedWrappedValue();
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        CompiledReplicatedMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            return CompiledReplicatedMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded() != 0 || !CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) break;
                    CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledReplicatedMapIterationContext.this.decrementWriteGuarded() != 0) break;
                    if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                        CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().updateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (RuntimeException e) {
                            LOG.error(CompiledReplicatedMapIterationContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class ReplicatedMapAbsentDelegatingForIteration
    implements ReplicableEntryDelegating,
    MapAbsentEntry<K, V>,
    SetAbsentEntry<K> {
        @Override
        @NotNull
        public Data<K> absentKey() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.entryKey;
        }

        @Override
        @NotNull
        public Data<V> defaultValue() {
            return CompiledReplicatedMapIterationContext.this.defaultValue();
        }

        @Override
        @NotNull
        public CompiledReplicatedMapIterationContext<K, V, R> context() {
            return CompiledReplicatedMapIterationContext.this.context();
        }

        @Override
        public ReplicableEntry d() {
            return CompiledReplicatedMapIterationContext.this;
        }

        @Override
        public void doInsert() {
            CompiledReplicatedMapIterationContext.this.doInsert();
        }

        @Override
        public void doInsert(Data<V> value) {
            CompiledReplicatedMapIterationContext.this.doInsert(value);
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.readZeroGuarded() && CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.readZeroGuarded() && CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().readLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledReplicatedMapIterationContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            return CompiledReplicatedMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledReplicatedMapIterationContext.this.localLockState() != LocalLockState.UNLOCKED) {
                CompiledReplicatedMapIterationContext.this.closeHashLookupPos();
                CompiledReplicatedMapIterationContext.this.closePos();
                CompiledReplicatedMapIterationContext.this.closeKeyOffset();
            }
            CompiledReplicatedMapIterationContext.this.readUnlockAndDecrementCountGuarded();
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded() || !CompiledReplicatedMapIterationContext.this.updateZeroGuarded() || !CompiledReplicatedMapIterationContext.this.writeZeroGuarded() || CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            CompiledReplicatedMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded() || !CompiledReplicatedMapIterationContext.this.updateZeroGuarded() || !CompiledReplicatedMapIterationContext.this.writeZeroGuarded() || CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class HashEntryChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        @Override
        public int storedChecksum() {
            return CompiledReplicatedMapIterationContext.this.segmentBS().readInt(CompiledReplicatedMapIterationContext.this.entryEnd());
        }

        @Override
        public int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledReplicatedMapIterationContext.this.keyHashCode();
            long keyEnd = CompiledReplicatedMapIterationContext.this.keyEnd();
            long len = CompiledReplicatedMapIterationContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledReplicatedMapIterationContext.this.tierBaseAddr() + keyEnd;
                long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapIterationContext.this.keySize(), keyHashCode, payloadChecksum);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapIterationContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        public void closeHashEntryChecksumStrategyComputeChecksumDependants() {
            this.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        }

        @Override
        public boolean innerCheckSum() {
            int checksum;
            int oldChecksum = this.storedChecksum();
            return oldChecksum == (checksum = this.computeChecksum());
        }

        @Override
        public void computeAndStoreChecksum() {
            int checksum = this.computeChecksum();
            CompiledReplicatedMapIterationContext.this.segmentBS().writeInt(CompiledReplicatedMapIterationContext.this.entryEnd(), checksum);
        }

        public void closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants() {
            CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead;

        public EntryValueBytesData() {
            this.cachedEntryValue = CompiledReplicatedMapIterationContext.this.m().valueClass() == CharSequence.class ? new StringBuilder() : null;
            this.cachedEntryValueRead = false;
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.segmentBS();
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledReplicatedMapIterationContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledReplicatedMapIterationContext.this.valueOffset());
            return CompiledReplicatedMapIterationContext.this.valueReader.read(segmentBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.segmentBS();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledReplicatedMapIterationContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledReplicatedMapIterationContext.this.keyOffset());
            return CompiledReplicatedMapIterationContext.this.keyReader.read(bytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keyOffset();
        }
    }

    public class DummyValueZeroData
    extends AbstractData<V> {
        private final Bytes zeroBytes = ZeroBytesStore.INSTANCE.bytesForRead();

        public Bytes zeroBytes() {
            return this.zeroBytes;
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return ZeroBytesStore.INSTANCE;
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return 0L;
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return Math.max(0L, ((ReplicatedChronicleMap)CompiledReplicatedMapIterationContext.this.m()).valueSizeMarshaller.minStorableSize());
        }

        private IllegalStateException zeroReadException(Exception cause) {
            return new IllegalStateException("Most probable cause of this exception - zero bytes of\nthe minimum positive encoding length, supported by the specified or default\nvalueSizeMarshaller() is not correct serialized form of any value. You should\nconfigure defaultValueProvider() in ChronicleMapBuilder");
        }

        @Override
        public V getUsing(V using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            this.zeroBytes.readPosition(0L);
            try {
                return CompiledReplicatedMapIterationContext.this.valueReader.read(this.zeroBytes, this.size(), using);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            try {
                return this.getUsing((V)null);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }
    }

    static enum EntriesToTest {
        PRESENT,
        ALL;

    }
}

