/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.LogHolder;
import net.openhft.chronicle.hash.impl.stage.iter.TierRecovery;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.slf4j.Logger;

@Staged
public abstract class SegmentsRecovery
implements IterationContext {
    @StageRef
    VanillaChronicleHashHolder<?> hh;
    @StageRef
    SegmentStages s;
    @StageRef
    TierRecovery tierRecovery;
    @StageRef
    LogHolder lh;

    @Override
    public void recoverSegments() {
        long storedFirstFreeTierIndex;
        Logger log = LogHolder.LOG;
        VanillaChronicleHash<?, ?, ?, ?> h = this.hh.h();
        for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.s.initSegmentIndex(segmentIndex);
            this.resetSegmentLock();
            this.zeroOutFirstSegmentTierCountersArea();
            this.tierRecovery.recoverTier(segmentIndex);
        }
        VanillaGlobalMutableState globalMutableState = h.globalMutableState();
        long storedExtraTiersInUse = globalMutableState.getExtraTiersInUse();
        long allocatedExtraTiers = (long)globalMutableState.getAllocatedExtraTierBulks() * h.tiersInBulk;
        long expectedExtraTiersInUse = Math.max(0L, Math.min(storedExtraTiersInUse, allocatedExtraTiers));
        long actualExtraTiersInUse = 0L;
        long firstFreeExtraTierIndex = -1L;
        for (long extraTierIndex = 0L; extraTierIndex < expectedExtraTiersInUse; ++extraTierIndex) {
            long tierCountersAreaAddr;
            long tierIndex = h.extraTierIndexToTierIndex(extraTierIndex);
            this.s.initSegmentTier(0, tierIndex);
            int segmentIndex = this.tierRecovery.recoverTier(-1);
            if (segmentIndex >= 0) {
                tierCountersAreaAddr = this.s.tierCountersAreaAddr();
                int storedSegmentIndex = TierCountersArea.segmentIndex(tierCountersAreaAddr);
                if (storedSegmentIndex != segmentIndex) {
                    log.error("wrong segment index stored in tier counters area of tier with index {}: {}, should be, based on entries: {}", new Object[]{tierIndex, storedSegmentIndex, segmentIndex});
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, segmentIndex);
                }
            } else {
                firstFreeExtraTierIndex = extraTierIndex;
                break;
            }
            this.s.nextTierIndex(0L);
            this.s.initSegmentIndex(segmentIndex);
            this.s.goToLastTier();
            this.s.nextTierIndex(tierIndex);
            TierCountersArea.prevTierIndex(tierCountersAreaAddr, this.s.tierIndex);
            TierCountersArea.tier(tierCountersAreaAddr, this.s.tier + 1);
            actualExtraTiersInUse = extraTierIndex + 1L;
        }
        if (storedExtraTiersInUse != actualExtraTiersInUse) {
            log.error("wrong number of actual tiers in use in global mutable state, stored: {}, should be: {}", (Object)storedExtraTiersInUse, (Object)actualExtraTiersInUse);
            globalMutableState.setExtraTiersInUse(actualExtraTiersInUse);
        }
        long firstFreeTierIndex = firstFreeExtraTierIndex == -1L ? (allocatedExtraTiers > expectedExtraTiersInUse ? h.extraTierIndexToTierIndex(expectedExtraTiersInUse) : 0L) : h.extraTierIndexToTierIndex(firstFreeExtraTierIndex);
        if (firstFreeTierIndex > 0L) {
            long lastTierIndex = h.extraTierIndexToTierIndex(allocatedExtraTiers - 1L);
            h.linkAndZeroOutFreeTiers(firstFreeTierIndex, lastTierIndex);
        }
        if ((storedFirstFreeTierIndex = globalMutableState.getFirstFreeTierIndex()) != firstFreeTierIndex) {
            log.error("wrong first free tier index in global mutable state, stored: {}, should be: {}", (Object)storedFirstFreeTierIndex, (Object)firstFreeTierIndex);
        }
        this.removeDuplicatesInSegments();
    }

    private void removeDuplicatesInSegments() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.hh.h();
        block0: for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.s.initSegmentIndex(segmentIndex);
            this.s.initSegmentTier();
            this.s.goToLastTier();
            while (true) {
                this.tierRecovery.removeDuplicatesInSegment();
                if (this.s.tier <= 0) continue block0;
                this.s.prevTier();
            }
        }
    }

    private void resetSegmentLock() {
        long lockState = this.s.segmentHeader.getLockState(this.s.segmentHeaderAddress);
        if (lockState != this.s.segmentHeader.resetLockState()) {
            LogHolder.LOG.error("lock of segment {} is not clear: {}", (Object)this.s.segmentIndex, (Object)this.s.segmentHeader.lockStateToString(lockState));
            this.s.segmentHeader.resetLock(this.s.segmentHeaderAddress);
        }
    }

    private void zeroOutFirstSegmentTierCountersArea() {
        long tierCountersAreaAddr;
        this.s.nextTierIndex(0L);
        if (this.s.prevTierIndex() != 0L) {
            LogHolder.LOG.error("stored prev tier index in first tier of segment {}: {}, should be 0", (Object)this.s.segmentIndex, (Object)this.s.prevTierIndex());
            this.s.prevTierIndex(0L);
        }
        if (TierCountersArea.segmentIndex(tierCountersAreaAddr = this.s.tierCountersAreaAddr()) != 0) {
            LogHolder.LOG.error("stored segment index in first tier of segment {}: {}, should be 0", (Object)this.s.segmentIndex, (Object)TierCountersArea.segmentIndex(tierCountersAreaAddr));
            TierCountersArea.segmentIndex(tierCountersAreaAddr, 0);
        }
        if (TierCountersArea.tier(tierCountersAreaAddr) != 0) {
            LogHolder.LOG.error("stored tier in first tier of segment {}: {}, should be 0", (Object)this.s.segmentIndex, (Object)TierCountersArea.tier(tierCountersAreaAddr));
            TierCountersArea.tier(tierCountersAreaAddr, 0);
        }
    }
}

