/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class HashEntryChecksumStrategy
implements ChecksumStrategy {
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages<?> e;
    @StageRef
    KeyHashCode h;

    @Override
    public void computeAndStoreChecksum() {
        int checksum = this.computeChecksum();
        this.s.segmentBS.writeInt(this.e.entryEnd(), checksum);
    }

    @Override
    public int computeChecksum() {
        long checksum;
        long keyHashCode = this.h.keyHashCode();
        long keyEnd = this.e.keyEnd();
        long len = this.e.entryEnd() - keyEnd;
        if (len > 0L) {
            long addr = this.s.tierBaseAddr + keyEnd;
            long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
            checksum = ChecksumHashing.hash8To16Bytes(this.e.keySize, keyHashCode, payloadChecksum);
        } else {
            checksum = ChecksumHashing.hash8To16Bytes(this.e.keySize, keyHashCode, keyHashCode);
        }
        return (int)(checksum >>> 32 ^ checksum);
    }

    @Override
    public boolean innerCheckSum() {
        int checksum;
        int oldChecksum = this.storedChecksum();
        return oldChecksum == (checksum = this.computeChecksum());
    }

    @Override
    public int storedChecksum() {
        return this.s.segmentBS.readInt(this.e.entryEnd());
    }

    @Override
    public long extraEntryBytes() {
        return 4L;
    }
}

