/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.data.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.map.impl.stage.map.ValueBytesInterop;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class WrappedValueBytesData<V>
extends AbstractData<V> {
    @Stage(value="WrappedValueBytes")
    private final VanillaBytes<Void> wrappedValueBytes = VanillaBytes.vanillaBytes();
    @StageRef
    ValueBytesInterop<V> vi;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    private WrappedValueBytesData<V> next;
    @Stage(value="WrappedValueBytesStore")
    private BytesStore<?, ?> wrappedValueBytesStore;
    @Stage(value="WrappedValueBytesStore")
    private long wrappedValueBytesOffset;
    @Stage(value="WrappedValueBytesStore")
    private long wrappedValueBytesSize;
    @Stage(value="WrappedValueBytes")
    private boolean wrappedValueBytesUsed = false;
    @Stage(value="CachedWrappedValue")
    private V cachedWrappedValue;
    @Stage(value="CachedWrappedValue")
    private boolean cachedWrappedValueRead = false;

    boolean nextInit() {
        return true;
    }

    void closeNext() {
    }

    @Stage(value="Next")
    public WrappedValueBytesData<V> getUnusedWrappedValueBytesData() {
        if (!this.wrappedValueBytesStoreInit()) {
            return this;
        }
        if (this.next == null) {
            this.next = new WrappedValueBytesData<V>();
        }
        return this.next.getUnusedWrappedValueBytesData();
    }

    boolean wrappedValueBytesStoreInit() {
        return this.wrappedValueBytesStore != null;
    }

    public void initWrappedValueBytesStore(BytesStore<?, ?> bytesStore, long offset, long size) {
        this.wrappedValueBytesStore = bytesStore;
        this.wrappedValueBytesOffset = offset;
        this.wrappedValueBytesSize = size;
    }

    void closeWrappedValueBytesStore() {
        this.wrappedValueBytesStore = null;
        if (this.next != null) {
            this.next.closeWrappedValueBytesStore();
        }
    }

    boolean wrappedValueBytesInit() {
        return this.wrappedValueBytesUsed;
    }

    void initWrappedValueBytes() {
        this.wrappedValueBytes.bytesStore(this.wrappedValueBytesStore, this.wrappedValueBytesOffset, this.wrappedValueBytesSize);
        this.wrappedValueBytesUsed = true;
    }

    void closeWrappedValueBytes() {
        this.wrappedValueBytes.bytesStore(BytesStore.empty(), 0L, 0L);
        this.wrappedValueBytesUsed = false;
    }

    private void initCachedWrappedValue() {
        this.cachedWrappedValue = this.innerGetUsing(this.cachedWrappedValue);
        this.cachedWrappedValueRead = true;
    }

    @Override
    public RandomDataInput bytes() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.wrappedValueBytes.bytesStore();
    }

    @Override
    public long offset() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.wrappedValueBytesOffset;
    }

    @Override
    public long size() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.wrappedValueBytesSize;
    }

    @Override
    public V get() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.cachedWrappedValue;
    }

    @Override
    public V getUsing(V using) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerGetUsing(using);
    }

    private V innerGetUsing(V usingValue) {
        this.wrappedValueBytes.readPosition(this.wrappedValueBytesOffset);
        return this.vi.valueReader.read((Bytes<?>)this.wrappedValueBytes, this.wrappedValueBytesSize, usingValue);
    }
}

