/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.locks;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.StampedLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.locks.ChronicleStampedLockVOInterface;
import net.openhft.chronicle.values.Values;

public class ChronicleStampedLock
extends StampedLock {
    ChronicleMap<String, ChronicleStampedLockVOInterface> chm;
    ChronicleMap<String, LongValue> chmR;
    ChronicleMap<String, LongValue> chmW;
    ChronicleStampedLockVOInterface offHeapLock = (ChronicleStampedLockVOInterface)Values.newNativeReference(ChronicleStampedLockVOInterface.class);
    ChronicleStampedLockVOInterface lastWriterT = (ChronicleStampedLockVOInterface)Values.newNativeReference(ChronicleStampedLockVOInterface.class);
    LongValue readLockHolderCount = (LongValue)Values.newNativeReference(LongValue.class);
    LongValue writeLockHolderCount = (LongValue)Values.newNativeReference(LongValue.class);

    ChronicleStampedLock(String chronicelStampedLockLocality) {
        try {
            this.chm = ChronicleStampedLock.offHeapLock(chronicelStampedLockLocality);
            this.chmR = ChronicleStampedLock.offHeapLockReaderCount(chronicelStampedLockLocality + "=ReaderCount");
            this.chmW = ChronicleStampedLock.offHeapLockReaderCount(chronicelStampedLockLocality + "=WriterCount");
            this.chm.acquireUsing("Stamp ", this.offHeapLock);
            this.chm.acquireUsing("LastWriterTime ", this.lastWriterT);
            this.chmR.acquireUsing("ReaderCount ", this.readLockHolderCount);
            this.chmW.acquireUsing("WriterCount ", this.readLockHolderCount);
            Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock constructed,");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static ChronicleMap<String, ChronicleStampedLockVOInterface> offHeapLock(String operand) throws IOException {
        return ((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMapBuilder.of(String.class, ChronicleStampedLockVOInterface.class).entries(16L)).averageKeySize("123456789".length())).createPersistedTo(new File(operand));
    }

    static ChronicleMap<String, LongValue> offHeapLockReaderCount(String operand) throws IOException {
        return ((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMapBuilder.of(String.class, LongValue.class).entries(16L)).averageKeySize("123456789".length())).createPersistedTo(new File(operand));
    }

    public void closeChronicle() {
    }

    @Override
    public long tryOptimisticRead() {
        this.offHeapLock = this.chm.get("Stamp ");
        this.offHeapLock.setEntryLockState(0L);
        long t = System.currentTimeMillis();
        this.chm.put("Stamp ", this.offHeapLock);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock saw stamp=[" + 0L + "] tryOptmisticRead() returning stamp=" + t + ",");
        return t;
    }

    @Override
    public boolean validate(long stamp) {
        this.offHeapLock = this.chm.get("Stamp ");
        this.lastWriterT = this.chm.get("LastWriterTime ");
        boolean ret = false;
        ret = this.lastWriterT.getEntryLockState() > stamp || this.offHeapLock.getEntryLockState() < 0L ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock validate(" + stamp + ") returned =[" + ret + "] ,");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock LastWriterT=[" + this.lastWriterT.getEntryLockState() + "] ,");
        return ret;
    }

    @Override
    public long tryConvertToReadLock(long stamp) {
        try {
            throw new Exception("not supported in ChronicleStampedLock's reference impl.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public long tryConvertToWriteLock(long stamp) {
        try {
            throw new Exception("not supported in ChronicleStampedLock's reference impl.");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public long tryWriteLock() {
        long l = 0L;
        this.offHeapLock = this.chm.get("Stamp ");
        this.lastWriterT = this.chm.get("LastWriterTime ");
        this.writeLockHolderCount = this.chmW.get("WriterCount ");
        l = this.offHeapLock.getEntryLockState();
        if (l != 0L) {
            return 0L;
        }
        do {
            this.readLockHolderCount = this.chmR.get("ReaderCount ");
            this.writeLockHolderCount = this.chmW.get("WriterCount ");
            Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock tryWriteLock() ?WAITING  on offHeapLock.unlock(" + this.offHeapLock.getEntryLockState() + ")  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "]  writerCount=[" + this.writeLockHolderCount.getVolatileValue() + "] ,");
            this.offHeapLock = this.chm.get("Stamp ");
            l = this.offHeapLock.getEntryLockState();
            try {
                Thread.sleep((long)(1000.0 * Math.random()));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        } while (this.readLockHolderCount.getVolatileValue() > 0L || (this.writeLockHolderCount = this.chmW.get("WriterCount ")).getVolatileValue() > 0L);
        this.writeLockHolderCount.addAtomicValue(1L);
        this.chmW.put("WriterCount ", this.writeLockHolderCount);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock trywriteLock() ++ writeSeekers=[" + this.writeLockHolderCount.getVolatileValue() + "] ..,");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock tryWriteLock() PROCEEDING  ,");
        long t = System.currentTimeMillis();
        this.offHeapLock.setEntryLockState(-t);
        this.lastWriterT.setEntryLockState(t);
        this.chm.put("Stamp ", this.offHeapLock);
        this.chm.put("LastWriterTime ", this.lastWriterT);
        Jvm.debug().on(this.getClass(), " ,@t=" + t + " ChronicleStampedLock tryWriteLock() returned stamp=" + this.offHeapLock.getEntryLockState() + ",");
        return this.offHeapLock.getEntryLockState();
    }

    @Override
    public long tryReadLock() {
        long l = 0L;
        this.offHeapLock = this.chm.get("Stamp ");
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        this.offHeapLock = this.chm.get("Stamp ");
        l = this.offHeapLock.getEntryLockState();
        if (l < 0L) {
            return 0L;
        }
        do {
            this.writeLockHolderCount = this.chmW.get("WriterCount ");
            Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock tryReadLock() ?WAITING  on offHeapLock.unlock(" + this.offHeapLock.getEntryLockState() + ")  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "]  writerCount=[" + this.writeLockHolderCount.getVolatileValue() + "] ,");
            this.offHeapLock = this.chm.get("Stamp ");
            l = this.offHeapLock.getEntryLockState();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        } while (l < 0L);
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock tryReadLock() PROCEEDING  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "] BEFORE addAtomic(1) ,");
        this.readLockHolderCount.addAtomicValue(1L);
        this.chmR.put("ReaderCount ", this.readLockHolderCount);
        this.offHeapLock.setEntryLockState(this.readLockHolderCount.getVolatileValue());
        this.chm.put("Stamp ", this.offHeapLock);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock tryReadLock() returned stamp=" + this.offHeapLock.getEntryLockState() + " readerCount=[" + this.readLockHolderCount.getVolatileValue() + "] AFTER addAtomic(1) ,");
        return this.offHeapLock.getEntryLockState();
    }

    @Override
    public long writeLock() {
        long l = 0L;
        this.offHeapLock = this.chm.get("Stamp ");
        this.lastWriterT = this.chm.get("LastWriterTime ");
        this.writeLockHolderCount = this.chmW.get("WriterCount ");
        do {
            this.readLockHolderCount = this.chmR.get("ReaderCount ");
            this.writeLockHolderCount = this.chmW.get("WriterCount ");
            Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock writeLock() ?WAITING  on offHeapLock.unlock(" + this.offHeapLock.getEntryLockState() + ")  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "]  writerCount=[" + this.writeLockHolderCount.getVolatileValue() + "] ,");
            this.offHeapLock = this.chm.get("Stamp ");
            l = this.offHeapLock.getEntryLockState();
            try {
                Thread.sleep((long)(1000.0 * Math.random()));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        } while (l != 0L || this.readLockHolderCount.getVolatileValue() > 0L || (this.writeLockHolderCount = this.chmW.get("WriterCount ")).getVolatileValue() > 0L);
        this.writeLockHolderCount.addAtomicValue(1L);
        this.chmW.put("WriterCount ", this.writeLockHolderCount);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock writeLock() ++ writeSeekers=[" + this.writeLockHolderCount.getVolatileValue() + "] ..,");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock writeLock() PROCEEDING  ,");
        long t = System.currentTimeMillis();
        this.offHeapLock.setEntryLockState(-t);
        this.lastWriterT.setEntryLockState(t);
        this.chm.put("Stamp ", this.offHeapLock);
        this.chm.put("LastWriterTime ", this.lastWriterT);
        Jvm.debug().on(this.getClass(), " ,@t=" + t + " ChronicleStampedLock writeLock() returned stamp=" + this.offHeapLock.getEntryLockState() + ",");
        return this.offHeapLock.getEntryLockState();
    }

    @Override
    public long readLock() {
        long l = 0L;
        this.offHeapLock = this.chm.get("Stamp ");
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        do {
            this.writeLockHolderCount = this.chmW.get("WriterCount ");
            Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock readLock() ?WAITING  on offHeapLock.unlock(" + this.offHeapLock.getEntryLockState() + ")  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "]  writerCount=[" + this.writeLockHolderCount.getVolatileValue() + "] ,");
            this.offHeapLock = this.chm.get("Stamp ");
            l = this.offHeapLock.getEntryLockState();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        } while (l < 0L);
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock readLock() PROCEEDING  readerCount=[" + this.readLockHolderCount.getVolatileValue() + "] BEFORE addAtomic(1) ,");
        this.readLockHolderCount.addAtomicValue(1L);
        this.chmR.put("ReaderCount ", this.readLockHolderCount);
        this.offHeapLock.setEntryLockState(this.readLockHolderCount.getVolatileValue());
        this.chm.put("Stamp ", this.offHeapLock);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock readLock() returned stamp=" + this.offHeapLock.getEntryLockState() + " readerCount=[" + this.readLockHolderCount.getVolatileValue() + "] AFTER addAtomic(1) ,");
        return this.offHeapLock.getEntryLockState();
    }

    @Override
    public void unlock(long stamp) {
        if (stamp < 0L) {
            this.unlockWrite(stamp);
        } else if (stamp > 0L) {
            this.unlockRead(stamp);
        }
    }

    @Override
    public void unlockRead(long stamp) {
        this.offHeapLock = this.chm.get("Stamp ");
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock unlockRead(" + stamp + ") unlocking..ReaderCount=[" + this.readLockHolderCount.getVolatileValue() + "] BEFORE addAtomic(-1) ,");
        this.readLockHolderCount.addAtomicValue(-1L);
        this.chmR.put("ReaderCount ", this.readLockHolderCount);
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock unlockRead(" + stamp + ") unlocking..ReaderCount=[" + this.readLockHolderCount.getVolatileValue() + "] AFTER addAtomic(-1) ,");
        this.readLockHolderCount = this.chmR.get("ReaderCount ");
        this.offHeapLock.setEntryLockState(this.readLockHolderCount.getVolatileValue());
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + "offHeapLock=[" + this.offHeapLock.getEntryLockState() + "],");
        this.chm.put("Stamp ", this.offHeapLock);
        this.chmR.put("ReaderCount ", this.readLockHolderCount);
    }

    @Override
    public void unlockWrite(long stamp) {
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock unlockWrite(" + stamp + ") unlocking..,");
        this.offHeapLock = this.chm.get("Stamp ");
        this.offHeapLock.setEntryLockState(0L);
        this.chm.put("Stamp ", this.offHeapLock);
        this.writeLockHolderCount = this.chmW.get("WriterCount ");
        this.writeLockHolderCount.addAtomicValue(-1L);
        this.chmW.put("WriterCount ", this.writeLockHolderCount);
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock unlockWrite(" + stamp + ") -- writeSeekers=[" + this.writeLockHolderCount.getVolatileValue() + "] ..,");
        this.offHeapLock = this.chm.get("Stamp ");
        Jvm.debug().on(this.getClass(), " ,@t=" + System.currentTimeMillis() + " ChronicleStampedLock unlockWrite(" + this.offHeapLock.getEntryLockState() + ") unlocked. set to Zero,");
    }

    @Override
    public int getReadLockCount() {
        return (int)this.chmR.get("ReaderCount ").getVolatileValue();
    }

    @Override
    public boolean isReadLocked() {
        if (this.getReadLockCount() > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

