/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBytesReader
implements BytesReader<String>,
StatefulCopyable<StringBytesReader> {
    private transient StringBuilder sb;

    public StringBytesReader() {
        this.initTransients();
    }

    private void initTransients() {
        this.sb = new StringBuilder();
    }

    @Override
    @NotNull
    public String read(Bytes in, @Nullable String using) {
        if (in.readUtf8(this.sb)) {
            return this.sb.toString();
        }
        throw new NullPointerException("BytesReader couldn't read null");
    }

    @Override
    public StringBytesReader copy() {
        return new StringBytesReader();
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

