/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.replication;

import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class ReplicationUpdate<K>
implements RemoteOperationContext<K> {
    @Stage(value="ReplicationUpdate")
    public byte innerRemoteIdentifier = 0;
    @Stage(value="ReplicationUpdate")
    public long innerRemoteTimestamp;
    @Stage(value="ReplicationUpdate")
    public byte innerRemoteNodeIdentifier;
    @StageRef
    SegmentStages s;
    @StageRef
    ReplicatedMapEntryStages<K, ?> e;
    @StageRef
    ReplicatedChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;

    public abstract boolean replicationUpdateInit();

    public void initReplicationUpdate(byte identifier, long timestamp, byte remoteNodeIdentifier) {
        this.innerRemoteTimestamp = timestamp;
        if (identifier == 0) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": identifier can't be 0");
        }
        this.innerRemoteIdentifier = identifier;
        if (remoteNodeIdentifier == 0) {
            throw new IllegalStateException(this.mh.h().toIdentityString() + ": remote node identifier can't be 0");
        }
        this.innerRemoteNodeIdentifier = remoteNodeIdentifier;
    }

    public void dropChange() {
        ((ReplicatedChronicleMap)this.mh.m()).dropChange(this.s.tierIndex, this.e.pos);
    }

    public void dropChangeFor(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.mh.m()).dropChangeFor(this.s.tierIndex, this.e.pos, remoteIdentifier);
    }

    public void moveChange(long oldTierIndex, long oldPos, long newPos) {
        ((ReplicatedChronicleMap)this.mh.m()).moveChange(oldTierIndex, oldPos, this.s.tierIndex, newPos);
    }

    public void updateChange() {
        if (!this.replicationUpdateInit()) {
            this.raiseChange();
        }
    }

    public void raiseChange() {
        ((ReplicatedChronicleMap)this.mh.m()).raiseChange(this.s.tierIndex, this.e.pos);
    }

    public void raiseChangeFor(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.mh.m()).raiseChangeFor(this.s.tierIndex, this.e.pos, remoteIdentifier);
    }

    public void raiseChangeForAllExcept(byte remoteIdentifier) {
        ((ReplicatedChronicleMap)this.mh.m()).raiseChangeForAllExcept(this.s.tierIndex, this.e.pos, remoteIdentifier);
    }

    public boolean changed() {
        return ((ReplicatedChronicleMap)this.mh.m()).isChanged(this.s.tierIndex, this.e.pos);
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerRemoteTimestamp;
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerRemoteIdentifier;
    }

    @Override
    public byte remoteNodeIdentifier() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerRemoteNodeIdentifier;
    }

    @Override
    public byte currentNodeIdentifier() {
        return ((ReplicatedChronicleMap)this.mh.m()).identifier();
    }
}

