/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.pool.CharSequenceInterner;
import net.openhft.lang.threadlocal.StatefulCopyable;
import org.jetbrains.annotations.NotNull;

public final class CharSequenceReader<S extends CharSequence>
implements BytesReader<S>,
StatefulCopyable<CharSequenceReader<S>> {
    private static final long serialVersionUID = 0L;
    private static final CharSequenceReader<String> STRING_READER = new CharSequenceReader<String>(NoInterningToString.INSTANCE, (Serializable)((Object)NoInterningToString.INSTANCE));
    private static final CharSequenceReader DEFAULT_READER = new CharSequenceReader<CharSequence>(NoInterningIdentity.INSTANCE, (Serializable)((Object)NoInterningIdentity.INSTANCE));
    private final StringBuilder sb = new StringBuilder(128);
    @NotNull
    private final CharSequenceInterner<S> interner;
    @NotNull
    private final Serializable identity;

    public static CharSequenceReader of() {
        return STRING_READER;
    }

    public static CharSequenceReader<String> ofStringBuilder() {
        return DEFAULT_READER;
    }

    public static <S extends CharSequence, I extends CharSequenceInterner<S> & Serializable> CharSequenceReader<S> of(@NotNull I interner, @NotNull Serializable stateIdentity) {
        return new CharSequenceReader<S>(interner, stateIdentity);
    }

    private CharSequenceReader(@NotNull CharSequenceInterner<S> interner, @NotNull Serializable identity) {
        this.interner = interner;
        this.identity = identity;
    }

    @Override
    public S read(Bytes bytes, long size) {
        this.sb.setLength(0);
        try {
            AbstractBytes.readUTF0((Bytes)bytes, (Appendable)this.sb, (int)((int)size));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return (S)((CharSequence)this.interner.intern((CharSequence)this.sb));
    }

    @Override
    public S read(Bytes bytes, long size, S toReuse) {
        Appendable appendable;
        if (toReuse instanceof Appendable) {
            appendable = (Appendable)toReuse;
            if (toReuse instanceof StringBuilder) {
                ((StringBuilder)toReuse).setLength(0);
            } else if (toReuse instanceof StringBuffer) {
                ((StringBuffer)toReuse).setLength(0);
            }
        } else {
            this.sb.setLength(0);
            appendable = this.sb;
        }
        try {
            AbstractBytes.readUTF0((Bytes)bytes, (Appendable)appendable, (int)((int)size));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (appendable == toReuse) {
            return toReuse;
        }
        return (S)((CharSequence)this.interner.intern((CharSequence)this.sb));
    }

    public Object stateIdentity() {
        return this.identity;
    }

    public CharSequenceReader<S> copy() {
        return new CharSequenceReader<S>(this.interner, this.identity);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.interner == NoInterningToString.INSTANCE) {
            return STRING_READER;
        }
        if (this.interner == NoInterningIdentity.INSTANCE) {
            return DEFAULT_READER;
        }
        return this;
    }

    private static enum NoInterningToString implements CharSequenceInterner<String>
    {
        INSTANCE;


        public String intern(CharSequence cs) {
            return cs.toString();
        }
    }

    private static enum NoInterningIdentity implements CharSequenceInterner<CharSequence>
    {
        INSTANCE;


        public CharSequence intern(CharSequence cs) {
            return cs;
        }
    }
}

