/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.replication.IdentifierListener;
import net.openhft.chronicle.hash.replication.ThrottlingConfig;

public final class TcpConfig {
    private static final int DEFAULT_PACKET_SIZE = 8192;
    private static final long DEFAULT_HEART_BEAT_INTERVAL = 20L;
    private static final TimeUnit DEFAULT_HEART_BEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    private final int serverPort;
    private final Set<InetSocketAddress> endpoints;
    private final int packetSize;
    private final boolean autoReconnectedUponDroppedConnection;
    private final ThrottlingConfig throttlingConfig;
    private final long heartBeatInterval;
    private final TimeUnit heartBeatIntervalUnit;
    private final IdentifierListener identifierListener;

    private TcpConfig(int serverPort, Set<InetSocketAddress> endpoints, int packetSize, boolean autoReconnectedUponDroppedConnection, ThrottlingConfig throttlingConfig, long heartBeatInterval, TimeUnit heartBeatIntervalUnit, IdentifierListener identifierListener) {
        this.serverPort = serverPort;
        this.endpoints = endpoints;
        this.packetSize = packetSize;
        this.autoReconnectedUponDroppedConnection = autoReconnectedUponDroppedConnection;
        this.throttlingConfig = throttlingConfig;
        this.heartBeatInterval = heartBeatInterval;
        this.heartBeatIntervalUnit = heartBeatIntervalUnit;
        this.identifierListener = identifierListener;
    }

    public static TcpConfig forSendingNode(int serverPort, InetSocketAddress ... endpoints) {
        return TcpConfig.forSendingNode(serverPort, Arrays.asList(endpoints));
    }

    public static TcpConfig forSendingNode(int serverPort, Collection<InetSocketAddress> endpoints) {
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException("There should be some endpoints");
        }
        return TcpConfig.forUnknownTopology(serverPort, endpoints);
    }

    public static TcpConfig forReceivingOnlyNode(int serverPort) {
        return TcpConfig.forUnknownTopology(serverPort, Collections.emptyList());
    }

    public static TcpConfig forUnknownTopology(int serverPort, Collection<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        return new TcpConfig(serverPort, Collections.unmodifiableSet(new HashSet<InetSocketAddress>(endpoints)), 8192, true, ThrottlingConfig.noThrottling(), 20L, DEFAULT_HEART_BEAT_INTERVAL_UNIT, null);
    }

    public IdentifierListener nonUniqueIdentifierListener() {
        return this.identifierListener;
    }

    public TcpConfig nonUniqueIdentifierListener(IdentifierListener identifierListener) {
        return new TcpConfig(this.serverPort, this.endpoints, this.packetSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, identifierListener);
    }

    public boolean autoReconnectedUponDroppedConnection() {
        return this.autoReconnectedUponDroppedConnection;
    }

    public TcpConfig autoReconnectedUponDroppedConnection(boolean autoReconnectedUponDroppedConnection) {
        return new TcpConfig(this.serverPort, this.endpoints, this.packetSize, autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, this.identifierListener);
    }

    public ThrottlingConfig throttlingConfig() {
        return this.throttlingConfig;
    }

    public TcpConfig throttlingConfig(ThrottlingConfig throttlingConfig) {
        ThrottlingConfig.checkMillisecondBucketInterval(throttlingConfig, "TCP");
        return new TcpConfig(this.serverPort, this.endpoints, this.packetSize, this.autoReconnectedUponDroppedConnection, throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, this.identifierListener);
    }

    public long heartBeatInterval(TimeUnit unit) {
        return unit.convert(this.heartBeatInterval, this.heartBeatIntervalUnit);
    }

    public int serverPort() {
        return this.serverPort;
    }

    public TcpConfig serverPort(int serverPort) {
        return new TcpConfig(serverPort, this.endpoints, this.packetSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, this.identifierListener);
    }

    public Set<InetSocketAddress> endpoints() {
        return this.endpoints;
    }

    public TcpConfig endpoints(Set<InetSocketAddress> endpoints) {
        for (InetSocketAddress endpoint : endpoints) {
            if (endpoint.getPort() != this.serverPort || !"localhost".equals(endpoint.getHostName())) continue;
            throw new IllegalArgumentException("endpoint=" + endpoint + " can not point to the same port as the server");
        }
        return new TcpConfig(this.serverPort, endpoints, this.packetSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, this.identifierListener);
    }

    public int packetSize() {
        return this.packetSize;
    }

    public TcpConfig packetSize(int packetSize) {
        if (packetSize <= 0) {
            throw new IllegalArgumentException();
        }
        return new TcpConfig(this.serverPort, this.endpoints, packetSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, this.heartBeatInterval, this.heartBeatIntervalUnit, this.identifierListener);
    }

    public TcpConfig heartBeatInterval(long heartBeatInterval, TimeUnit heartBeatIntervalUnit) {
        return new TcpConfig(this.serverPort, this.endpoints, this.packetSize, this.autoReconnectedUponDroppedConnection, this.throttlingConfig, heartBeatInterval, heartBeatIntervalUnit, this.identifierListener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpConfig that = (TcpConfig)o;
        if (this.autoReconnectedUponDroppedConnection != that.autoReconnectedUponDroppedConnection) {
            return false;
        }
        if (this.heartBeatInterval != that.heartBeatInterval) {
            return false;
        }
        if (this.packetSize != that.packetSize) {
            return false;
        }
        if (this.serverPort != that.serverPort) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.heartBeatIntervalUnit != that.heartBeatIntervalUnit) {
            return false;
        }
        return !(this.throttlingConfig != null ? !this.throttlingConfig.equals(that.throttlingConfig) : that.throttlingConfig != null);
    }

    public int hashCode() {
        int result = this.serverPort;
        result = 31 * result + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        result = 31 * result + this.packetSize;
        result = 31 * result + (this.autoReconnectedUponDroppedConnection ? 1 : 0);
        result = 31 * result + (this.throttlingConfig != null ? this.throttlingConfig.hashCode() : 0);
        result = 31 * result + (int)(this.heartBeatInterval ^ this.heartBeatInterval >>> 32);
        result = 31 * result + (this.heartBeatIntervalUnit != null ? this.heartBeatIntervalUnit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TcpReplicationConfig{serverPort=" + this.serverPort + ", endpoints=" + this.endpoints + ", packetSize=" + this.packetSize + ", autoReconnectedUponDroppedConnection=" + this.autoReconnectedUponDroppedConnection + ", throttlingConfig=" + this.throttlingConfig + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatIntervalUnit=" + (Object)((Object)this.heartBeatIntervalUnit) + '}';
    }
}

