/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.io.IOException;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.TcpConfig;
import net.openhft.chronicle.hash.replication.UdpConfig;

public final class ReplicationHub
extends AbstractReplication {
    private final int maxEntrySize;
    private final ReplicationChannel[] channels;

    public static Builder builder() {
        return new Builder();
    }

    private ReplicationHub(byte localIdentifier, Builder builder) {
        super(localIdentifier, builder);
        this.maxEntrySize = builder.maxEntrySize;
        this.channels = new ReplicationChannel[builder.maxNumberOfChronicles];
    }

    public int maxEntrySize() {
        return this.maxEntrySize;
    }

    public int maxNumberOfChannels() {
        return this.channels.length;
    }

    public synchronized ReplicationChannel createChannel(short channelId) {
        ReplicationChannel channel;
        if (channelId < 0) {
            throw new IllegalArgumentException("channelId should be positive");
        }
        if (channelId >= this.maxNumberOfChannels()) {
            throw new IllegalArgumentException("maxNumberOfChannels is configured (or defaulted) to " + this.maxNumberOfChannels() + ", channelId=" + channelId + " is requested");
        }
        if (this.channels[channelId] != null) {
            throw new IllegalArgumentException("The requested channelId=" + channelId + " is already in use");
        }
        this.channels[channelId] = channel = new ReplicationChannel(this, channelId);
        return channel;
    }

    public static final class Builder
    extends AbstractReplication.Builder<Builder> {
        private int maxEntrySize = 1024;
        private int maxNumberOfChronicles = 128;

        private Builder() {
        }

        @Override
        public Builder tcpTransportAndNetwork(TcpConfig tcpConfig) {
            return (Builder)super.tcpTransportAndNetwork(tcpConfig);
        }

        @Override
        public Builder udpTransport(UdpConfig udpConfig) {
            return (Builder)super.udpTransport(udpConfig);
        }

        public Builder maxEntrySize(int maxEntrySize) {
            this.maxEntrySize = maxEntrySize;
            return this;
        }

        public Builder maxNumberOfChannels(int maxNumberOfChannels) {
            this.maxNumberOfChronicles = maxNumberOfChannels;
            return this;
        }

        public ReplicationHub create(byte identifier) throws IOException {
            this.check();
            return new ReplicationHub(identifier, this);
        }
    }
}

