/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.threadlocal;

import java.util.concurrent.atomic.AtomicBoolean;

public final class ThreadLocalCopies {
    private static ThreadLocal<ThreadLocalCopies> states = new ThreadLocal<ThreadLocalCopies>(){

        @Override
        protected ThreadLocalCopies initialValue() {
            return new ThreadLocalCopies();
        }
    };
    AtomicBoolean currentlyAccessed = new AtomicBoolean(false);
    Object[] table;
    int size = 0;
    int sizeLimit;
    int mask;

    static ThreadLocalCopies get() {
        return states.get();
    }

    private ThreadLocalCopies() {
        this.init(32);
    }

    void init(int doubledCapacity) {
        this.table = new Object[doubledCapacity];
        this.sizeLimit = doubledCapacity / 3;
        this.mask = doubledCapacity - 1 & 0xFFFFFFFE;
    }

    void rehash() {
        Object[] oldTab = this.table;
        int oldCapacity = oldTab.length;
        if (oldCapacity == 0x40000000) {
            throw new IllegalStateException("Hash is full");
        }
        this.init(oldCapacity << 1);
        int m = this.mask;
        Object[] tab = this.table;
        for (int oldI = 0; oldI < oldCapacity; oldI += 2) {
            Object id = oldTab[oldI];
            if (id == null) continue;
            int i = System.identityHashCode(id) & m;
            while (tab[i] != null) {
                i = i + 2 & m;
            }
            tab[i] = id;
            tab[i + 1] = oldTab[oldI + 1];
        }
    }

    void postInsert() {
        if (++this.size > this.sizeLimit) {
            this.rehash();
        }
    }
}

