/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.EntryReader;
import net.openhft.chronicle.map.EntryWriter;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.UdpChannelReplicator;
import net.openhft.chronicle.map.UdpReplicationConfig;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdpReplicator
extends UdpChannelReplicator
implements Replica.ModificationNotifier,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)UdpReplicator.class.getName());

    UdpReplicator(@NotNull Replica replica, @NotNull Replica.EntryExternalizable entryExternalizable, @NotNull UdpReplicationConfig replicationConfig, int serializedEntrySize) throws IOException {
        super(replicationConfig, serializedEntrySize, replica.identifier());
        Replica.ModificationIterator modificationIterator = replica.acquireModificationIterator((short)128, this);
        this.setReader(new UdpSocketChannelEntryReader(serializedEntrySize, entryExternalizable));
        this.setWriter(new UdpSocketChannelEntryWriter(serializedEntrySize, entryExternalizable, modificationIterator, this));
        this.start();
    }

    private static class UdpSocketChannelEntryWriter
    implements EntryWriter {
        private final ByteBuffer out;
        private final ByteBufferBytes in;
        private final AbstractChannelReplicator.EntryCallback entryCallback;
        private final UdpChannelReplicator udpReplicator;
        private Replica.ModificationIterator modificationIterator;

        UdpSocketChannelEntryWriter(int serializedEntrySize, @NotNull Replica.EntryExternalizable externalizable, @NotNull Replica.ModificationIterator modificationIterator, UdpChannelReplicator udpReplicator) {
            this.udpReplicator = udpReplicator;
            this.out = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.in = new ByteBufferBytes(this.out);
            this.entryCallback = new AbstractChannelReplicator.EntryCallback(externalizable, this.in);
            this.modificationIterator = modificationIterator;
        }

        @Override
        public int writeAll(@NotNull DatagramChannel socketChannel) throws InterruptedException, IOException {
            this.out.clear();
            this.in.clear();
            this.in.skip(2L);
            boolean wasDataRead = this.modificationIterator.nextEntry(this.entryCallback, 0);
            if (!wasDataRead) {
                this.udpReplicator.disableWrites();
                return 0;
            }
            this.in.writeShort(0L, ~this.in.readUnsignedShort(2L));
            this.out.limit((int)this.in.position());
            return socketChannel.write(this.out);
        }
    }

    private static class UdpSocketChannelEntryReader
    implements EntryReader {
        private final Replica.EntryExternalizable externalizable;
        private final ByteBuffer in;
        private final ByteBufferBytes out;

        UdpSocketChannelEntryReader(int serializedEntrySize, @NotNull Replica.EntryExternalizable externalizable) {
            this.in = ByteBuffer.allocateDirect(serializedEntrySize * 2);
            this.externalizable = externalizable;
            this.out = new ByteBufferBytes(this.in);
            this.out.limit(0L);
            this.in.clear();
        }

        @Override
        public void readAll(@NotNull DatagramChannel socketChannel) throws IOException, InterruptedException {
            this.out.clear();
            this.in.clear();
            socketChannel.receive(this.in);
            int bytesRead = this.in.position();
            if (bytesRead < 4) {
                return;
            }
            this.out.limit((long)this.in.position());
            short invertedSize = this.out.readShort();
            int size = this.out.readUnsignedShort();
            if ((short)(~size) != invertedSize) {
                return;
            }
            if (this.out.remaining() != (long)size) {
                return;
            }
            this.externalizable.readExternalEntry((Bytes)this.out);
        }
    }
}

