/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MapErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapErrorListeners {
    public static MapErrorListener logging() {
        return LoggingErrorListener.INSTANCE;
    }

    public static MapErrorListener error() {
        return ThrowingErrorListener.INSTANCE;
    }

    private static enum ThrowingErrorListener implements MapErrorListener
    {
        INSTANCE;


        @Override
        public void onLockTimeout(long threadId) throws IllegalStateException {
            throw new IllegalStateException("Unable to acquire lock held by threadId: " + threadId);
        }

        @Override
        public void errorOnUnlock(IllegalMonitorStateException e) {
            throw e;
        }
    }

    private static enum LoggingErrorListener implements MapErrorListener
    {
        INSTANCE;

        final Logger LOG = LoggerFactory.getLogger(this.getClass());

        @Override
        public void onLockTimeout(long threadId) throws IllegalStateException {
            if (threadId > 0x100000000L) {
                this.LOG.warn("Grabbing lock held by processId: {}, threadId: {}", (Object)(threadId >>> 33), (Object)(threadId & 0xFFFFFFL));
            } else {
                this.LOG.warn("Grabbing lock held by threadId: {}", (Object)threadId);
            }
        }

        @Override
        public void errorOnUnlock(IllegalMonitorStateException e) {
            this.LOG.warn("Failed to unlock as expected", (Throwable)e);
        }
    }
}

