/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.logger.ChronicleLogManager;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.slf4j.ChronicleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.impl.SimpleLoggerFactory;

public class ChronicleLoggerFactory
implements ILoggerFactory {
    private final Map<String, Logger> loggers;
    private ChronicleLogManager manager;
    private final SimpleLoggerFactory fallback = new SimpleLoggerFactory();

    public ChronicleLoggerFactory() {
        this.loggers = new ConcurrentHashMap<String, Logger>();
        this.manager = ChronicleLogManager.getInstance();
    }

    public Logger getLogger(String name) {
        try {
            return this.doGetLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to initialize chronicle-logger-slf4j (" + name + ")\n  " + e.getMessage());
            return NOPLogger.NOP_LOGGER;
        }
    }

    synchronized void reload() {
        this.loggers.clear();
        this.manager.reload();
    }

    private synchronized Logger doGetLogger(String name) throws IOException {
        Object logger = this.loggers.get(name);
        if (logger == null) {
            if (name != null && name.startsWith("net.openhft")) {
                logger = this.fallback.getLogger(name);
            } else {
                ChronicleLogWriter writer = this.manager.getWriter(name);
                logger = new ChronicleLogger(writer, name, this.manager.cfg().getLevel(name));
            }
            this.loggers.put(name, (Logger)logger);
        }
        return logger;
    }
}

